/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.ChildNumber;
import org.bitcoinj.crypto.DeterministicKey;
import org.bitcoinj.crypto.HDUtils;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.LinuxSecureRandom;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.store.UnreadableWalletException;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.bitcoinj.wallet.AllRandomKeysRotating;
import org.bitcoinj.wallet.BasicKeyChain;
import org.bitcoinj.wallet.DefaultKeyChainFactory;
import org.bitcoinj.wallet.DeterministicKeyChain;
import org.bitcoinj.wallet.DeterministicSeed;
import org.bitcoinj.wallet.DeterministicUpgradeRequiredException;
import org.bitcoinj.wallet.DeterministicUpgradeRequiresPassword;
import org.bitcoinj.wallet.KeyBag;
import org.bitcoinj.wallet.KeyChain;
import org.bitcoinj.wallet.KeyChainEventListener;
import org.bitcoinj.wallet.KeyChainFactory;
import org.bitcoinj.wallet.MarriedKeyChain;
import org.bitcoinj.wallet.Protos;
import org.bitcoinj.wallet.RedeemData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;

public class KeyChainGroup
implements KeyBag {
    private static final Logger log;
    private BasicKeyChain basic;
    private NetworkParameters params;
    protected final LinkedList<DeterministicKeyChain> chains;
    private final EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys;
    private final EnumMap<KeyChain.KeyPurpose, Address> currentAddresses;
    @Nullable
    private KeyCrypter keyCrypter;
    private int lookaheadSize = -1;
    private int lookaheadThreshold = -1;

    public KeyChainGroup(NetworkParameters params) {
        this(params, null, new ArrayList<DeterministicKeyChain>(1), null, null);
    }

    public KeyChainGroup(NetworkParameters params, DeterministicSeed seed) {
        this(params, null, (List<DeterministicKeyChain>)ImmutableList.of((Object)new DeterministicKeyChain(seed)), null, null);
    }

    public KeyChainGroup(NetworkParameters params, DeterministicKey watchKey) {
        this(params, null, (List<DeterministicKeyChain>)ImmutableList.of((Object)DeterministicKeyChain.watch(watchKey)), null, null);
    }

    public KeyChainGroup(NetworkParameters params, DeterministicKey watchKey, long creationTimeSecondsSecs) {
        this(params, null, (List<DeterministicKeyChain>)ImmutableList.of((Object)DeterministicKeyChain.watch(watchKey, creationTimeSecondsSecs)), null, null);
    }

    private KeyChainGroup(NetworkParameters params, @Nullable BasicKeyChain basicKeyChain, List<DeterministicKeyChain> chains, @Nullable EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys, @Nullable KeyCrypter crypter) {
        this.params = params;
        this.basic = basicKeyChain == null ? new BasicKeyChain() : basicKeyChain;
        this.chains = new LinkedList((Collection)Preconditions.checkNotNull(chains));
        this.keyCrypter = crypter;
        this.currentKeys = currentKeys == null ? new EnumMap(KeyChain.KeyPurpose.class) : currentKeys;
        this.currentAddresses = new EnumMap(KeyChain.KeyPurpose.class);
        this.maybeLookaheadScripts();
        if (this.isMarried()) {
            for (Map.Entry<KeyChain.KeyPurpose, DeterministicKey> entry : this.currentKeys.entrySet()) {
                Address address = this.makeP2SHOutputScript(entry.getValue(), this.getActiveKeyChain()).getToAddress(params);
                this.currentAddresses.put((KeyChain.KeyPurpose)((Enum)entry.getKey()), address);
            }
        }
    }

    private void maybeLookaheadScripts() {
        for (DeterministicKeyChain chain : this.chains) {
            chain.maybeLookAheadScripts();
        }
    }

    public void createAndActivateNewHDChain() {
        DeterministicKeyChain chain = new DeterministicKeyChain(new SecureRandom());
        this.addAndActivateHDChain(chain);
    }

    public void addAndActivateHDChain(DeterministicKeyChain chain) {
        log.info("Creating and activating a new HD chain: {}", (Object)chain);
        for (ListenerRegistration<KeyChainEventListener> registration : this.basic.getListeners()) {
            chain.addEventListener((KeyChainEventListener)registration.listener, registration.executor);
        }
        if (this.lookaheadSize >= 0) {
            chain.setLookaheadSize(this.lookaheadSize);
        }
        if (this.lookaheadThreshold >= 0) {
            chain.setLookaheadThreshold(this.lookaheadThreshold);
        }
        this.chains.add(chain);
    }

    public DeterministicKey currentKey(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        if (chain.isMarried()) {
            throw new UnsupportedOperationException("Key is not suitable to receive coins for married keychains. Use freshAddress to get P2SH address instead");
        }
        DeterministicKey current = this.currentKeys.get((Object)purpose);
        if (current == null) {
            current = this.freshKey(purpose);
            this.currentKeys.put(purpose, current);
        }
        return current;
    }

    public Address currentAddress(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        if (chain.isMarried()) {
            Address current = this.currentAddresses.get((Object)purpose);
            if (current == null) {
                current = this.freshAddress(purpose);
                this.currentAddresses.put(purpose, current);
            }
            return current;
        }
        return this.currentKey(purpose).toAddress(this.params);
    }

    public DeterministicKey freshKey(KeyChain.KeyPurpose purpose) {
        return this.freshKeys(purpose, 1).get(0);
    }

    public List<DeterministicKey> freshKeys(KeyChain.KeyPurpose purpose, int numberOfKeys) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        if (chain.isMarried()) {
            throw new UnsupportedOperationException("Key is not suitable to receive coins for married keychains. Use freshAddress to get P2SH address instead");
        }
        return chain.getKeys(purpose, numberOfKeys);
    }

    public Address freshAddress(KeyChain.KeyPurpose purpose) {
        DeterministicKeyChain chain = this.getActiveKeyChain();
        if (chain.isMarried()) {
            Script outputScript = chain.freshOutputScript(purpose);
            Preconditions.checkState((boolean)outputScript.isPayToScriptHash());
            Address freshAddress = Address.fromP2SHScript(this.params, outputScript);
            this.maybeLookaheadScripts();
            this.currentAddresses.put(purpose, freshAddress);
            return freshAddress;
        }
        return this.freshKey(purpose).toAddress(this.params);
    }

    public DeterministicKeyChain getActiveKeyChain() {
        if (this.chains.isEmpty()) {
            if (this.basic.numKeys() > 0) {
                log.warn("No HD chain present but random keys are: you probably deserialized an old wallet.");
                throw new DeterministicUpgradeRequiredException();
            }
            this.createAndActivateNewHDChain();
        }
        return this.chains.get(this.chains.size() - 1);
    }

    public void setLookaheadSize(int lookaheadSize) {
        this.lookaheadSize = lookaheadSize;
        for (DeterministicKeyChain chain : this.chains) {
            chain.setLookaheadSize(lookaheadSize);
        }
    }

    public int getLookaheadSize() {
        if (this.lookaheadSize == -1) {
            return this.getActiveKeyChain().getLookaheadSize();
        }
        return this.lookaheadSize;
    }

    public void setLookaheadThreshold(int num) {
        for (DeterministicKeyChain chain : this.chains) {
            chain.setLookaheadThreshold(num);
        }
    }

    public int getLookaheadThreshold() {
        if (this.lookaheadThreshold == -1) {
            return this.getActiveKeyChain().getLookaheadThreshold();
        }
        return this.lookaheadThreshold;
    }

    public int importKeys(List<ECKey> keys) {
        return this.basic.importKeys(keys);
    }

    public int importKeys(ECKey ... keys) {
        return this.importKeys((List<ECKey>)ImmutableList.copyOf((Object[])keys));
    }

    public boolean checkPassword(CharSequence password) {
        Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
        return this.checkAESKey(this.keyCrypter.deriveKey(password));
    }

    public boolean checkAESKey(KeyParameter aesKey) {
        Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
        if (this.basic.numKeys() > 0) {
            return this.basic.checkAESKey(aesKey);
        }
        return this.getActiveKeyChain().checkAESKey(aesKey);
    }

    public int importKeysAndEncrypt(List<ECKey> keys, KeyParameter aesKey) {
        Preconditions.checkState((this.keyCrypter != null ? 1 : 0) != 0, (Object)"Not encrypted");
        LinkedList encryptedKeys = Lists.newLinkedList();
        for (ECKey key : keys) {
            if (key.isEncrypted()) {
                throw new IllegalArgumentException("Cannot provide already encrypted keys");
            }
            encryptedKeys.add(key.encrypt(this.keyCrypter, aesKey));
        }
        return this.importKeys(encryptedKeys);
    }

    @Override
    @Nullable
    public RedeemData findRedeemDataFromScriptHash(byte[] scriptHash) {
        Iterator<DeterministicKeyChain> iter = this.chains.descendingIterator();
        while (iter.hasNext()) {
            DeterministicKeyChain chain = iter.next();
            RedeemData redeemData = chain.findRedeemDataByScriptHash(ByteString.copyFrom((byte[])scriptHash));
            if (redeemData == null) continue;
            return redeemData;
        }
        return null;
    }

    public void markP2SHAddressAsUsed(Address address) {
        Preconditions.checkState((boolean)this.isMarried());
        Preconditions.checkArgument((boolean)address.isP2SHAddress());
        RedeemData data = this.findRedeemDataFromScriptHash(address.getHash160());
        if (data == null) {
            return;
        }
        for (ECKey key : data.keys) {
            for (DeterministicKeyChain chain : this.chains) {
                DeterministicKey k = chain.findKeyFromPubKey(key.getPubKey());
                if (k == null) continue;
                chain.markKeyAsUsed(k);
                this.maybeMarkCurrentAddressAsUsed(address);
            }
        }
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubHash(byte[] pubkeyHash) {
        ECKey result = this.basic.findKeyFromPubHash(pubkeyHash);
        if (result != null) {
            return result;
        }
        for (DeterministicKeyChain chain : this.chains) {
            result = chain.findKeyFromPubHash(pubkeyHash);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void markPubKeyHashAsUsed(byte[] pubkeyHash) {
        for (DeterministicKeyChain chain : this.chains) {
            DeterministicKey key = chain.markPubHashAsUsed(pubkeyHash);
            if (key == null) continue;
            this.maybeMarkCurrentKeyAsUsed(key);
            return;
        }
    }

    private void maybeMarkCurrentAddressAsUsed(Address address) {
        Preconditions.checkState((boolean)this.isMarried());
        Preconditions.checkArgument((boolean)address.isP2SHAddress());
        for (Map.Entry<KeyChain.KeyPurpose, Address> entry : this.currentAddresses.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(address)) continue;
            log.info("Marking P2SH address as used: {}", (Object)address);
            this.currentAddresses.put((KeyChain.KeyPurpose)((Enum)entry.getKey()), this.freshAddress(entry.getKey()));
            return;
        }
    }

    private void maybeMarkCurrentKeyAsUsed(DeterministicKey key) {
        for (Map.Entry<KeyChain.KeyPurpose, DeterministicKey> entry : this.currentKeys.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(key)) continue;
            log.info("Marking key as used: {}", (Object)key);
            this.currentKeys.put((KeyChain.KeyPurpose)((Enum)entry.getKey()), this.freshKey(entry.getKey()));
            return;
        }
    }

    public boolean hasKey(ECKey key) {
        if (this.basic.hasKey(key)) {
            return true;
        }
        for (DeterministicKeyChain chain : this.chains) {
            if (!chain.hasKey(key)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ECKey findKeyFromPubKey(byte[] pubkey) {
        ECKey result = this.basic.findKeyFromPubKey(pubkey);
        if (result != null) {
            return result;
        }
        for (DeterministicKeyChain chain : this.chains) {
            result = chain.findKeyFromPubKey(pubkey);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void markPubKeyAsUsed(byte[] pubkey) {
        for (DeterministicKeyChain chain : this.chains) {
            DeterministicKey key = chain.markPubKeyAsUsed(pubkey);
            if (key == null) continue;
            this.maybeMarkCurrentKeyAsUsed(key);
            return;
        }
    }

    public int numKeys() {
        int result = this.basic.numKeys();
        for (DeterministicKeyChain chain : this.chains) {
            result += chain.numKeys();
        }
        return result;
    }

    public boolean removeImportedKey(ECKey key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkArgument((!(key instanceof DeterministicKey) ? 1 : 0) != 0);
        return this.basic.removeKey(key);
    }

    public boolean isMarried() {
        return !this.chains.isEmpty() && this.getActiveKeyChain().isMarried();
    }

    public void encrypt(KeyCrypter keyCrypter, KeyParameter aesKey) {
        Preconditions.checkNotNull((Object)keyCrypter);
        Preconditions.checkNotNull((Object)aesKey);
        BasicKeyChain newBasic = this.basic.toEncrypted(keyCrypter, aesKey);
        ArrayList<DeterministicKeyChain> newChains = new ArrayList<DeterministicKeyChain>(this.chains.size());
        if (this.chains.isEmpty() && this.basic.numKeys() == 0) {
            this.createAndActivateNewHDChain();
        }
        for (DeterministicKeyChain chain : this.chains) {
            newChains.add(chain.toEncrypted(keyCrypter, aesKey));
        }
        this.keyCrypter = keyCrypter;
        this.basic = newBasic;
        this.chains.clear();
        this.chains.addAll(newChains);
    }

    public void decrypt(KeyParameter aesKey) {
        Preconditions.checkNotNull((Object)aesKey);
        BasicKeyChain newBasic = this.basic.toDecrypted(aesKey);
        ArrayList<DeterministicKeyChain> newChains = new ArrayList<DeterministicKeyChain>(this.chains.size());
        for (DeterministicKeyChain chain : this.chains) {
            newChains.add(chain.toDecrypted(aesKey));
        }
        this.keyCrypter = null;
        this.basic = newBasic;
        this.chains.clear();
        this.chains.addAll(newChains);
    }

    public boolean isEncrypted() {
        return this.keyCrypter != null;
    }

    public boolean isWatching() {
        BasicKeyChain.State basicState = this.basic.isWatching();
        BasicKeyChain.State activeState = BasicKeyChain.State.EMPTY;
        if (!this.chains.isEmpty()) {
            activeState = this.getActiveKeyChain().isWatching() ? BasicKeyChain.State.WATCHING : BasicKeyChain.State.REGULAR;
        }
        if (basicState == BasicKeyChain.State.EMPTY) {
            if (activeState == BasicKeyChain.State.EMPTY) {
                throw new IllegalStateException("Empty key chain group: cannot answer isWatching() query");
            }
            return activeState == BasicKeyChain.State.WATCHING;
        }
        if (activeState == BasicKeyChain.State.EMPTY) {
            return basicState == BasicKeyChain.State.WATCHING;
        }
        if (activeState != basicState) {
            throw new IllegalStateException("Mix of watching and non-watching keys in wallet");
        }
        return activeState == BasicKeyChain.State.WATCHING;
    }

    @Nullable
    public KeyCrypter getKeyCrypter() {
        return this.keyCrypter;
    }

    public List<ECKey> getImportedKeys() {
        return this.basic.getKeys();
    }

    public long getEarliestKeyCreationTime() {
        long time = this.basic.getEarliestKeyCreationTime();
        for (DeterministicKeyChain chain : this.chains) {
            time = Math.min(time, chain.getEarliestKeyCreationTime());
        }
        return time;
    }

    public int getBloomFilterElementCount() {
        int result = this.basic.numBloomFilterEntries();
        for (DeterministicKeyChain chain : this.chains) {
            result += chain.numBloomFilterEntries();
        }
        return result;
    }

    public BloomFilter getBloomFilter(int size, double falsePositiveRate, long nTweak) {
        BloomFilter filter = new BloomFilter(size, falsePositiveRate, nTweak);
        if (this.basic.numKeys() > 0) {
            filter.merge(this.basic.getFilter(size, falsePositiveRate, nTweak));
        }
        for (DeterministicKeyChain chain : this.chains) {
            filter.merge(chain.getFilter(size, falsePositiveRate, nTweak));
        }
        return filter;
    }

    public boolean isRequiringUpdateAllBloomFilter() {
        throw new UnsupportedOperationException();
    }

    private Script makeP2SHOutputScript(DeterministicKey followedKey, DeterministicKeyChain chain) {
        return ScriptBuilder.createP2SHOutputScript(chain.getRedeemData((DeterministicKey)followedKey).redeemScript);
    }

    public void addEventListener(KeyChainEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    public void addEventListener(KeyChainEventListener listener, Executor executor) {
        Preconditions.checkNotNull((Object)listener);
        Preconditions.checkNotNull((Object)executor);
        this.basic.addEventListener(listener, executor);
        for (DeterministicKeyChain chain : this.chains) {
            chain.addEventListener(listener, executor);
        }
    }

    public boolean removeEventListener(KeyChainEventListener listener) {
        Preconditions.checkNotNull((Object)listener);
        for (DeterministicKeyChain chain : this.chains) {
            chain.removeEventListener(listener);
        }
        return this.basic.removeEventListener(listener);
    }

    public List<Protos.Key> serializeToProtobuf() {
        List<Object> result = this.basic != null ? this.basic.serializeToProtobuf() : Lists.newArrayList();
        for (DeterministicKeyChain chain : this.chains) {
            List<Protos.Key> protos = chain.serializeToProtobuf();
            result.addAll(protos);
        }
        return result;
    }

    static KeyChainGroup fromProtobufUnencrypted(NetworkParameters params, List<Protos.Key> keys) throws UnreadableWalletException {
        return KeyChainGroup.fromProtobufUnencrypted(params, keys, new DefaultKeyChainFactory());
    }

    public static KeyChainGroup fromProtobufUnencrypted(NetworkParameters params, List<Protos.Key> keys, KeyChainFactory factory) throws UnreadableWalletException {
        BasicKeyChain basicKeyChain = BasicKeyChain.fromProtobufUnencrypted(keys);
        List<DeterministicKeyChain> chains = DeterministicKeyChain.fromProtobuf(keys, null, factory);
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = null;
        if (!chains.isEmpty()) {
            currentKeys = KeyChainGroup.createCurrentKeysMap(chains);
        }
        KeyChainGroup.extractFollowingKeychains(chains);
        return new KeyChainGroup(params, basicKeyChain, chains, currentKeys, null);
    }

    static KeyChainGroup fromProtobufEncrypted(NetworkParameters params, List<Protos.Key> keys, KeyCrypter crypter) throws UnreadableWalletException {
        return KeyChainGroup.fromProtobufEncrypted(params, keys, crypter, new DefaultKeyChainFactory());
    }

    public static KeyChainGroup fromProtobufEncrypted(NetworkParameters params, List<Protos.Key> keys, KeyCrypter crypter, KeyChainFactory factory) throws UnreadableWalletException {
        Preconditions.checkNotNull((Object)crypter);
        BasicKeyChain basicKeyChain = BasicKeyChain.fromProtobufEncrypted(keys, crypter);
        List<DeterministicKeyChain> chains = DeterministicKeyChain.fromProtobuf(keys, crypter, factory);
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = null;
        if (!chains.isEmpty()) {
            currentKeys = KeyChainGroup.createCurrentKeysMap(chains);
        }
        KeyChainGroup.extractFollowingKeychains(chains);
        return new KeyChainGroup(params, basicKeyChain, chains, currentKeys, crypter);
    }

    public DeterministicKeyChain upgradeToDeterministic(long keyRotationTimeSecs, @Nullable KeyParameter aesKey) throws DeterministicUpgradeRequiresPassword, AllRandomKeysRotating {
        Preconditions.checkState((this.basic.numKeys() > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((keyRotationTimeSecs >= 0L ? 1 : 0) != 0);
        ECKey keyToUse = this.basic.findOldestKeyAfter(keyRotationTimeSecs - 1L);
        if (keyToUse == null) {
            throw new AllRandomKeysRotating();
        }
        if (keyToUse.isEncrypted()) {
            if (aesKey == null) {
                throw new DeterministicUpgradeRequiresPassword();
            }
            keyToUse = keyToUse.decrypt(aesKey);
        } else if (aesKey != null) {
            throw new IllegalStateException("AES Key was provided but wallet is not encrypted.");
        }
        if (this.chains.isEmpty()) {
            log.info("Auto-upgrading pre-HD wallet to HD!");
        } else {
            log.info("Wallet with existing HD chain is being re-upgraded due to change in key rotation time.");
        }
        log.info("Instantiating new HD chain using oldest non-rotating private key (address: {})", (Object)keyToUse.toAddress(this.params));
        byte[] entropy = (byte[])Preconditions.checkNotNull((Object)keyToUse.getSecretBytes());
        Preconditions.checkState((entropy.length >= 16 ? 1 : 0) != 0);
        entropy = Arrays.copyOfRange(entropy, 0, 16);
        Preconditions.checkState((entropy.length == 16 ? 1 : 0) != 0);
        String passphrase = "";
        DeterministicKeyChain chain = new DeterministicKeyChain(entropy, passphrase, keyToUse.getCreationTimeSeconds());
        if (aesKey != null) {
            chain = chain.toEncrypted((KeyCrypter)Preconditions.checkNotNull((Object)this.basic.getKeyCrypter()), aesKey);
        }
        this.chains.add(chain);
        return chain;
    }

    public boolean isDeterministicUpgradeRequired() {
        return this.basic.numKeys() > 0 && this.chains.isEmpty();
    }

    private static EnumMap<KeyChain.KeyPurpose, DeterministicKey> createCurrentKeysMap(List<DeterministicKeyChain> chains) {
        DeterministicKeyChain activeChain = chains.get(chains.size() - 1);
        EnumMap<KeyChain.KeyPurpose, DeterministicKey> currentKeys = new EnumMap<KeyChain.KeyPurpose, DeterministicKey>(KeyChain.KeyPurpose.class);
        if (activeChain.getIssuedExternalKeys() > 0) {
            DeterministicKey currentExternalKey = activeChain.getKeyByPath((List<ChildNumber>)HDUtils.append(HDUtils.concat(activeChain.getAccountPath(), DeterministicKeyChain.EXTERNAL_SUBPATH), new ChildNumber(activeChain.getIssuedExternalKeys() - 1)));
            currentKeys.put(KeyChain.KeyPurpose.RECEIVE_FUNDS, currentExternalKey);
        }
        if (activeChain.getIssuedInternalKeys() > 0) {
            DeterministicKey currentInternalKey = activeChain.getKeyByPath((List<ChildNumber>)HDUtils.append(HDUtils.concat(activeChain.getAccountPath(), DeterministicKeyChain.INTERNAL_SUBPATH), new ChildNumber(activeChain.getIssuedInternalKeys() - 1)));
            currentKeys.put(KeyChain.KeyPurpose.CHANGE, currentInternalKey);
        }
        return currentKeys;
    }

    private static void extractFollowingKeychains(List<DeterministicKeyChain> chains) {
        ArrayList followingChains = Lists.newArrayList();
        Iterator<DeterministicKeyChain> it = chains.iterator();
        while (it.hasNext()) {
            DeterministicKeyChain chain = it.next();
            if (chain.isFollowing()) {
                followingChains.add(chain);
                it.remove();
                continue;
            }
            if (followingChains.isEmpty()) continue;
            if (!(chain instanceof MarriedKeyChain)) {
                throw new IllegalStateException();
            }
            ((MarriedKeyChain)chain).setFollowingKeyChains(followingChains);
            followingChains = Lists.newArrayList();
        }
    }

    public String toString(boolean includePrivateKeys) {
        StringBuilder builder = new StringBuilder();
        if (this.basic != null) {
            List<ECKey> keys = this.basic.getKeys();
            Collections.sort(keys, ECKey.AGE_COMPARATOR);
            for (ECKey key : keys) {
                key.formatKeyWithAddress(includePrivateKeys, builder, this.params);
            }
        }
        LinkedList chainStrs = Lists.newLinkedList();
        for (DeterministicKeyChain chain : this.chains) {
            chainStrs.add(chain.toString(includePrivateKeys, this.params));
        }
        builder.append(Joiner.on((String)String.format("%n", new Object[0])).join((Iterable)chainStrs));
        return builder.toString();
    }

    public List<DeterministicKeyChain> getDeterministicKeyChains() {
        return new ArrayList<DeterministicKeyChain>(this.chains);
    }

    public int getCombinedKeyLookaheadEpochs() {
        int epoch = 0;
        for (DeterministicKeyChain chain : this.chains) {
            epoch += chain.getKeyLookaheadEpoch();
        }
        return epoch;
    }

    static {
        if (Utils.isAndroidRuntime()) {
            new LinuxSecureRandom();
        }
        log = LoggerFactory.getLogger(KeyChainGroup.class);
    }
}

