/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.wallet;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import java.security.SecureRandom;
import java.util.List;
import javax.annotation.Nullable;
import org.bitcoinj.core.Utils;
import org.bitcoinj.crypto.EncryptableItem;
import org.bitcoinj.crypto.EncryptedData;
import org.bitcoinj.crypto.KeyCrypter;
import org.bitcoinj.crypto.MnemonicCode;
import org.bitcoinj.crypto.MnemonicException;
import org.bitcoinj.store.UnreadableWalletException;
import org.bitcoinj.wallet.Protos;
import org.spongycastle.crypto.params.KeyParameter;

public class DeterministicSeed
implements EncryptableItem {
    public static final int DEFAULT_SEED_ENTROPY_BITS = 128;
    public static final int MAX_SEED_ENTROPY_BITS = 512;
    @Nullable
    private final byte[] seed;
    @Nullable
    private final List<String> mnemonicCode;
    @Nullable
    private final EncryptedData encryptedMnemonicCode;
    @Nullable
    private EncryptedData encryptedSeed;
    private final long creationTimeSeconds;

    public DeterministicSeed(String mnemonicCode, byte[] seed, String passphrase, long creationTimeSeconds) throws UnreadableWalletException {
        this(DeterministicSeed.decodeMnemonicCode(mnemonicCode), seed, passphrase, creationTimeSeconds);
    }

    public DeterministicSeed(byte[] seed, List<String> mnemonic, long creationTimeSeconds) {
        this.seed = (byte[])Preconditions.checkNotNull((Object)seed);
        this.mnemonicCode = (List)Preconditions.checkNotNull(mnemonic);
        this.encryptedMnemonicCode = null;
        this.creationTimeSeconds = creationTimeSeconds;
    }

    public DeterministicSeed(EncryptedData encryptedMnemonic, @Nullable EncryptedData encryptedSeed, long creationTimeSeconds) {
        this.seed = null;
        this.mnemonicCode = null;
        this.encryptedMnemonicCode = (EncryptedData)Preconditions.checkNotNull((Object)encryptedMnemonic);
        this.encryptedSeed = encryptedSeed;
        this.creationTimeSeconds = creationTimeSeconds;
    }

    public DeterministicSeed(List<String> mnemonicCode, @Nullable byte[] seed, String passphrase, long creationTimeSeconds) {
        this(seed != null ? seed : MnemonicCode.toSeed(mnemonicCode, (String)Preconditions.checkNotNull((Object)passphrase)), mnemonicCode, creationTimeSeconds);
    }

    public DeterministicSeed(SecureRandom random, int bits, String passphrase, long creationTimeSeconds) {
        this(DeterministicSeed.getEntropy(random, bits), (String)Preconditions.checkNotNull((Object)passphrase), creationTimeSeconds);
    }

    public DeterministicSeed(byte[] entropy, String passphrase, long creationTimeSeconds) {
        Preconditions.checkArgument((entropy.length % 4 == 0 ? 1 : 0) != 0, (Object)"entropy size in bits not divisible by 32");
        Preconditions.checkArgument((entropy.length * 8 >= 128 ? 1 : 0) != 0, (Object)"entropy size too small");
        Preconditions.checkNotNull((Object)passphrase);
        try {
            this.mnemonicCode = MnemonicCode.INSTANCE.toMnemonic(entropy);
        }
        catch (MnemonicException.MnemonicLengthException e) {
            throw new RuntimeException(e);
        }
        this.seed = MnemonicCode.toSeed(this.mnemonicCode, passphrase);
        this.encryptedMnemonicCode = null;
        this.creationTimeSeconds = creationTimeSeconds;
    }

    private static byte[] getEntropy(SecureRandom random, int bits) {
        Preconditions.checkArgument((bits <= 512 ? 1 : 0) != 0, (Object)"requested entropy size too large");
        byte[] seed = new byte[bits / 8];
        random.nextBytes(seed);
        return seed;
    }

    @Override
    public boolean isEncrypted() {
        Preconditions.checkState((this.mnemonicCode != null || this.encryptedMnemonicCode != null ? 1 : 0) != 0);
        return this.encryptedMnemonicCode != null;
    }

    public String toString() {
        return this.isEncrypted() ? "DeterministicSeed [encrypted]" : "DeterministicSeed " + this.toHexString() + " " + Utils.join(this.mnemonicCode);
    }

    @Nullable
    public String toHexString() {
        return this.seed != null ? Utils.HEX.encode(this.seed) : null;
    }

    @Override
    @Nullable
    public byte[] getSecretBytes() {
        return this.getMnemonicAsBytes();
    }

    @Nullable
    public byte[] getSeedBytes() {
        return this.seed;
    }

    @Override
    @Nullable
    public EncryptedData getEncryptedData() {
        return this.encryptedMnemonicCode;
    }

    @Override
    public Protos.Wallet.EncryptionType getEncryptionType() {
        return Protos.Wallet.EncryptionType.ENCRYPTED_SCRYPT_AES;
    }

    @Nullable
    public EncryptedData getEncryptedSeedData() {
        return this.encryptedSeed;
    }

    @Override
    public long getCreationTimeSeconds() {
        return this.creationTimeSeconds;
    }

    public DeterministicSeed encrypt(KeyCrypter keyCrypter, KeyParameter aesKey) {
        Preconditions.checkState((this.encryptedMnemonicCode == null ? 1 : 0) != 0, (Object)"Trying to encrypt seed twice");
        Preconditions.checkState((this.mnemonicCode != null ? 1 : 0) != 0, (Object)"Mnemonic missing so cannot encrypt");
        EncryptedData encryptedMnemonic = keyCrypter.encrypt(this.getMnemonicAsBytes(), aesKey);
        EncryptedData encryptedSeed = keyCrypter.encrypt(this.seed, aesKey);
        return new DeterministicSeed(encryptedMnemonic, encryptedSeed, this.creationTimeSeconds);
    }

    private byte[] getMnemonicAsBytes() {
        return Utils.join(this.mnemonicCode).getBytes(Charsets.UTF_8);
    }

    public DeterministicSeed decrypt(KeyCrypter crypter, String passphrase, KeyParameter aesKey) {
        Preconditions.checkState((boolean)this.isEncrypted());
        Preconditions.checkNotNull((Object)this.encryptedMnemonicCode);
        List<String> mnemonic = DeterministicSeed.decodeMnemonicCode(crypter.decrypt(this.encryptedMnemonicCode, aesKey));
        byte[] seed = this.encryptedSeed == null ? null : crypter.decrypt(this.encryptedSeed, aesKey);
        return new DeterministicSeed(mnemonic, seed, passphrase, this.creationTimeSeconds);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeterministicSeed seed = (DeterministicSeed)o;
        if (this.creationTimeSeconds != seed.creationTimeSeconds) {
            return false;
        }
        if (this.encryptedMnemonicCode != null) {
            if (seed.encryptedMnemonicCode == null) {
                return false;
            }
            if (!this.encryptedMnemonicCode.equals(seed.encryptedMnemonicCode)) {
                return false;
            }
        } else if (!this.mnemonicCode.equals(seed.mnemonicCode)) {
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.encryptedMnemonicCode != null ? this.encryptedMnemonicCode.hashCode() : this.mnemonicCode.hashCode();
        result = 31 * result + (int)(this.creationTimeSeconds ^ this.creationTimeSeconds >>> 32);
        return result;
    }

    public void check() throws MnemonicException {
        if (this.mnemonicCode != null) {
            MnemonicCode.INSTANCE.check(this.mnemonicCode);
        }
    }

    byte[] getEntropyBytes() throws MnemonicException {
        return MnemonicCode.INSTANCE.toEntropy(this.mnemonicCode);
    }

    @Nullable
    public List<String> getMnemonicCode() {
        return this.mnemonicCode;
    }

    private static List<String> decodeMnemonicCode(byte[] mnemonicCode) {
        return DeterministicSeed.decodeMnemonicCode(Utils.toString(mnemonicCode, "UTF-8"));
    }

    private static List<String> decodeMnemonicCode(String mnemonicCode) {
        return Splitter.on((String)" ").splitToList((CharSequence)mnemonicCode);
    }
}

