/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.net.InetSocketAddress;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.MemoryPoolMessage;
import org.bitcoinj.core.NotFoundMessage;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerGroup;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VersionAck;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.net.BlockingClientManager;
import org.bitcoinj.net.ClientConnectionManager;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.testing.InboundMessageQueuer;
import org.bitcoinj.testing.TestWithNetworkConnections;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;

public class TestWithPeerGroup
extends TestWithNetworkConnections {
    protected PeerGroup peerGroup;
    protected VersionMessage remoteVersionMessage;
    private final TestWithNetworkConnections.ClientType clientType;
    protected boolean blockJobs = false;
    protected final Semaphore jobBlocks = new Semaphore(0);

    public TestWithPeerGroup(TestWithNetworkConnections.ClientType clientType) {
        super(clientType);
        if (clientType != TestWithNetworkConnections.ClientType.NIO_CLIENT_MANAGER && clientType != TestWithNetworkConnections.ClientType.BLOCKING_CLIENT_MANAGER) {
            throw new RuntimeException();
        }
        this.clientType = clientType;
    }

    @Override
    public void setUp() throws Exception {
        this.setUp(new MemoryBlockStore(this.params));
    }

    @Override
    public void setUp(BlockStore blockStore) throws Exception {
        super.setUp(blockStore);
        this.remoteVersionMessage = new VersionMessage(this.params, 1);
        this.remoteVersionMessage.localServices = 1L;
        this.remoteVersionMessage.clientVersion = NotFoundMessage.MIN_PROTOCOL_VERSION;
        this.blockJobs = false;
        this.initPeerGroup();
    }

    @Override
    public void tearDown() {
        try {
            super.tearDown();
            this.blockJobs = false;
            Utils.finishMockSleep();
            if (this.peerGroup.isRunning()) {
                this.peerGroup.stopAsync();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void initPeerGroup() {
        this.peerGroup = this.clientType == TestWithNetworkConnections.ClientType.NIO_CLIENT_MANAGER ? this.createPeerGroup(new NioClientManager()) : this.createPeerGroup(new BlockingClientManager());
        this.peerGroup.setPingIntervalMsec(0L);
        this.peerGroup.addWallet(this.wallet);
        this.peerGroup.setUseLocalhostPeerWhenPossible(false);
    }

    private PeerGroup createPeerGroup(ClientConnectionManager manager) {
        return new PeerGroup(this.params, this.blockChain, manager){

            @Override
            protected ListeningScheduledExecutorService createPrivateExecutor() {
                return MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, new ContextPropagatingThreadFactory("PeerGroup test thread")){

                    @Override
                    public ScheduledFuture<?> schedule(final Runnable command, final long delay, final TimeUnit unit) {
                        if (!TestWithPeerGroup.this.blockJobs) {
                            return super.schedule(command, delay, unit);
                        }
                        return super.schedule(new Runnable(){

                            @Override
                            public void run() {
                                Utils.rollMockClockMillis(unit.toMillis(delay));
                                command.run();
                                TestWithPeerGroup.this.jobBlocks.acquireUninterruptibly();
                            }
                        }, 0L, unit);
                    }
                });
            }
        };
    }

    protected InboundMessageQueuer connectPeerWithoutVersionExchange(int id) throws Exception {
        Preconditions.checkArgument((id < 5 ? 1 : 0) != 0);
        InetSocketAddress remoteAddress = new InetSocketAddress("127.0.0.1", 2000 + id);
        Peer peer = (Peer)this.peerGroup.connectTo(remoteAddress).getConnectionOpenFuture().get();
        InboundMessageQueuer writeTarget = (InboundMessageQueuer)this.newPeerWriteTargetQueue.take();
        writeTarget.peer = peer;
        return writeTarget;
    }

    protected InboundMessageQueuer connectPeer(int id) throws Exception {
        return this.connectPeer(id, this.remoteVersionMessage);
    }

    protected InboundMessageQueuer connectPeer(int id, VersionMessage versionMessage) throws Exception {
        Preconditions.checkArgument((boolean)versionMessage.hasBlockChain());
        InboundMessageQueuer writeTarget = this.connectPeerWithoutVersionExchange(id);
        writeTarget.sendMessage(versionMessage);
        writeTarget.sendMessage(new VersionAck());
        this.stepThroughInit(versionMessage, writeTarget);
        return writeTarget;
    }

    protected InboundMessageQueuer handleConnectToPeer(int id) throws Exception {
        return this.handleConnectToPeer(id, this.remoteVersionMessage);
    }

    protected InboundMessageQueuer handleConnectToPeer(int id, VersionMessage versionMessage) throws Exception {
        InboundMessageQueuer writeTarget = (InboundMessageQueuer)this.newPeerWriteTargetQueue.take();
        Preconditions.checkArgument((boolean)versionMessage.hasBlockChain());
        writeTarget.sendMessage(versionMessage);
        writeTarget.sendMessage(new VersionAck());
        this.stepThroughInit(versionMessage, writeTarget);
        return writeTarget;
    }

    private void stepThroughInit(VersionMessage versionMessage, InboundMessageQueuer writeTarget) throws InterruptedException {
        Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof VersionMessage));
        Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof VersionAck));
        if (versionMessage.isBloomFilteringSupported()) {
            Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof BloomFilter));
            Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof MemoryPoolMessage));
        }
    }
}

