/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.testing;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import org.bitcoinj.core.AbstractPeerEventListener;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.BlockChain;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.Ping;
import org.bitcoinj.core.Pong;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.VersionAck;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.net.BlockingClient;
import org.bitcoinj.net.BlockingClientManager;
import org.bitcoinj.net.ClientConnectionManager;
import org.bitcoinj.net.NioClient;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.NioServer;
import org.bitcoinj.net.StreamParser;
import org.bitcoinj.net.StreamParserFactory;
import org.bitcoinj.params.UnitTestParams;
import org.bitcoinj.store.BlockStore;
import org.bitcoinj.store.MemoryBlockStore;
import org.bitcoinj.testing.InboundMessageQueuer;
import org.bitcoinj.utils.BriefLogFormatter;
import org.bitcoinj.utils.Threading;

public class TestWithNetworkConnections {
    public static final int PEER_SERVERS = 5;
    protected final NetworkParameters params = UnitTestParams.get();
    protected Context context;
    protected BlockStore blockStore;
    protected BlockChain blockChain;
    protected Wallet wallet;
    protected ECKey key;
    protected Address address;
    protected SocketAddress socketAddress;
    private NioServer[] peerServers = new NioServer[5];
    private final ClientConnectionManager channels;
    protected final BlockingQueue<InboundMessageQueuer> newPeerWriteTargetQueue = new LinkedBlockingQueue<InboundMessageQueuer>();
    private final ClientType clientType;

    public TestWithNetworkConnections(ClientType clientType) {
        this.clientType = clientType;
        this.channels = clientType == ClientType.NIO_CLIENT_MANAGER ? new NioClientManager() : (clientType == ClientType.BLOCKING_CLIENT_MANAGER ? new BlockingClientManager() : null);
    }

    public void setUp() throws Exception {
        this.setUp(new MemoryBlockStore(UnitTestParams.get()));
    }

    public void setUp(BlockStore blockStore) throws Exception {
        BriefLogFormatter.init();
        this.context = new Context(this.params);
        Wallet.SendRequest.DEFAULT_FEE_PER_KB = Coin.ZERO;
        this.blockStore = blockStore;
        if (this.wallet == null) {
            this.wallet = new Wallet(this.params);
            this.key = this.wallet.freshReceiveKey();
            this.address = this.key.toAddress(this.params);
        }
        this.blockChain = new BlockChain(this.params, this.wallet, blockStore);
        this.startPeerServers();
        if (this.clientType == ClientType.NIO_CLIENT_MANAGER || this.clientType == ClientType.BLOCKING_CLIENT_MANAGER) {
            this.channels.startAsync();
            this.channels.awaitRunning();
        }
        this.socketAddress = new InetSocketAddress("127.0.0.1", 1111);
    }

    protected void startPeerServers() throws IOException {
        for (int i = 0; i < 5; ++i) {
            this.startPeerServer(i);
        }
    }

    protected void startPeerServer(int i) throws IOException {
        this.peerServers[i] = new NioServer(new StreamParserFactory(){

            @Override
            @Nullable
            public StreamParser getNewParser(InetAddress inetAddress, int port) {
                return new InboundMessageQueuer(TestWithNetworkConnections.this.params){

                    @Override
                    public void connectionClosed() {
                    }

                    @Override
                    public void connectionOpened() {
                        TestWithNetworkConnections.this.newPeerWriteTargetQueue.offer(this);
                    }
                };
            }
        }, new InetSocketAddress("127.0.0.1", 2000 + i));
        this.peerServers[i].startAsync();
        this.peerServers[i].awaitRunning();
    }

    public void tearDown() throws Exception {
        Wallet.SendRequest.DEFAULT_FEE_PER_KB = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE;
        this.stopPeerServers();
    }

    protected void stopPeerServers() {
        for (int i = 0; i < 5; ++i) {
            this.stopPeerServer(i);
        }
    }

    protected void stopPeerServer(int i) {
        this.peerServers[i].stopAsync();
        this.peerServers[i].awaitTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InboundMessageQueuer connect(Peer peer, VersionMessage versionMessage) throws Exception {
        Preconditions.checkArgument((boolean)versionMessage.hasBlockChain());
        final AtomicBoolean doneConnecting = new AtomicBoolean(false);
        final Thread thisThread = Thread.currentThread();
        peer.addEventListener(new AbstractPeerEventListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPeerDisconnected(Peer p, int peerCount) {
                AtomicBoolean atomicBoolean = doneConnecting;
                synchronized (atomicBoolean) {
                    if (!doneConnecting.get()) {
                        thisThread.interrupt();
                    }
                }
            }
        });
        if (this.clientType == ClientType.NIO_CLIENT_MANAGER || this.clientType == ClientType.BLOCKING_CLIENT_MANAGER) {
            this.channels.openConnection(new InetSocketAddress("127.0.0.1", 2000), peer);
        } else if (this.clientType == ClientType.NIO_CLIENT) {
            new NioClient(new InetSocketAddress("127.0.0.1", 2000), peer, 100);
        } else if (this.clientType == ClientType.BLOCKING_CLIENT) {
            new BlockingClient(new InetSocketAddress("127.0.0.1", 2000), peer, 100, SocketFactory.getDefault(), null);
        } else {
            throw new RuntimeException();
        }
        InboundMessageQueuer writeTarget = this.newPeerWriteTargetQueue.take();
        writeTarget.peer = peer;
        Preconditions.checkState((!peer.getVersionHandshakeFuture().isDone() ? 1 : 0) != 0);
        writeTarget.sendMessage(versionMessage);
        writeTarget.sendMessage(new VersionAck());
        try {
            Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof VersionMessage));
            Preconditions.checkState((boolean)(writeTarget.nextMessageBlocking() instanceof VersionAck));
            peer.getVersionHandshakeFuture().get();
            AtomicBoolean atomicBoolean = doneConnecting;
            synchronized (atomicBoolean) {
                doneConnecting.set(true);
            }
            Thread.interrupted();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return writeTarget;
    }

    protected void closePeer(Peer peer) throws Exception {
        peer.close();
    }

    protected void inbound(InboundMessageQueuer peerChannel, Message message) {
        peerChannel.sendMessage(message);
    }

    private void outboundPingAndWait(InboundMessageQueuer p, long nonce) throws Exception {
        SettableFuture pingReceivedFuture = SettableFuture.create();
        p.mapPingFutures.put(nonce, (SettableFuture<Void>)pingReceivedFuture);
        p.peer.sendMessage(new Ping(nonce));
        pingReceivedFuture.get();
        p.mapPingFutures.remove(nonce);
    }

    private void inboundPongAndWait(InboundMessageQueuer p, final long nonce) throws Exception {
        final SettableFuture pongReceivedFuture = SettableFuture.create();
        AbstractPeerEventListener listener = new AbstractPeerEventListener(){

            @Override
            public Message onPreMessageReceived(Peer p, Message m) {
                if (m instanceof Pong && ((Pong)m).getNonce() == nonce) {
                    pongReceivedFuture.set(null);
                    return null;
                }
                return m;
            }
        };
        p.peer.addEventListener(listener, Threading.SAME_THREAD);
        this.inbound(p, new Pong(nonce));
        pongReceivedFuture.get();
        p.peer.removeEventListener(listener);
    }

    protected void pingAndWait(InboundMessageQueuer p) throws Exception {
        long nonce = (long)(Math.random() * 9.223372036854776E18);
        this.inboundPongAndWait(p, nonce);
        this.outboundPingAndWait(p, nonce);
    }

    protected Message outbound(InboundMessageQueuer p1) throws Exception {
        this.pingAndWait(p1);
        return p1.nextMessage();
    }

    protected Message waitForOutbound(InboundMessageQueuer ch) throws InterruptedException {
        return ch.nextMessageBlocking();
    }

    protected Peer peerOf(InboundMessageQueuer ch) {
        return ch.peer;
    }

    public static enum ClientType {
        NIO_CLIENT_MANAGER,
        BLOCKING_CLIENT_MANAGER,
        NIO_CLIENT,
        BLOCKING_CLIENT;

    }
}

