/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.payments;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.bitcoin.protocols.payments.Protos;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.crypto.TrustStoreLoader;
import org.bitcoinj.params.MainNetParams;
import org.bitcoinj.protocols.payments.PaymentProtocol;
import org.bitcoinj.protocols.payments.PaymentProtocolException;
import org.bitcoinj.uri.BitcoinURI;
import org.bitcoinj.utils.Threading;

public class PaymentSession {
    private static ListeningExecutorService executor = Threading.THREAD_POOL;
    private NetworkParameters params;
    private Protos.PaymentRequest paymentRequest;
    private Protos.PaymentDetails paymentDetails;
    private Coin totalValue = Coin.ZERO;
    @Nullable
    public final PaymentProtocol.PkiVerificationData pkiVerificationData;

    public static ListenableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri) throws PaymentProtocolException {
        return PaymentSession.createFromBitcoinUri(uri, true, null);
    }

    public static ListenableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri, boolean verifyPki) throws PaymentProtocolException {
        return PaymentSession.createFromBitcoinUri(uri, verifyPki, null);
    }

    public static ListenableFuture<PaymentSession> createFromBitcoinUri(BitcoinURI uri, boolean verifyPki, @Nullable TrustStoreLoader trustStoreLoader) throws PaymentProtocolException {
        String url = uri.getPaymentRequestUrl();
        if (url == null) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL("No payment request URL (r= parameter) in BitcoinURI " + uri);
        }
        try {
            return PaymentSession.fetchPaymentRequest(new URI(url), verifyPki, trustStoreLoader);
        }
        catch (URISyntaxException e) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL(e);
        }
    }

    public static ListenableFuture<PaymentSession> createFromUrl(String url) throws PaymentProtocolException {
        return PaymentSession.createFromUrl(url, true, null);
    }

    public static ListenableFuture<PaymentSession> createFromUrl(String url, boolean verifyPki) throws PaymentProtocolException {
        return PaymentSession.createFromUrl(url, verifyPki, null);
    }

    public static ListenableFuture<PaymentSession> createFromUrl(String url, boolean verifyPki, @Nullable TrustStoreLoader trustStoreLoader) throws PaymentProtocolException {
        if (url == null) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL("null paymentRequestUrl");
        }
        try {
            return PaymentSession.fetchPaymentRequest(new URI(url), verifyPki, trustStoreLoader);
        }
        catch (URISyntaxException e) {
            throw new PaymentProtocolException.InvalidPaymentRequestURL(e);
        }
    }

    private static ListenableFuture<PaymentSession> fetchPaymentRequest(final URI uri, final boolean verifyPki, final @Nullable TrustStoreLoader trustStoreLoader) {
        return executor.submit((Callable)new Callable<PaymentSession>(){

            @Override
            public PaymentSession call() throws Exception {
                HttpURLConnection connection = (HttpURLConnection)uri.toURL().openConnection();
                connection.setRequestProperty("Accept", "application/bitcoin-paymentrequest");
                connection.setUseCaches(false);
                Protos.PaymentRequest paymentRequest = Protos.PaymentRequest.parseFrom(connection.getInputStream());
                return new PaymentSession(paymentRequest, verifyPki, trustStoreLoader);
            }
        });
    }

    public PaymentSession(Protos.PaymentRequest request) throws PaymentProtocolException {
        this(request, true, null);
    }

    public PaymentSession(Protos.PaymentRequest request, boolean verifyPki) throws PaymentProtocolException {
        this(request, verifyPki, null);
    }

    public PaymentSession(Protos.PaymentRequest request, boolean verifyPki, @Nullable TrustStoreLoader trustStoreLoader) throws PaymentProtocolException {
        TrustStoreLoader nonNullTrustStoreLoader = trustStoreLoader != null ? trustStoreLoader : new TrustStoreLoader.DefaultTrustStoreLoader();
        this.parsePaymentRequest(request);
        if (verifyPki) {
            try {
                this.pkiVerificationData = PaymentProtocol.verifyPaymentRequestPki(request, nonNullTrustStoreLoader.getKeyStore());
            }
            catch (IOException x) {
                throw new PaymentProtocolException(x);
            }
            catch (KeyStoreException x) {
                throw new PaymentProtocolException(x);
            }
        } else {
            this.pkiVerificationData = null;
        }
    }

    public List<PaymentProtocol.Output> getOutputs() {
        ArrayList<PaymentProtocol.Output> outputs = new ArrayList<PaymentProtocol.Output>(this.paymentDetails.getOutputsCount());
        for (Protos.Output output : this.paymentDetails.getOutputsList()) {
            Coin amount = output.hasAmount() ? Coin.valueOf(output.getAmount()) : null;
            outputs.add(new PaymentProtocol.Output(amount, output.getScript().toByteArray()));
        }
        return outputs;
    }

    @Nullable
    public String getMemo() {
        if (this.paymentDetails.hasMemo()) {
            return this.paymentDetails.getMemo();
        }
        return null;
    }

    public Coin getValue() {
        return this.totalValue;
    }

    public Date getDate() {
        return new Date(this.paymentDetails.getTime() * 1000L);
    }

    @Nullable
    public Date getExpires() {
        if (this.paymentDetails.hasExpires()) {
            return new Date(this.paymentDetails.getExpires() * 1000L);
        }
        return null;
    }

    public boolean isExpired() {
        return this.paymentDetails.hasExpires() && System.currentTimeMillis() / 1000L > this.paymentDetails.getExpires();
    }

    @Nullable
    public String getPaymentUrl() {
        if (this.paymentDetails.hasPaymentUrl()) {
            return this.paymentDetails.getPaymentUrl();
        }
        return null;
    }

    @Nullable
    public byte[] getMerchantData() {
        if (this.paymentDetails.hasMerchantData()) {
            return this.paymentDetails.getMerchantData().toByteArray();
        }
        return null;
    }

    public Wallet.SendRequest getSendRequest() {
        Transaction tx = new Transaction(this.params);
        for (Protos.Output output : this.paymentDetails.getOutputsList()) {
            tx.addOutput(new TransactionOutput(this.params, tx, Coin.valueOf(output.getAmount()), output.getScript().toByteArray()));
        }
        return Wallet.SendRequest.forTx(tx).fromPaymentDetails(this.paymentDetails);
    }

    @Nullable
    public ListenableFuture<PaymentProtocol.Ack> sendPayment(List<Transaction> txns, @Nullable Address refundAddr, @Nullable String memo) throws PaymentProtocolException, VerificationException, IOException {
        URL url;
        Protos.Payment payment = this.getPayment(txns, refundAddr, memo);
        if (payment == null) {
            return null;
        }
        if (this.isExpired()) {
            throw new PaymentProtocolException.Expired("PaymentRequest is expired");
        }
        try {
            url = new URL(this.paymentDetails.getPaymentUrl());
        }
        catch (MalformedURLException e) {
            throw new PaymentProtocolException.InvalidPaymentURL(e);
        }
        return this.sendPayment(url, payment);
    }

    @Nullable
    public Protos.Payment getPayment(List<Transaction> txns, @Nullable Address refundAddr, @Nullable String memo) throws IOException, PaymentProtocolException.InvalidNetwork {
        if (this.paymentDetails.hasPaymentUrl()) {
            for (Transaction tx : txns) {
                if (tx.getParams().equals(this.params)) continue;
                throw new PaymentProtocolException.InvalidNetwork(this.params.getPaymentProtocolId());
            }
            return PaymentProtocol.createPaymentMessage(txns, this.totalValue, refundAddr, memo, this.getMerchantData());
        }
        return null;
    }

    @VisibleForTesting
    protected ListenableFuture<PaymentProtocol.Ack> sendPayment(final URL url, final Protos.Payment payment) {
        return executor.submit((Callable)new Callable<PaymentProtocol.Ack>(){

            @Override
            public PaymentProtocol.Ack call() throws Exception {
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("POST");
                connection.setRequestProperty("Content-Type", "application/bitcoin-payment");
                connection.setRequestProperty("Accept", "application/bitcoin-paymentack");
                connection.setRequestProperty("Content-Length", Integer.toString(payment.getSerializedSize()));
                connection.setUseCaches(false);
                connection.setDoInput(true);
                connection.setDoOutput(true);
                DataOutputStream outStream = new DataOutputStream(connection.getOutputStream());
                payment.writeTo(outStream);
                outStream.flush();
                outStream.close();
                Protos.PaymentACK paymentAck = Protos.PaymentACK.parseFrom(connection.getInputStream());
                return PaymentProtocol.parsePaymentAck(paymentAck);
            }
        });
    }

    private void parsePaymentRequest(Protos.PaymentRequest request) throws PaymentProtocolException {
        try {
            if (request == null) {
                throw new PaymentProtocolException("request cannot be null");
            }
            if (request.getPaymentDetailsVersion() != 1) {
                throw new PaymentProtocolException.InvalidVersion("Version 1 required. Received version " + request.getPaymentDetailsVersion());
            }
            this.paymentRequest = request;
            if (!request.hasSerializedPaymentDetails()) {
                throw new PaymentProtocolException("No PaymentDetails");
            }
            this.paymentDetails = ((Protos.PaymentDetails.Builder)Protos.PaymentDetails.newBuilder().mergeFrom(request.getSerializedPaymentDetails())).build();
            if (this.paymentDetails == null) {
                throw new PaymentProtocolException("Invalid PaymentDetails");
            }
            this.params = !this.paymentDetails.hasNetwork() ? MainNetParams.get() : NetworkParameters.fromPmtProtocolID(this.paymentDetails.getNetwork());
            if (this.params == null) {
                throw new PaymentProtocolException.InvalidNetwork("Invalid network " + this.paymentDetails.getNetwork());
            }
            if (this.paymentDetails.getOutputsCount() < 1) {
                throw new PaymentProtocolException.InvalidOutputs("No outputs");
            }
            for (Protos.Output output : this.paymentDetails.getOutputsList()) {
                if (!output.hasAmount()) continue;
                this.totalValue = this.totalValue.add(Coin.valueOf(output.getAmount()));
            }
            if (this.params.hasMaxMoney() && this.totalValue.compareTo(this.params.getMaxMoney()) > 0) {
                throw new PaymentProtocolException.InvalidOutputs("The outputs are way too big.");
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw new PaymentProtocolException((Exception)((Object)e));
        }
    }

    @Nullable
    public PaymentProtocol.PkiVerificationData verifyPki() {
        return this.pkiVerificationData;
    }

    public NetworkParameters getNetworkParameters() {
        return this.params;
    }

    public Protos.PaymentRequest getPaymentRequest() {
        return this.paymentRequest;
    }

    public Protos.PaymentDetails getPaymentDetails() {
        return this.paymentDetails;
    }
}

