/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.core.WalletExtension;
import org.bitcoinj.protocols.channels.ServerState;
import org.bitcoinj.protocols.channels.StoredServerChannel;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoredPaymentChannelServerStates
implements WalletExtension {
    private static final Logger log = LoggerFactory.getLogger(StoredPaymentChannelServerStates.class);
    static final String EXTENSION_ID = StoredPaymentChannelServerStates.class.getName();
    static final int MAX_SECONDS_TO_WAIT_FOR_BROADCASTER_TO_BE_SET = 10;
    @GuardedBy(value="lock")
    @VisibleForTesting
    final Map<Sha256Hash, StoredServerChannel> mapChannels = new HashMap<Sha256Hash, StoredServerChannel>();
    private Wallet wallet;
    private final SettableFuture<TransactionBroadcaster> broadcasterFuture = SettableFuture.create();
    private final Timer channelTimeoutHandler = new Timer(true);
    private final ReentrantLock lock = Threading.lock("StoredPaymentChannelServerStates");
    public static final long CHANNEL_EXPIRE_OFFSET = -7200L;

    public StoredPaymentChannelServerStates(@Nullable Wallet wallet, TransactionBroadcaster broadcaster) {
        this.setTransactionBroadcaster(broadcaster);
        this.wallet = wallet;
    }

    public StoredPaymentChannelServerStates(@Nullable Wallet wallet) {
        this.wallet = wallet;
    }

    public void setTransactionBroadcaster(TransactionBroadcaster broadcaster) {
        this.broadcasterFuture.set(Preconditions.checkNotNull((Object)broadcaster));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannel(StoredServerChannel channel) {
        this.lock.lock();
        try {
            if (this.mapChannels.remove(channel.contract.getHash()) == null) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        StoredServerChannel storedServerChannel = channel;
        synchronized (storedServerChannel) {
            channel.closeConnectedHandler();
            try {
                TransactionBroadcaster broadcaster = this.getBroadcaster();
                channel.getOrCreateState(this.wallet, broadcaster).close();
            }
            catch (InsufficientMoneyException e) {
                e.printStackTrace();
            }
            catch (VerificationException e) {
                e.printStackTrace();
            }
            channel.state = null;
        }
        this.updatedChannel(channel);
    }

    private TransactionBroadcaster getBroadcaster() {
        try {
            return (TransactionBroadcaster)this.broadcasterFuture.get(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            String err = "Transaction broadcaster not set";
            log.error(err);
            throw new RuntimeException(err, e);
        }
    }

    public StoredServerChannel getChannel(Sha256Hash id) {
        this.lock.lock();
        try {
            StoredServerChannel storedServerChannel = this.mapChannels.get(id);
            return storedServerChannel;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void updatedChannel(StoredServerChannel channel) {
        log.info("Stored server channel {} was updated", (Object)channel.hashCode());
        this.wallet.addOrUpdateExtension(this);
    }

    public void putChannel(final StoredServerChannel channel) {
        this.lock.lock();
        try {
            Preconditions.checkArgument((this.mapChannels.put(channel.contract.getHash(), (StoredServerChannel)Preconditions.checkNotNull((Object)channel)) == null ? 1 : 0) != 0);
            Date autocloseTime = new Date((channel.refundTransactionUnlockTimeSecs + -7200L) * 1000L + (System.currentTimeMillis() - Utils.currentTimeMillis()));
            log.info("Scheduling channel for automatic closure at {}: {}", (Object)autocloseTime, (Object)channel);
            this.channelTimeoutHandler.schedule(new TimerTask(){

                @Override
                public void run() {
                    log.info("Auto-closing channel: {}", (Object)channel);
                    StoredPaymentChannelServerStates.this.closeChannel(channel);
                }
            }, autocloseTime);
        }
        finally {
            this.lock.unlock();
        }
        this.updatedChannel(channel);
    }

    @Override
    public String getWalletExtensionID() {
        return EXTENSION_ID;
    }

    @Override
    public boolean isWalletExtensionMandatory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] serializeWalletExtension() {
        this.lock.lock();
        try {
            ServerState.StoredServerPaymentChannels.Builder builder = ServerState.StoredServerPaymentChannels.newBuilder();
            for (StoredServerChannel channel : this.mapChannels.values()) {
                Preconditions.checkState((channel.bestValueToMe.signum() >= 0 && channel.bestValueToMe.compareTo(NetworkParameters.MAX_MONEY) < 0 ? 1 : 0) != 0);
                Preconditions.checkState((channel.refundTransactionUnlockTimeSecs > 0L ? 1 : 0) != 0);
                Preconditions.checkNotNull((Object)channel.myKey.getPrivKeyBytes());
                ServerState.StoredServerPaymentChannel.Builder channelBuilder = ServerState.StoredServerPaymentChannel.newBuilder().setBestValueToMe(channel.bestValueToMe.value).setRefundTransactionUnlockTimeSecs(channel.refundTransactionUnlockTimeSecs).setContractTransaction(ByteString.copyFrom((byte[])channel.contract.bitcoinSerialize())).setClientOutput(ByteString.copyFrom((byte[])channel.clientOutput.bitcoinSerialize())).setMyKey(ByteString.copyFrom((byte[])channel.myKey.getPrivKeyBytes()));
                if (channel.bestValueSignature != null) {
                    channelBuilder.setBestValueSignature(ByteString.copyFrom((byte[])channel.bestValueSignature));
                }
                builder.addChannels(channelBuilder);
            }
            Object object = builder.build().toByteArray();
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deserializeWalletExtension(Wallet containingWallet, byte[] data) throws Exception {
        this.lock.lock();
        try {
            this.wallet = containingWallet;
            ServerState.StoredServerPaymentChannels states = ServerState.StoredServerPaymentChannels.parseFrom(data);
            NetworkParameters params = containingWallet.getParams();
            for (ServerState.StoredServerPaymentChannel storedState : states.getChannelsList()) {
                StoredServerChannel channel = new StoredServerChannel(null, new Transaction(params, storedState.getContractTransaction().toByteArray()), new TransactionOutput(params, null, storedState.getClientOutput().toByteArray(), 0), storedState.getRefundTransactionUnlockTimeSecs(), ECKey.fromPrivate(storedState.getMyKey().toByteArray()), Coin.valueOf(storedState.getBestValueToMe()), storedState.hasBestValueSignature() ? storedState.getBestValueSignature().toByteArray() : null);
                this.putChannel(channel);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.lock.lock();
        try {
            StringBuilder buf = new StringBuilder();
            for (StoredServerChannel stored : this.mapChannels.values()) {
                buf.append(stored);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

