/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.protocols.channels;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.protobuf.ByteString;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoin.paymentchannel.Protos;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.InsufficientMoneyException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.protocols.channels.IPaymentChannelClient;
import org.bitcoinj.protocols.channels.PaymentChannelClientState;
import org.bitcoinj.protocols.channels.PaymentChannelCloseException;
import org.bitcoinj.protocols.channels.PaymentIncrementAck;
import org.bitcoinj.protocols.channels.StoredClientChannel;
import org.bitcoinj.protocols.channels.StoredPaymentChannelClientStates;
import org.bitcoinj.protocols.channels.ValueOutOfRangeException;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongycastle.crypto.params.KeyParameter;

public class PaymentChannelClient
implements IPaymentChannelClient {
    private static final Logger log = LoggerFactory.getLogger(PaymentChannelClient.class);
    private static final int CLIENT_MAJOR_VERSION = 1;
    public final int CLIENT_MINOR_VERSION = 0;
    private static final int SERVER_MAJOR_VERSION = 1;
    protected final ReentrantLock lock = Threading.lock("channelclient");
    @GuardedBy(value="lock")
    private final IPaymentChannelClient.ClientConnection conn;
    @GuardedBy(value="lock")
    @VisibleForTesting
    boolean connectionOpen = false;
    @GuardedBy(value="lock")
    private PaymentChannelClientState state;
    @GuardedBy(value="lock")
    private InitStep step = InitStep.WAITING_FOR_CONNECTION_OPEN;
    private StoredClientChannel storedChannel;
    private final Sha256Hash serverId;
    private final Wallet wallet;
    private final ECKey myKey;
    private final Coin maxValue;
    private Coin missing;
    private KeyParameter userKeySetup;
    private final long timeWindow;
    @GuardedBy(value="lock")
    private long minPayment;
    @GuardedBy(value="lock")
    SettableFuture<PaymentIncrementAck> increasePaymentFuture;
    @GuardedBy(value="lock")
    Coin lastPaymentActualAmount;
    public static final long DEFAULT_TIME_WINDOW = 86340L;

    public PaymentChannelClient(Wallet wallet, ECKey myKey, Coin maxValue, Sha256Hash serverId, IPaymentChannelClient.ClientConnection conn) {
        this(wallet, myKey, maxValue, serverId, 86340L, null, conn);
    }

    public PaymentChannelClient(Wallet wallet, ECKey myKey, Coin maxValue, Sha256Hash serverId, long timeWindow, @Nullable KeyParameter userKeySetup, IPaymentChannelClient.ClientConnection conn) {
        this.wallet = (Wallet)Preconditions.checkNotNull((Object)wallet);
        this.myKey = (ECKey)Preconditions.checkNotNull((Object)myKey);
        this.maxValue = (Coin)Preconditions.checkNotNull((Object)maxValue);
        this.serverId = (Sha256Hash)Preconditions.checkNotNull((Object)serverId);
        Preconditions.checkState((timeWindow >= 0L ? 1 : 0) != 0);
        this.timeWindow = timeWindow;
        this.conn = (IPaymentChannelClient.ClientConnection)Preconditions.checkNotNull((Object)conn);
        this.userKeySetup = userKeySetup;
    }

    public Coin getMissing() {
        return this.missing;
    }

    @Nullable
    @GuardedBy(value="lock")
    private PaymentChannelCloseException.CloseReason receiveInitiate(Protos.Initiate initiate, Coin contractValue, Protos.Error.Builder errorBuilder) throws VerificationException, InsufficientMoneyException, ECKey.KeyIsEncryptedException {
        log.info("Got INITIATE message:\n{}", (Object)initiate.toString());
        if (this.wallet.isEncrypted() && this.userKeySetup == null) {
            throw new ECKey.KeyIsEncryptedException();
        }
        long expireTime = initiate.getExpireTimeSecs();
        Preconditions.checkState((expireTime >= 0L && initiate.getMinAcceptedChannelSize() >= 0L ? 1 : 0) != 0);
        if (!this.conn.acceptExpireTime(expireTime)) {
            log.error("Server suggested expire time was out of our allowed bounds: {} ({} s)", (Object)Utils.dateTimeFormat(expireTime * 1000L), (Object)expireTime);
            errorBuilder.setCode(Protos.Error.ErrorCode.TIME_WINDOW_UNACCEPTABLE);
            return PaymentChannelCloseException.CloseReason.TIME_WINDOW_UNACCEPTABLE;
        }
        Coin minChannelSize = Coin.valueOf(initiate.getMinAcceptedChannelSize());
        if (contractValue.compareTo(minChannelSize) < 0) {
            log.error("Server requested too much value");
            errorBuilder.setCode(Protos.Error.ErrorCode.CHANNEL_VALUE_TOO_LARGE);
            this.missing = minChannelSize.subtract(contractValue);
            return PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_TOO_MUCH_VALUE;
        }
        long MIN_PAYMENT = Transaction.REFERENCE_DEFAULT_MIN_TX_FEE.value;
        if (initiate.getMinPayment() != MIN_PAYMENT) {
            log.error("Server requested a min payment of {} but we expected {}", (Object)initiate.getMinPayment(), (Object)MIN_PAYMENT);
            errorBuilder.setCode(Protos.Error.ErrorCode.MIN_PAYMENT_TOO_LARGE);
            errorBuilder.setExpectedValue(MIN_PAYMENT);
            this.missing = Coin.valueOf(initiate.getMinPayment() - MIN_PAYMENT);
            return PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_TOO_MUCH_VALUE;
        }
        byte[] pubKeyBytes = initiate.getMultisigKey().toByteArray();
        if (!ECKey.isPubKeyCanonical(pubKeyBytes)) {
            throw new VerificationException("Server gave us a non-canonical public key, protocol error.");
        }
        this.state = new PaymentChannelClientState(this.wallet, this.myKey, ECKey.fromPublicOnly(pubKeyBytes), contractValue, expireTime);
        try {
            this.state.initiate(this.userKeySetup);
        }
        catch (ValueOutOfRangeException e) {
            log.error("Value out of range when trying to initiate", (Throwable)e);
            errorBuilder.setCode(Protos.Error.ErrorCode.CHANNEL_VALUE_TOO_LARGE);
            return PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_TOO_MUCH_VALUE;
        }
        this.minPayment = initiate.getMinPayment();
        this.step = InitStep.WAITING_FOR_REFUND_RETURN;
        Protos.ProvideRefund.Builder provideRefundBuilder = Protos.ProvideRefund.newBuilder().setMultisigKey(ByteString.copyFrom((byte[])this.myKey.getPubKey())).setTx(ByteString.copyFrom((byte[])this.state.getIncompleteRefundTransaction().bitcoinSerialize()));
        this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setProvideRefund(provideRefundBuilder).setType(Protos.TwoWayChannelMessage.MessageType.PROVIDE_REFUND).build());
        return null;
    }

    @GuardedBy(value="lock")
    private void receiveRefund(Protos.TwoWayChannelMessage refundMsg, @Nullable KeyParameter userKey) throws VerificationException {
        Preconditions.checkState((this.step == InitStep.WAITING_FOR_REFUND_RETURN && refundMsg.hasReturnRefund() ? 1 : 0) != 0);
        log.info("Got RETURN_REFUND message, providing signed contract");
        Protos.ReturnRefund returnedRefund = refundMsg.getReturnRefund();
        this.state.provideRefundSignature(returnedRefund.getSignature().toByteArray(), userKey);
        this.step = InitStep.WAITING_FOR_CHANNEL_OPEN;
        this.state.storeChannelInWallet(this.serverId);
        Protos.ProvideContract.Builder contractMsg = Protos.ProvideContract.newBuilder().setTx(ByteString.copyFrom((byte[])this.state.getMultisigContract().bitcoinSerialize()));
        try {
            PaymentChannelClientState.IncrementedPayment payment = this.state().incrementPaymentBy(Coin.valueOf(this.minPayment), userKey);
            Protos.UpdatePayment.Builder initialMsg = contractMsg.getInitialPaymentBuilder();
            initialMsg.setSignature(ByteString.copyFrom((byte[])payment.signature.encodeToBitcoin()));
            initialMsg.setClientChangeValue(this.state.getValueRefunded().value);
        }
        catch (ValueOutOfRangeException e) {
            throw new IllegalStateException(e);
        }
        Protos.TwoWayChannelMessage.Builder msg = Protos.TwoWayChannelMessage.newBuilder();
        msg.setProvideContract(contractMsg);
        msg.setType(Protos.TwoWayChannelMessage.MessageType.PROVIDE_CONTRACT);
        this.conn.sendToServer(msg.build());
    }

    @GuardedBy(value="lock")
    private void receiveChannelOpen() throws VerificationException {
        Preconditions.checkState((this.step == InitStep.WAITING_FOR_CHANNEL_OPEN || this.step == InitStep.WAITING_FOR_INITIATE && this.storedChannel != null ? 1 : 0) != 0, (Object)((Object)this.step));
        log.info("Got CHANNEL_OPEN message, ready to pay");
        boolean wasInitiated = true;
        if (this.step == InitStep.WAITING_FOR_INITIATE) {
            wasInitiated = false;
            this.state = new PaymentChannelClientState(this.storedChannel, this.wallet);
        }
        this.step = InitStep.CHANNEL_OPEN;
        this.conn.channelOpen(wasInitiated);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void receiveMessage(Protos.TwoWayChannelMessage msg) throws InsufficientMoneyException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @GuardedBy(value="lock")
    private void receiveClose(Protos.TwoWayChannelMessage msg) throws VerificationException {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (msg.hasSettlement()) {
            Transaction settleTx = new Transaction(this.wallet.getParams(), msg.getSettlement().getTx().toByteArray());
            log.info("CLOSE message received with settlement tx {}", (Object)settleTx.getHash());
            if (this.state != null && this.state().isSettlementTransaction(settleTx)) {
                this.wallet.receivePending(settleTx, null);
            }
        } else {
            log.info("CLOSE message received without settlement tx");
        }
        if (this.step == InitStep.WAITING_FOR_CHANNEL_CLOSE) {
            this.conn.destroyConnection(PaymentChannelCloseException.CloseReason.CLIENT_REQUESTED_CLOSE);
        } else {
            this.conn.destroyConnection(PaymentChannelCloseException.CloseReason.SERVER_REQUESTED_CLOSE);
        }
        this.step = InitStep.CHANNEL_CLOSED;
    }

    @Override
    public void connectionClosed() {
        this.lock.lock();
        try {
            this.connectionOpen = false;
            if (this.state != null) {
                this.state.disconnectFromChannel();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void settle() throws IllegalStateException {
        this.lock.lock();
        try {
            Preconditions.checkState((boolean)this.connectionOpen);
            this.step = InitStep.WAITING_FOR_CHANNEL_CLOSE;
            log.info("Sending a CLOSE message to the server and waiting for response indicating successful settlement.");
            this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setType(Protos.TwoWayChannelMessage.MessageType.CLOSE).build());
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void connectionOpen() {
        this.lock.lock();
        try {
            this.connectionOpen = true;
            StoredPaymentChannelClientStates channels = (StoredPaymentChannelClientStates)this.wallet.getExtensions().get(StoredPaymentChannelClientStates.EXTENSION_ID);
            if (channels != null) {
                this.storedChannel = channels.getUsableChannelForServerID(this.serverId);
            }
            this.step = InitStep.WAITING_FOR_VERSION_NEGOTIATION;
            Protos.ClientVersion.Builder versionNegotiationBuilder = Protos.ClientVersion.newBuilder().setMajor(1).setMinor(0).setTimeWindowSecs(this.timeWindow);
            if (this.storedChannel != null) {
                versionNegotiationBuilder.setPreviousChannelContractHash(ByteString.copyFrom((byte[])this.storedChannel.contract.getHash().getBytes()));
                log.info("Begun version handshake, attempting to reopen channel with contract hash {}", (Object)this.storedChannel.contract.getHash());
            } else {
                log.info("Begun version handshake creating new channel");
            }
            this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setType(Protos.TwoWayChannelMessage.MessageType.CLIENT_VERSION).setClientVersion(versionNegotiationBuilder).build());
        }
        finally {
            this.lock.unlock();
        }
    }

    public PaymentChannelClientState state() {
        this.lock.lock();
        try {
            PaymentChannelClientState paymentChannelClientState = this.state;
            return paymentChannelClientState;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ListenableFuture<PaymentIncrementAck> incrementPayment(Coin size) throws ValueOutOfRangeException, IllegalStateException {
        return this.incrementPayment(size, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<PaymentIncrementAck> incrementPayment(Coin size, @Nullable ByteString info, @Nullable KeyParameter userKey) throws ValueOutOfRangeException, IllegalStateException, ECKey.KeyIsEncryptedException {
        this.lock.lock();
        try {
            if (this.state() == null || !this.connectionOpen || this.step != InitStep.CHANNEL_OPEN) {
                throw new IllegalStateException("Channel is not fully initialized/has already been closed");
            }
            if (this.increasePaymentFuture != null) {
                throw new IllegalStateException("Already incrementing paying, wait for previous payment to complete.");
            }
            if (this.wallet.isEncrypted() && userKey == null) {
                throw new ECKey.KeyIsEncryptedException();
            }
            PaymentChannelClientState.IncrementedPayment payment = this.state().incrementPaymentBy(size, userKey);
            Protos.UpdatePayment.Builder updatePaymentBuilder = Protos.UpdatePayment.newBuilder().setSignature(ByteString.copyFrom((byte[])payment.signature.encodeToBitcoin())).setClientChangeValue(this.state.getValueRefunded().value);
            if (info != null) {
                updatePaymentBuilder.setInfo(info);
            }
            this.increasePaymentFuture = SettableFuture.create();
            this.increasePaymentFuture.addListener(new Runnable(){

                @Override
                public void run() {
                    PaymentChannelClient.this.lock.lock();
                    PaymentChannelClient.this.increasePaymentFuture = null;
                    PaymentChannelClient.this.lock.unlock();
                }
            }, (Executor)MoreExecutors.sameThreadExecutor());
            this.conn.sendToServer(Protos.TwoWayChannelMessage.newBuilder().setUpdatePayment(updatePaymentBuilder).setType(Protos.TwoWayChannelMessage.MessageType.UPDATE_PAYMENT).build());
            this.lastPaymentActualAmount = payment.amount;
            SettableFuture<PaymentIncrementAck> settableFuture = this.increasePaymentFuture;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivePaymentAck(Protos.PaymentAck paymentAck) {
        Coin value;
        SettableFuture<PaymentIncrementAck> future;
        this.lock.lock();
        try {
            if (this.increasePaymentFuture == null) {
                return;
            }
            Preconditions.checkNotNull(this.increasePaymentFuture, (Object)"Server sent a PAYMENT_ACK with no outstanding payment");
            log.info("Received a PAYMENT_ACK from the server");
            future = this.increasePaymentFuture;
            value = this.lastPaymentActualAmount;
        }
        finally {
            this.lock.unlock();
        }
        future.set((Object)new PaymentIncrementAck(value, paymentAck.getInfo()));
    }

    private static enum InitStep {
        WAITING_FOR_CONNECTION_OPEN,
        WAITING_FOR_VERSION_NEGOTIATION,
        WAITING_FOR_INITIATE,
        WAITING_FOR_REFUND_RETURN,
        WAITING_FOR_CHANNEL_OPEN,
        CHANNEL_OPEN,
        WAITING_FOR_CHANNEL_CLOSE,
        CHANNEL_CLOSED;

    }
}

