/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.ChildMessage;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.ScriptException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.TransactionBag;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionInput;
import org.bitcoinj.core.TransactionOutPoint;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TxConfidenceTable;
import org.bitcoinj.core.UnsafeByteArrayOutputStream;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VarInt;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.crypto.TransactionSignature;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptBuilder;
import org.bitcoinj.utils.ExchangeRate;
import org.bitcoinj.wallet.WalletTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transaction
extends ChildMessage
implements Serializable {
    public static final Comparator<Transaction> SORT_TX_BY_UPDATE_TIME = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction tx1, Transaction tx2) {
            long time2;
            long time1 = tx1.getUpdateTime().getTime();
            int updateTimeComparison = -Longs.compare((long)time1, (long)(time2 = tx2.getUpdateTime().getTime()));
            return updateTimeComparison != 0 ? updateTimeComparison : tx1.getHash().compareTo(tx2.getHash());
        }
    };
    public static final Comparator<Transaction> SORT_TX_BY_HEIGHT = new Comparator<Transaction>(){

        @Override
        public int compare(Transaction tx1, Transaction tx2) {
            int height2;
            int height1 = tx1.getConfidence().getAppearedAtChainHeight();
            int heightComparison = -Ints.compare((int)height1, (int)(height2 = tx2.getConfidence().getAppearedAtChainHeight()));
            return heightComparison != 0 ? heightComparison : tx1.getHash().compareTo(tx2.getHash());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(Transaction.class);
    private static final long serialVersionUID = -8567546957352643140L;
    public static final int LOCKTIME_THRESHOLD = 500000000;
    public static final int MAX_STANDARD_TX_SIZE = 100000;
    public static final Coin REFERENCE_DEFAULT_MIN_TX_FEE = Coin.valueOf(1000L);
    public static final Coin MIN_NONDUST_OUTPUT = Coin.valueOf(546L);
    private long version;
    private ArrayList<TransactionInput> inputs;
    private ArrayList<TransactionOutput> outputs;
    private long lockTime;
    private Date updatedAt;
    private transient Sha256Hash hash;
    @Nullable
    private TransactionConfidence confidence;
    private Map<Sha256Hash, Integer> appearsInHashes;
    private transient int optimalEncodingMessageSize;
    private Purpose purpose = Purpose.UNKNOWN;
    @Nullable
    private ExchangeRate exchangeRate;
    @Nullable
    private String memo;
    @Nullable
    private Coin cachedValue;
    @Nullable
    private TransactionBag cachedForBag;
    public static final byte SIGHASH_ANYONECANPAY_VALUE = -128;

    public Transaction(NetworkParameters params) {
        super(params);
        this.version = 1L;
        this.inputs = new ArrayList();
        this.outputs = new ArrayList();
        this.length = 8;
    }

    public Transaction(NetworkParameters params, byte[] payloadBytes) throws ProtocolException {
        super(params, payloadBytes, 0);
    }

    public Transaction(NetworkParameters params, byte[] payload, int offset) throws ProtocolException {
        super(params, payload, offset);
    }

    public Transaction(NetworkParameters params, byte[] payload, int offset, @Nullable Message parent, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, payload, offset, parent, parseLazy, parseRetain, length);
    }

    public Transaction(NetworkParameters params, byte[] payload, @Nullable Message parent, boolean parseLazy, boolean parseRetain, int length) throws ProtocolException {
        super(params, payload, 0, parent, parseLazy, parseRetain, length);
    }

    @Override
    public Sha256Hash getHash() {
        if (this.hash == null) {
            byte[] bits = this.bitcoinSerialize();
            this.hash = Sha256Hash.wrapReversed(Sha256Hash.hashTwice(bits));
        }
        return this.hash;
    }

    void setHash(Sha256Hash hash) {
        this.hash = hash;
    }

    public String getHashAsString() {
        return this.getHash().toString();
    }

    Coin getValueSentToMe(TransactionBag transactionBag, boolean includeSpent) {
        this.maybeParse();
        Coin v = Coin.ZERO;
        for (TransactionOutput o : this.outputs) {
            if (!o.isMineOrWatched(transactionBag) || !includeSpent && !o.isAvailableForSpending()) continue;
            v = v.add(o.getValue());
        }
        return v;
    }

    boolean isConsistent(TransactionBag transactionBag, boolean isSpent) {
        boolean isActuallySpent = true;
        for (TransactionOutput o : this.outputs) {
            if (o.isAvailableForSpending()) {
                if (o.isMineOrWatched(transactionBag)) {
                    isActuallySpent = false;
                }
                if (o.getSpentBy() == null) continue;
                log.error("isAvailableForSpending != spentBy");
                return false;
            }
            if (o.getSpentBy() != null) continue;
            log.error("isAvailableForSpending != spentBy");
            return false;
        }
        return isActuallySpent == isSpent;
    }

    public Coin getValueSentToMe(TransactionBag transactionBag) {
        return this.getValueSentToMe(transactionBag, true);
    }

    @Nullable
    public Map<Sha256Hash, Integer> getAppearsInHashes() {
        return this.appearsInHashes != null ? ImmutableMap.copyOf(this.appearsInHashes) : null;
    }

    public boolean isPending() {
        return this.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.PENDING;
    }

    public void setBlockAppearance(StoredBlock block, boolean bestChain, int relativityOffset) {
        long blockTime = block.getHeader().getTimeSeconds() * 1000L;
        if (bestChain && (this.updatedAt == null || this.updatedAt.getTime() == 0L || this.updatedAt.getTime() > blockTime)) {
            this.updatedAt = new Date(blockTime);
        }
        this.addBlockAppearance(block.getHeader().getHash(), relativityOffset);
        if (bestChain) {
            TransactionConfidence transactionConfidence = this.getConfidence();
            transactionConfidence.setAppearedAtChainHeight(block.getHeight());
        }
    }

    public void addBlockAppearance(Sha256Hash blockHash, int relativityOffset) {
        if (this.appearsInHashes == null) {
            this.appearsInHashes = new TreeMap<Sha256Hash, Integer>();
        }
        this.appearsInHashes.put(blockHash, relativityOffset);
    }

    public Coin getValueSentFromMe(TransactionBag wallet) throws ScriptException {
        this.maybeParse();
        Coin v = Coin.ZERO;
        for (TransactionInput input : this.inputs) {
            TransactionOutput connected = input.getConnectedOutput(wallet.getTransactionPool(WalletTransaction.Pool.UNSPENT));
            if (connected == null) {
                connected = input.getConnectedOutput(wallet.getTransactionPool(WalletTransaction.Pool.SPENT));
            }
            if (connected == null) {
                connected = input.getConnectedOutput(wallet.getTransactionPool(WalletTransaction.Pool.PENDING));
            }
            if (connected == null || !connected.isMineOrWatched(wallet)) continue;
            v = v.add(connected.getValue());
        }
        return v;
    }

    public Coin getValue(TransactionBag wallet) throws ScriptException {
        boolean isAndroid = Utils.isAndroidRuntime();
        if (isAndroid && this.cachedValue != null && this.cachedForBag == wallet) {
            return this.cachedValue;
        }
        Coin result = this.getValueSentToMe(wallet).subtract(this.getValueSentFromMe(wallet));
        if (isAndroid) {
            this.cachedValue = result;
            this.cachedForBag = wallet;
        }
        return result;
    }

    public Coin getFee() {
        Coin fee = Coin.ZERO;
        for (TransactionInput input : this.inputs) {
            if (input.getValue() == null) {
                return null;
            }
            fee = fee.add(input.getValue());
        }
        for (TransactionOutput output : this.outputs) {
            fee = fee.subtract(output.getValue());
        }
        return fee;
    }

    public boolean isAnyOutputSpent() {
        this.maybeParse();
        for (TransactionOutput output : this.outputs) {
            if (output.isAvailableForSpending()) continue;
            return true;
        }
        return false;
    }

    public boolean isEveryOwnedOutputSpent(TransactionBag transactionBag) {
        this.maybeParse();
        for (TransactionOutput output : this.outputs) {
            if (!output.isAvailableForSpending() || !output.isMineOrWatched(transactionBag)) continue;
            return false;
        }
        return true;
    }

    public Date getUpdateTime() {
        if (this.updatedAt == null) {
            this.updatedAt = new Date(0L);
        }
        return this.updatedAt;
    }

    public void setUpdateTime(Date updatedAt) {
        this.updatedAt = updatedAt;
    }

    @Override
    protected void unCache() {
        super.unCache();
        this.hash = null;
    }

    @Override
    protected void parseLite() throws ProtocolException {
        if (this.parseLazy && this.length == Integer.MIN_VALUE) {
            this.length = Transaction.calcLength(this.payload, this.offset);
            this.cursor = this.offset + this.length;
        }
    }

    protected static int calcLength(byte[] buf, int offset) {
        long scriptLen;
        int cursor = offset + 4;
        VarInt varint = new VarInt(buf, cursor);
        long txInCount = varint.value;
        cursor += varint.getOriginalSizeInBytes();
        int i = 0;
        while ((long)i < txInCount) {
            varint = new VarInt(buf, cursor += 36);
            scriptLen = varint.value;
            cursor = (int)((long)cursor + (scriptLen + 4L + (long)varint.getOriginalSizeInBytes()));
            ++i;
        }
        varint = new VarInt(buf, cursor);
        long txOutCount = varint.value;
        cursor += varint.getOriginalSizeInBytes();
        i = 0;
        while ((long)i < txOutCount) {
            varint = new VarInt(buf, cursor += 8);
            scriptLen = varint.value;
            cursor = (int)((long)cursor + (scriptLen + (long)varint.getOriginalSizeInBytes()));
            ++i;
        }
        return cursor - offset + 4;
    }

    @Override
    void parse() throws ProtocolException {
        if (this.parsed) {
            return;
        }
        this.cursor = this.offset;
        this.version = this.readUint32();
        this.optimalEncodingMessageSize = 4;
        long numInputs = this.readVarInt();
        this.optimalEncodingMessageSize += VarInt.sizeOf(numInputs);
        this.inputs = new ArrayList((int)numInputs);
        for (long i = 0L; i < numInputs; ++i) {
            TransactionInput input = new TransactionInput(this.params, this, this.payload, this.cursor, this.parseLazy, this.parseRetain);
            this.inputs.add(input);
            long scriptLen = this.readVarInt(36);
            this.optimalEncodingMessageSize = (int)((long)this.optimalEncodingMessageSize + ((long)(36 + VarInt.sizeOf(scriptLen)) + scriptLen + 4L));
            this.cursor = (int)((long)this.cursor + (scriptLen + 4L));
        }
        long numOutputs = this.readVarInt();
        this.optimalEncodingMessageSize += VarInt.sizeOf(numOutputs);
        this.outputs = new ArrayList((int)numOutputs);
        for (long i = 0L; i < numOutputs; ++i) {
            TransactionOutput output = new TransactionOutput(this.params, this, this.payload, this.cursor, this.parseLazy, this.parseRetain);
            this.outputs.add(output);
            long scriptLen = this.readVarInt(8);
            this.optimalEncodingMessageSize = (int)((long)this.optimalEncodingMessageSize + ((long)(8 + VarInt.sizeOf(scriptLen)) + scriptLen));
            this.cursor = (int)((long)this.cursor + scriptLen);
        }
        this.lockTime = this.readUint32();
        this.optimalEncodingMessageSize += 4;
        this.length = this.cursor - this.offset;
    }

    public int getOptimalEncodingMessageSize() {
        if (this.optimalEncodingMessageSize != 0) {
            return this.optimalEncodingMessageSize;
        }
        this.maybeParse();
        if (this.optimalEncodingMessageSize != 0) {
            return this.optimalEncodingMessageSize;
        }
        this.optimalEncodingMessageSize = this.getMessageSize();
        return this.optimalEncodingMessageSize;
    }

    public boolean isCoinBase() {
        this.maybeParse();
        return this.inputs.size() == 1 && this.inputs.get(0).isCoinBase();
    }

    public boolean isMature() {
        if (!this.isCoinBase()) {
            return true;
        }
        if (this.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.BUILDING) {
            return false;
        }
        return this.getConfidence().getDepthInBlocks() >= this.params.getSpendableCoinbaseDepth();
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(@Nullable AbstractBlockChain chain) {
        StringBuilder s = new StringBuilder();
        s.append(String.format("  %s: %s%n", this.getHashAsString(), this.getConfidence()));
        if (this.isTimeLocked()) {
            String time;
            if (this.lockTime < 500000000L) {
                time = "block " + this.lockTime;
                if (chain != null) {
                    time = time + " (estimated to be reached at " + chain.estimateBlockTime((int)this.lockTime).toString() + ")";
                }
            } else {
                time = new Date(this.lockTime * 1000L).toString();
            }
            s.append(String.format("  time locked until %s%n", time));
        }
        if (this.inputs.size() == 0) {
            s.append(String.format("  INCOMPLETE: No inputs!%n", new Object[0]));
            return s.toString();
        }
        if (this.isCoinBase()) {
            String script2;
            Iterator<TransactionOutput> script;
            try {
                script = this.inputs.get(0).getScriptSig().toString();
                script2 = this.outputs.get(0).getScriptPubKey().toString();
            }
            catch (ScriptException e) {
                script = "???";
                script2 = "???";
            }
            s.append("     == COINBASE TXN (scriptSig ").append((String)((Object)script)).append(")  (scriptPubKey ").append(script2).append(")\n");
            return s.toString();
        }
        for (TransactionInput in : this.inputs) {
            s.append("     ");
            s.append("in   ");
            try {
                Script scriptPubKey;
                Script scriptSig = in.getScriptSig();
                s.append(scriptSig);
                if (in.getValue() != null) {
                    s.append(" ").append(in.getValue().toFriendlyString());
                }
                s.append("\n          ");
                s.append("outpoint:");
                TransactionOutPoint outpoint = in.getOutpoint();
                s.append(outpoint.toString());
                TransactionOutput connectedOutput = outpoint.getConnectedOutput();
                if (connectedOutput != null && ((scriptPubKey = connectedOutput.getScriptPubKey()).isSentToAddress() || scriptPubKey.isPayToScriptHash())) {
                    s.append(" hash160:");
                    s.append(Utils.HEX.encode(scriptPubKey.getPubKeyHash()));
                }
            }
            catch (Exception e) {
                s.append("[exception: ").append(e.getMessage()).append("]");
            }
            s.append(String.format("%n", new Object[0]));
        }
        for (TransactionOutput out : this.outputs) {
            s.append("     ");
            s.append("out  ");
            try {
                Script scriptPubKey = out.getScriptPubKey();
                s.append(scriptPubKey);
                s.append(" ");
                s.append(out.getValue().toFriendlyString());
                if (!out.isAvailableForSpending()) {
                    s.append(" Spent");
                }
                if (out.getSpentBy() != null) {
                    s.append(" by ");
                    s.append(out.getSpentBy().getParentTransaction().getHashAsString());
                }
            }
            catch (Exception e) {
                s.append("[exception: ").append(e.getMessage()).append("]");
            }
            s.append(String.format("%n", new Object[0]));
        }
        Coin fee = this.getFee();
        if (fee != null) {
            s.append("     fee  ").append(fee.toFriendlyString()).append(String.format("%n", new Object[0]));
        }
        return s.toString();
    }

    public void clearInputs() {
        this.unCache();
        for (TransactionInput input : this.inputs) {
            input.setParent(null);
        }
        this.inputs.clear();
        this.length = this.bitcoinSerialize().length;
    }

    public TransactionInput addInput(TransactionOutput from) {
        return this.addInput(new TransactionInput(this.params, this, from));
    }

    public TransactionInput addInput(TransactionInput input) {
        this.unCache();
        input.setParent(this);
        this.inputs.add(input);
        this.adjustLength(this.inputs.size(), input.length);
        return input;
    }

    public TransactionInput addInput(Sha256Hash spendTxHash, long outputIndex, Script script) {
        return this.addInput(new TransactionInput(this.params, this, script.getProgram(), new TransactionOutPoint(this.params, outputIndex, spendTxHash)));
    }

    public TransactionInput addSignedInput(TransactionOutPoint prevOut, Script scriptPubKey, ECKey sigKey, SigHash sigHash, boolean anyoneCanPay) throws ScriptException {
        Preconditions.checkState((!this.outputs.isEmpty() ? 1 : 0) != 0, (Object)"Attempting to sign tx without outputs.");
        TransactionInput input = new TransactionInput(this.params, this, new byte[0], prevOut);
        this.addInput(input);
        Sha256Hash hash = this.hashForSignature(this.inputs.size() - 1, scriptPubKey, sigHash, anyoneCanPay);
        ECKey.ECDSASignature ecSig = sigKey.sign(hash);
        TransactionSignature txSig = new TransactionSignature(ecSig, sigHash, anyoneCanPay);
        if (scriptPubKey.isSentToRawPubKey()) {
            input.setScriptSig(ScriptBuilder.createInputScript(txSig));
        } else if (scriptPubKey.isSentToAddress()) {
            input.setScriptSig(ScriptBuilder.createInputScript(txSig, sigKey));
        } else {
            throw new ScriptException("Don't know how to sign for this kind of scriptPubKey: " + scriptPubKey);
        }
        return input;
    }

    public TransactionInput addSignedInput(TransactionOutPoint prevOut, Script scriptPubKey, ECKey sigKey) throws ScriptException {
        return this.addSignedInput(prevOut, scriptPubKey, sigKey, SigHash.ALL, false);
    }

    public TransactionInput addSignedInput(TransactionOutput output, ECKey signingKey) {
        return this.addSignedInput(output.getOutPointFor(), output.getScriptPubKey(), signingKey);
    }

    public TransactionInput addSignedInput(TransactionOutput output, ECKey signingKey, SigHash sigHash, boolean anyoneCanPay) {
        return this.addSignedInput(output.getOutPointFor(), output.getScriptPubKey(), signingKey, sigHash, anyoneCanPay);
    }

    public void clearOutputs() {
        this.unCache();
        for (TransactionOutput output : this.outputs) {
            output.setParent(null);
        }
        this.outputs.clear();
        this.length = this.bitcoinSerialize().length;
    }

    public TransactionOutput addOutput(TransactionOutput to) {
        this.unCache();
        to.setParent(this);
        this.outputs.add(to);
        this.adjustLength(this.outputs.size(), to.length);
        return to;
    }

    public TransactionOutput addOutput(Coin value, Address address) {
        return this.addOutput(new TransactionOutput(this.params, this, value, address));
    }

    public TransactionOutput addOutput(Coin value, ECKey pubkey) {
        return this.addOutput(new TransactionOutput(this.params, this, value, pubkey));
    }

    public TransactionOutput addOutput(Coin value, Script script) {
        return this.addOutput(new TransactionOutput(this.params, this, value, script.getProgram()));
    }

    public synchronized TransactionSignature calculateSignature(int inputIndex, ECKey key, byte[] redeemScript, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForSignature(inputIndex, redeemScript, hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash), hashType, anyoneCanPay);
    }

    public synchronized TransactionSignature calculateSignature(int inputIndex, ECKey key, Script redeemScript, SigHash hashType, boolean anyoneCanPay) {
        Sha256Hash hash = this.hashForSignature(inputIndex, redeemScript.getProgram(), hashType, anyoneCanPay);
        return new TransactionSignature(key.sign(hash), hashType, anyoneCanPay);
    }

    public synchronized Sha256Hash hashForSignature(int inputIndex, byte[] redeemScript, SigHash type, boolean anyoneCanPay) {
        byte sigHashType = (byte)TransactionSignature.calcSigHashValue(type, anyoneCanPay);
        return this.hashForSignature(inputIndex, redeemScript, sigHashType);
    }

    public synchronized Sha256Hash hashForSignature(int inputIndex, Script redeemScript, SigHash type, boolean anyoneCanPay) {
        int sigHash = TransactionSignature.calcSigHashValue(type, anyoneCanPay);
        return this.hashForSignature(inputIndex, redeemScript.getProgram(), (byte)sigHash);
    }

    public synchronized Sha256Hash hashForSignature(int inputIndex, byte[] connectedScript, byte sigHashType) {
        try {
            int i;
            byte[][] inputScripts = new byte[this.inputs.size()][];
            long[] inputSequenceNumbers = new long[this.inputs.size()];
            for (int i2 = 0; i2 < this.inputs.size(); ++i2) {
                inputScripts[i2] = this.inputs.get(i2).getScriptBytes();
                inputSequenceNumbers[i2] = this.inputs.get(i2).getSequenceNumber();
                this.inputs.get(i2).setScriptBytes(TransactionInput.EMPTY_ARRAY);
            }
            connectedScript = Script.removeAllInstancesOfOp(connectedScript, 171);
            TransactionInput input = this.inputs.get(inputIndex);
            input.setScriptBytes(connectedScript);
            ArrayList<TransactionOutput> outputs = this.outputs;
            if ((sigHashType & 0x1F) == SigHash.NONE.ordinal() + 1) {
                this.outputs = new ArrayList(0);
                for (i = 0; i < this.inputs.size(); ++i) {
                    if (i == inputIndex) continue;
                    this.inputs.get(i).setSequenceNumber(0L);
                }
            } else if ((sigHashType & 0x1F) == SigHash.SINGLE.ordinal() + 1) {
                if (inputIndex >= this.outputs.size()) {
                    for (int i3 = 0; i3 < this.inputs.size(); ++i3) {
                        this.inputs.get(i3).setScriptBytes(inputScripts[i3]);
                        this.inputs.get(i3).setSequenceNumber(inputSequenceNumbers[i3]);
                    }
                    this.outputs = outputs;
                    return Sha256Hash.wrap("0100000000000000000000000000000000000000000000000000000000000000");
                }
                this.outputs = new ArrayList<TransactionOutput>(this.outputs.subList(0, inputIndex + 1));
                for (i = 0; i < inputIndex; ++i) {
                    this.outputs.set(i, new TransactionOutput(this.params, this, Coin.NEGATIVE_SATOSHI, new byte[0]));
                }
                for (i = 0; i < this.inputs.size(); ++i) {
                    if (i == inputIndex) continue;
                    this.inputs.get(i).setSequenceNumber(0L);
                }
            }
            ArrayList<TransactionInput> inputs = this.inputs;
            if ((sigHashType & 0xFFFFFF80) == -128) {
                this.inputs = new ArrayList();
                this.inputs.add(input);
            }
            UnsafeByteArrayOutputStream bos = new UnsafeByteArrayOutputStream(this.length == Integer.MIN_VALUE ? 256 : this.length + 4);
            this.bitcoinSerialize(bos);
            Utils.uint32ToByteStreamLE(0xFF & sigHashType, bos);
            Sha256Hash hash = Sha256Hash.twiceOf(((ByteArrayOutputStream)bos).toByteArray());
            bos.close();
            this.inputs = inputs;
            for (int i4 = 0; i4 < inputs.size(); ++i4) {
                inputs.get(i4).setScriptBytes(inputScripts[i4]);
                inputs.get(i4).setSequenceNumber(inputSequenceNumbers[i4]);
            }
            this.outputs = outputs;
            return hash;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        Utils.uint32ToByteStreamLE(this.version, stream);
        stream.write(new VarInt(this.inputs.size()).encode());
        for (TransactionInput in : this.inputs) {
            in.bitcoinSerialize(stream);
        }
        stream.write(new VarInt(this.outputs.size()).encode());
        for (TransactionOutput out : this.outputs) {
            out.bitcoinSerialize(stream);
        }
        Utils.uint32ToByteStreamLE(this.lockTime, stream);
    }

    public long getLockTime() {
        this.maybeParse();
        return this.lockTime;
    }

    public void setLockTime(long lockTime) {
        this.unCache();
        boolean seqNumSet = false;
        for (TransactionInput input : this.inputs) {
            if (input.getSequenceNumber() == 0xFFFFFFFFL) continue;
            seqNumSet = true;
            break;
        }
        if (!seqNumSet || this.inputs.isEmpty()) {
            log.warn("You are setting the lock time on a transaction but none of the inputs have non-default sequence numbers. This will not do what you expect!");
        }
        this.lockTime = lockTime;
    }

    public long getVersion() {
        this.maybeParse();
        return this.version;
    }

    public List<TransactionInput> getInputs() {
        this.maybeParse();
        return Collections.unmodifiableList(this.inputs);
    }

    public List<TransactionOutput> getOutputs() {
        this.maybeParse();
        return Collections.unmodifiableList(this.outputs);
    }

    public List<TransactionOutput> getWalletOutputs(TransactionBag transactionBag) {
        this.maybeParse();
        LinkedList<TransactionOutput> walletOutputs = new LinkedList<TransactionOutput>();
        for (TransactionOutput o : this.outputs) {
            if (!o.isMineOrWatched(transactionBag)) continue;
            walletOutputs.add(o);
        }
        return walletOutputs;
    }

    public void shuffleOutputs() {
        this.maybeParse();
        Collections.shuffle(this.outputs);
    }

    public TransactionInput getInput(long index) {
        this.maybeParse();
        return this.inputs.get((int)index);
    }

    public TransactionOutput getOutput(long index) {
        this.maybeParse();
        return this.outputs.get((int)index);
    }

    public TransactionConfidence getConfidence() {
        return this.getConfidence(Context.get());
    }

    public TransactionConfidence getConfidence(Context context) {
        return this.getConfidence(context.getConfidenceTable());
    }

    public TransactionConfidence getConfidence(TxConfidenceTable table) {
        if (this.confidence == null) {
            this.confidence = table.getOrCreate(this.getHash());
        }
        return this.confidence;
    }

    public boolean hasConfidence() {
        return this.getConfidence().getConfidenceType() != TransactionConfidence.ConfidenceType.UNKNOWN;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction other = (Transaction)o;
        return this.getHash().equals(other.getHash());
    }

    public int hashCode() {
        return this.getHash().hashCode();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.maybeParse();
        out.defaultWriteObject();
    }

    public int getSigOpCount() throws ScriptException {
        this.maybeParse();
        int sigOps = 0;
        for (TransactionInput input : this.inputs) {
            sigOps += Script.getSigOpCount(input.getScriptBytes());
        }
        for (TransactionOutput output : this.outputs) {
            sigOps += Script.getSigOpCount(output.getScriptBytes());
        }
        return sigOps;
    }

    public void verify() throws VerificationException {
        this.maybeParse();
        if (this.inputs.size() == 0 || this.outputs.size() == 0) {
            throw new VerificationException.EmptyInputsOrOutputs();
        }
        if (this.getMessageSize() > 1000000) {
            throw new VerificationException.LargerThanMaxBlockSize();
        }
        Coin valueOut = Coin.ZERO;
        HashSet<TransactionOutPoint> outpoints = new HashSet<TransactionOutPoint>();
        for (TransactionInput input : this.inputs) {
            if (outpoints.contains(input.getOutpoint())) {
                throw new VerificationException.DuplicatedOutPoint();
            }
            outpoints.add(input.getOutpoint());
        }
        try {
            for (TransactionOutput output : this.outputs) {
                if (output.getValue().signum() < 0) {
                    throw new VerificationException.NegativeValueOutput();
                }
                if ((valueOut = valueOut.add(output.getValue())).compareTo(NetworkParameters.MAX_MONEY) <= 0) continue;
                throw new IllegalArgumentException();
            }
        }
        catch (IllegalStateException e) {
            throw new VerificationException.ExcessiveValue();
        }
        catch (IllegalArgumentException e) {
            throw new VerificationException.ExcessiveValue();
        }
        if (this.isCoinBase()) {
            if (this.inputs.get(0).getScriptBytes().length < 2 || this.inputs.get(0).getScriptBytes().length > 100) {
                throw new VerificationException.CoinbaseScriptSizeOutOfRange();
            }
        } else {
            for (TransactionInput input : this.inputs) {
                if (!input.isCoinBase()) continue;
                throw new VerificationException.UnexpectedCoinbaseInput();
            }
        }
    }

    public boolean isTimeLocked() {
        if (this.getLockTime() == 0L) {
            return false;
        }
        for (TransactionInput input : this.getInputs()) {
            if (!input.hasSequence()) continue;
            return true;
        }
        return false;
    }

    public boolean isFinal(int height, long blockTimeSeconds) {
        long time;
        return time < ((time = this.getLockTime()) < 500000000L ? (long)height : blockTimeSeconds) || !this.isTimeLocked();
    }

    public Date estimateLockTime(AbstractBlockChain chain) {
        if (this.lockTime < 500000000L) {
            return chain.estimateBlockTime((int)this.getLockTime());
        }
        return new Date(this.getLockTime() * 1000L);
    }

    public Purpose getPurpose() {
        return this.purpose;
    }

    public void setPurpose(Purpose purpose) {
        this.purpose = purpose;
    }

    @Nullable
    public ExchangeRate getExchangeRate() {
        return this.exchangeRate;
    }

    public void setExchangeRate(ExchangeRate exchangeRate) {
        this.exchangeRate = exchangeRate;
    }

    public String getMemo() {
        return this.memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public static enum SigHash {
        ALL,
        NONE,
        SINGLE;

    }

    public static enum Purpose {
        UNKNOWN,
        USER_PAYMENT,
        KEY_ROTATION,
        ASSURANCE_CONTRACT_CLAIM,
        ASSURANCE_CONTRACT_PLEDGE,
        ASSURANCE_CONTRACT_STUB,
        RAISE_FEE;

    }
}

