/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.Serializable;
import java.util.List;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutputChanges;

public class StoredUndoableBlock
implements Serializable {
    private static final long serialVersionUID = 5127353027086786117L;
    Sha256Hash blockHash;
    private TransactionOutputChanges txOutChanges;
    private List<Transaction> transactions;

    public StoredUndoableBlock(Sha256Hash hash, TransactionOutputChanges txOutChanges) {
        this.blockHash = hash;
        this.transactions = null;
        this.txOutChanges = txOutChanges;
    }

    public StoredUndoableBlock(Sha256Hash hash, List<Transaction> transactions) {
        this.blockHash = hash;
        this.txOutChanges = null;
        this.transactions = transactions;
    }

    public TransactionOutputChanges getTxOutChanges() {
        return this.txOutChanges;
    }

    public List<Transaction> getTransactions() {
        return this.transactions;
    }

    public Sha256Hash getHash() {
        return this.blockHash;
    }

    public int hashCode() {
        return this.blockHash.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoredUndoableBlock other = (StoredUndoableBlock)o;
        return this.getHash().equals(other.getHash());
    }

    public String toString() {
        return "Undoable Block " + this.blockHash;
    }
}

