/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import java.io.IOException;
import java.io.OutputStream;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.ProtocolException;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.VarInt;

public class RejectMessage
extends Message {
    private static final long serialVersionUID = -5246995579800334336L;
    private String message;
    private String reason;
    private RejectCode code;
    private Sha256Hash messageHash;

    public RejectMessage(NetworkParameters params, byte[] payload) throws ProtocolException {
        super(params, payload, 0);
    }

    public RejectMessage(NetworkParameters params, RejectCode code, Sha256Hash hash, String message, String reason) throws ProtocolException {
        super(params);
        this.code = code;
        this.messageHash = hash;
        this.message = message;
        this.reason = reason;
    }

    @Override
    protected void parseLite() throws ProtocolException {
        this.message = this.readStr();
        this.code = RejectCode.fromCode(this.readBytes(1)[0]);
        this.reason = this.readStr();
        if (this.message.equals("block") || this.message.equals("tx")) {
            this.messageHash = this.readHash();
        }
        this.length = this.cursor - this.offset;
    }

    @Override
    public void parse() throws ProtocolException {
        if (this.length == Integer.MIN_VALUE) {
            this.parseLite();
        }
    }

    @Override
    public void bitcoinSerializeToStream(OutputStream stream) throws IOException {
        byte[] messageBytes = this.message.getBytes("UTF-8");
        stream.write(new VarInt(messageBytes.length).encode());
        stream.write(messageBytes);
        stream.write(this.code.code);
        byte[] reasonBytes = this.reason.getBytes("UTF-8");
        stream.write(new VarInt(reasonBytes.length).encode());
        stream.write(reasonBytes);
        if (this.message.equals("block") || this.message.equals("tx")) {
            stream.write(this.messageHash.getReversedBytes());
        }
    }

    public String getRejectedMessage() {
        this.ensureParsed();
        return this.message;
    }

    public Sha256Hash getRejectedObjectHash() {
        this.ensureParsed();
        return this.messageHash;
    }

    public RejectCode getReasonCode() {
        return this.code;
    }

    public String getReasonString() {
        return this.reason;
    }

    public String toString() {
        Sha256Hash hash = this.getRejectedObjectHash();
        return String.format("Reject: %s %s for reason '%s' (%d)", this.getRejectedMessage(), hash != null ? hash : "", this.getReasonString(), this.getReasonCode().code);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RejectMessage other = (RejectMessage)o;
        return this.message.equals(other.message) && this.code.equals((Object)other.code) && this.reason.equals(other.reason) && this.messageHash.equals(other.messageHash);
    }

    public int hashCode() {
        int result = this.message.hashCode();
        result = 31 * result + this.reason.hashCode();
        result = 31 * result + this.code.hashCode();
        result = 31 * result + this.messageHash.hashCode();
        return result;
    }

    public static enum RejectCode {
        MALFORMED(1),
        INVALID(16),
        OBSOLETE(17),
        DUPLICATE(18),
        NONSTANDARD(64),
        DUST(65),
        INSUFFICIENTFEE(66),
        CHECKPOINT(67),
        OTHER(-1);

        byte code;

        private RejectCode(byte code) {
            this.code = code;
        }

        static RejectCode fromCode(byte code) {
            for (RejectCode rejectCode : RejectCode.values()) {
                if (rejectCode.code != code) continue;
                return rejectCode;
            }
            return OTHER;
        }
    }
}

