/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.core;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.Runnables;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.Uninterruptibles;
import com.squareup.okhttp.OkHttpClient;
import com.subgraph.orchid.TorClient;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.GuardedBy;
import org.bitcoinj.core.AbstractBlockChain;
import org.bitcoinj.core.AbstractPeerEventListener;
import org.bitcoinj.core.AbstractWalletEventListener;
import org.bitcoinj.core.Block;
import org.bitcoinj.core.BloomFilter;
import org.bitcoinj.core.Coin;
import org.bitcoinj.core.Context;
import org.bitcoinj.core.DownloadProgressTracker;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.FilteredBlock;
import org.bitcoinj.core.GetDataMessage;
import org.bitcoinj.core.InventoryItem;
import org.bitcoinj.core.Message;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Peer;
import org.bitcoinj.core.PeerAddress;
import org.bitcoinj.core.PeerEventListener;
import org.bitcoinj.core.PeerFilterProvider;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionBroadcast;
import org.bitcoinj.core.TransactionBroadcaster;
import org.bitcoinj.core.TransactionConfidence;
import org.bitcoinj.core.TransactionOutput;
import org.bitcoinj.core.TxConfidenceTable;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.core.Wallet;
import org.bitcoinj.crypto.DRMWorkaround;
import org.bitcoinj.net.BlockingClientManager;
import org.bitcoinj.net.ClientConnectionManager;
import org.bitcoinj.net.FilterMerger;
import org.bitcoinj.net.NioClientManager;
import org.bitcoinj.net.discovery.HttpDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.net.discovery.TorDiscovery;
import org.bitcoinj.script.Script;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.bitcoinj.utils.ExponentialBackoff;
import org.bitcoinj.utils.ListenerRegistration;
import org.bitcoinj.utils.Threading;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerGroup
implements TransactionBroadcaster {
    private static final Logger log = LoggerFactory.getLogger(PeerGroup.class);
    public static final int DEFAULT_CONNECTIONS = 12;
    private static final int TOR_TIMEOUT_SECONDS = 60;
    private volatile int vMaxPeersToDiscoverCount = 100;
    protected final ReentrantLock lock = Threading.lock("peergroup");
    private final NetworkParameters params;
    @Nullable
    private final AbstractBlockChain chain;
    protected final ListeningScheduledExecutorService executor;
    private volatile boolean vRunning;
    private volatile boolean vUsedUp;
    @GuardedBy(value="lock")
    private final PriorityQueue<PeerAddress> inactives;
    @GuardedBy(value="lock")
    private final Map<PeerAddress, ExponentialBackoff> backoffMap;
    private final CopyOnWriteArrayList<Peer> peers;
    private final CopyOnWriteArrayList<Peer> pendingPeers;
    private final ClientConnectionManager channels;
    @Nullable
    private final TorClient torClient;
    @GuardedBy(value="lock")
    private Peer downloadPeer;
    @Nullable
    @GuardedBy(value="lock")
    private PeerEventListener downloadListener;
    private final CopyOnWriteArrayList<ListenerRegistration<PeerEventListener>> peerEventListeners;
    private final CopyOnWriteArraySet<PeerDiscovery> peerDiscoverers;
    @GuardedBy(value="lock")
    private VersionMessage versionMessage;
    @GuardedBy(value="lock")
    private boolean downloadTxDependencies;
    @GuardedBy(value="lock")
    private int maxConnections;
    private volatile int vMinRequiredProtocolVersion = 70000;
    public static final long DEFAULT_PING_INTERVAL_MSEC = 2000L;
    @GuardedBy(value="lock")
    private long pingIntervalMsec = 2000L;
    @GuardedBy(value="lock")
    private boolean useLocalhostPeerWhenPossible = true;
    @GuardedBy(value="lock")
    private boolean ipv6Unreachable = false;
    @GuardedBy(value="lock")
    private long fastCatchupTimeSecs;
    private final CopyOnWriteArrayList<Wallet> wallets;
    private final CopyOnWriteArrayList<PeerFilterProvider> peerFilterProviders;
    private final AbstractPeerEventListener peerListener = new AbstractPeerEventListener(){

        @Override
        public List<Message> getData(Peer peer, GetDataMessage m) {
            return PeerGroup.this.handleGetData(m);
        }

        @Override
        public void onBlocksDownloaded(Peer peer, Block block, @Nullable FilteredBlock filteredBlock, int blocksLeft) {
            double target;
            if (PeerGroup.this.chain == null) {
                return;
            }
            double rate = PeerGroup.this.chain.getFalsePositiveRate();
            if (rate > (target = PeerGroup.this.bloomFilterMerger.getBloomFilterFPRate() * 10.0)) {
                if (log.isDebugEnabled()) {
                    log.debug("Force update Bloom filter due to high false positive rate ({} vs {})", (Object)rate, (Object)target);
                }
                PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.FORCE_SEND_FOR_REFRESH);
            }
        }
    };
    private int minBroadcastConnections = 0;
    private final AbstractWalletEventListener walletEventListener = new AbstractWalletEventListener(){

        @Override
        public void onScriptsChanged(Wallet wallet, List<Script> scripts, boolean isAddingScripts) {
            PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
        }

        @Override
        public void onKeysAdded(List<ECKey> keys) {
            PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
        }

        @Override
        public void onCoinsReceived(Wallet wallet, Transaction tx, Coin prevBalance, Coin newBalance) {
            for (TransactionOutput output : tx.getOutputs()) {
                if (!output.getScriptPubKey().isSentToRawPubKey() || !output.isMine(wallet)) continue;
                if (tx.getConfidence().getConfidenceType() == TransactionConfidence.ConfidenceType.BUILDING) {
                    PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
                } else {
                    PeerGroup.this.recalculateFastCatchupAndFilter(FilterRecalculateMode.DONT_SEND);
                }
                return;
            }
        }
    };
    private final ExponentialBackoff.Params peerBackoffParams = new ExponentialBackoff.Params(1000L, 1.5f, 600000L);
    @GuardedBy(value="lock")
    private ExponentialBackoff groupBackoff = new ExponentialBackoff(new ExponentialBackoff.Params(1000L, 1.5f, 10000L));
    private final Set<TransactionBroadcast> runningBroadcasts;
    private final PeerEventListener startupListener = new PeerStartupListener();
    public static final double DEFAULT_BLOOM_FILTER_FP_RATE = 1.0E-5;
    public static final double MAX_FP_RATE_INCREASE = 10.0;
    private final FilterMerger bloomFilterMerger;
    public static final int DEFAULT_CONNECT_TIMEOUT_MILLIS = 5000;
    private volatile int vConnectTimeoutMillis = 5000;
    private volatile boolean vBloomFilteringEnabled = true;
    private CountDownLatch executorStartupLatch = new CountDownLatch(1);
    private Runnable triggerConnectionsJob = new Runnable(){
        private boolean firstRun = true;

        @Override
        public void run() {
            try {
                this.go();
            }
            catch (Throwable e) {
                log.error("Exception when trying to build connections", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void go() {
            if (!PeerGroup.this.vRunning) {
                return;
            }
            boolean doDiscovery = false;
            long now = Utils.currentTimeMillis();
            PeerGroup.this.lock.lock();
            try {
                if (!Utils.isAndroidRuntime() && PeerGroup.this.useLocalhostPeerWhenPossible && PeerGroup.this.maybeCheckForLocalhostPeer() && this.firstRun) {
                    log.info("Localhost peer detected, trying to use it instead of P2P discovery");
                    PeerGroup.this.maxConnections = 0;
                    PeerGroup.this.connectToLocalHost();
                    return;
                }
                boolean havePeerWeCanTry = !PeerGroup.this.inactives.isEmpty() && ((ExponentialBackoff)PeerGroup.this.backoffMap.get(PeerGroup.this.inactives.peek())).getRetryTime() <= now;
                doDiscovery = !havePeerWeCanTry;
            }
            finally {
                this.firstRun = false;
                PeerGroup.this.lock.unlock();
            }
            boolean discoverySuccess = false;
            if (doDiscovery) {
                try {
                    discoverySuccess = PeerGroup.this.discoverPeers() > 0;
                }
                catch (PeerDiscoveryException e) {
                    log.error("Peer discovery failure", (Throwable)e);
                }
            }
            PeerGroup.this.lock.lock();
            try {
                PeerAddress addrToTry;
                if (doDiscovery) {
                    if (discoverySuccess) {
                        PeerGroup.this.groupBackoff.trackSuccess();
                    } else {
                        PeerGroup.this.groupBackoff.trackFailure();
                    }
                }
                if (PeerGroup.this.inactives.isEmpty()) {
                    if (PeerGroup.this.countConnectedAndPendingPeers() < PeerGroup.this.getMaxConnections()) {
                        log.info("Peer discovery didn't provide us any more peers, will try again later.");
                        PeerGroup.this.executor.schedule((Runnable)this, PeerGroup.this.groupBackoff.getRetryTime() - now, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                do {
                    addrToTry = (PeerAddress)PeerGroup.this.inactives.poll();
                } while (PeerGroup.this.ipv6Unreachable && addrToTry.getAddr() instanceof Inet6Address);
                long retryTime = ((ExponentialBackoff)PeerGroup.this.backoffMap.get(addrToTry)).getRetryTime();
                if ((retryTime = Math.max(retryTime, PeerGroup.this.groupBackoff.getRetryTime())) > now) {
                    long delay = retryTime - now;
                    log.info("Waiting {} msec before next connect attempt {}", (Object)delay, (Object)(addrToTry == null ? "" : "to " + addrToTry));
                    PeerGroup.this.inactives.add(addrToTry);
                    PeerGroup.this.executor.schedule((Runnable)this, delay, TimeUnit.MILLISECONDS);
                    return;
                }
                PeerGroup.this.connectTo(addrToTry, false, PeerGroup.this.vConnectTimeoutMillis);
            }
            finally {
                PeerGroup.this.lock.unlock();
            }
            if (PeerGroup.this.countConnectedAndPendingPeers() < PeerGroup.this.getMaxConnections()) {
                PeerGroup.this.executor.execute((Runnable)this);
            }
        }
    };
    private LocalhostCheckState localhostCheckState = LocalhostCheckState.NOT_TRIED;
    private final Map<FilterRecalculateMode, SettableFuture<BloomFilter>> inFlightRecalculations = Maps.newHashMap();
    @Nullable
    private volatile ListenableScheduledFuture<?> vPingTask;
    @GuardedBy(value="lock")
    private int stallPeriodSeconds = 10;
    @GuardedBy(value="lock")
    private int stallMinSpeedBytesSec = 1600;
    @Nullable
    private ChainDownloadSpeedCalculator chainDownloadSpeedCalculator;

    public PeerGroup(NetworkParameters params) {
        this(params, null);
    }

    public PeerGroup(Context context) {
        this(context, null);
    }

    public PeerGroup(NetworkParameters params, @Nullable AbstractBlockChain chain) {
        this(Context.getOrCreate(params), chain, (ClientConnectionManager)new NioClientManager());
    }

    public PeerGroup(Context context, @Nullable AbstractBlockChain chain) {
        this(context, chain, (ClientConnectionManager)new NioClientManager());
    }

    public static PeerGroup newWithTor(NetworkParameters params, @Nullable AbstractBlockChain chain, TorClient torClient) throws TimeoutException {
        return PeerGroup.newWithTor(Context.getOrCreate(params), chain, torClient);
    }

    public static PeerGroup newWithTor(Context context, @Nullable AbstractBlockChain chain, TorClient torClient) throws TimeoutException {
        return PeerGroup.newWithTor(context, chain, torClient, true);
    }

    public static PeerGroup newWithTor(Context context, @Nullable AbstractBlockChain chain, TorClient torClient, boolean doDiscovery) throws TimeoutException {
        Preconditions.checkNotNull((Object)torClient);
        DRMWorkaround.maybeDisableExportControls();
        BlockingClientManager manager = new BlockingClientManager(torClient.getSocketFactory());
        int CONNECT_TIMEOUT_MSEC = 60000;
        manager.setConnectTimeoutMillis(60000);
        PeerGroup result = new PeerGroup(context, chain, manager, torClient);
        result.setConnectTimeoutMillis(60000);
        if (doDiscovery) {
            NetworkParameters params = context.getParams();
            HttpDiscovery.Details[] httpSeeds = params.getHttpSeeds();
            if (httpSeeds.length > 0) {
                OkHttpClient client = new OkHttpClient();
                client.setSocketFactory(torClient.getSocketFactory());
                result.addPeerDiscovery(new HttpDiscovery(params, httpSeeds[0], client));
            } else {
                result.addPeerDiscovery(new TorDiscovery(params, torClient));
            }
        }
        return result;
    }

    public PeerGroup(NetworkParameters params, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager) {
        this(Context.getOrCreate(params), chain, connectionManager, null);
    }

    public PeerGroup(Context context, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager) {
        this(context, chain, connectionManager, null);
    }

    private PeerGroup(Context context, @Nullable AbstractBlockChain chain, ClientConnectionManager connectionManager, @Nullable TorClient torClient) {
        Preconditions.checkNotNull((Object)context);
        this.params = context.getParams();
        this.chain = chain;
        this.fastCatchupTimeSecs = this.params.getGenesisBlock().getTimeSeconds();
        this.wallets = new CopyOnWriteArrayList();
        this.peerFilterProviders = new CopyOnWriteArrayList();
        this.torClient = torClient;
        this.executor = this.createPrivateExecutor();
        this.maxConnections = 0;
        int height = chain == null ? 0 : chain.getBestChainHeight();
        this.versionMessage = new VersionMessage(this.params, height);
        this.versionMessage.relayTxesBeforeFilter = true;
        this.downloadTxDependencies = true;
        this.inactives = new PriorityQueue<PeerAddress>(1, new Comparator<PeerAddress>(){

            @Override
            public int compare(PeerAddress a, PeerAddress b) {
                Preconditions.checkState((boolean)PeerGroup.this.lock.isHeldByCurrentThread());
                int result = ((ExponentialBackoff)PeerGroup.this.backoffMap.get(a)).compareTo((ExponentialBackoff)PeerGroup.this.backoffMap.get(b));
                if (result == 0) {
                    result = Ints.compare((int)a.getPort(), (int)b.getPort());
                }
                return result;
            }
        });
        this.backoffMap = new HashMap<PeerAddress, ExponentialBackoff>();
        this.peers = new CopyOnWriteArrayList();
        this.pendingPeers = new CopyOnWriteArrayList();
        this.channels = connectionManager;
        this.peerDiscoverers = new CopyOnWriteArraySet();
        this.peerEventListeners = new CopyOnWriteArrayList();
        this.runningBroadcasts = Collections.synchronizedSet(new HashSet());
        this.bloomFilterMerger = new FilterMerger(1.0E-5);
    }

    protected ListeningScheduledExecutorService createPrivateExecutor() {
        ListeningScheduledExecutorService result = MoreExecutors.listeningDecorator((ScheduledExecutorService)new ScheduledThreadPoolExecutor(1, new ContextPropagatingThreadFactory("PeerGroup Thread")));
        result.execute(new Runnable(){

            @Override
            public void run() {
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)PeerGroup.this.executorStartupLatch);
            }
        });
        return result;
    }

    public void setMaxConnections(int maxConnections) {
        this.lock.lock();
        try {
            this.maxConnections = maxConnections;
            if (!this.isRunning()) {
                return;
            }
        }
        finally {
            this.lock.unlock();
        }
        int adjustment = maxConnections - this.channels.getConnectedClientCount();
        if (adjustment > 0) {
            this.triggerConnections();
        }
        if (adjustment < 0) {
            this.channels.closeConnections(-adjustment);
        }
    }

    public void setDownloadTxDependencies(boolean downloadTxDependencies) {
        this.lock.lock();
        try {
            this.downloadTxDependencies = downloadTxDependencies;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void triggerConnections() {
        if (!this.executor.isShutdown()) {
            this.executor.execute(this.triggerConnectionsJob);
        }
    }

    public int getMaxConnections() {
        this.lock.lock();
        try {
            int n = this.maxConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Message> handleGetData(GetDataMessage m) {
        this.lock.lock();
        try {
            LinkedList<Message> transactions = new LinkedList<Message>();
            LinkedList<InventoryItem> items = new LinkedList<InventoryItem>(m.getItems());
            Iterator it = items.iterator();
            block3: while (it.hasNext()) {
                InventoryItem item = (InventoryItem)it.next();
                for (Wallet w : this.wallets) {
                    Transaction tx = w.getTransaction(item.hash);
                    if (tx == null) continue;
                    transactions.add(tx);
                    it.remove();
                    continue block3;
                }
            }
            LinkedList<Message> linkedList = transactions;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setVersionMessage(VersionMessage ver) {
        this.lock.lock();
        try {
            this.versionMessage = ver;
        }
        finally {
            this.lock.unlock();
        }
    }

    public VersionMessage getVersionMessage() {
        this.lock.lock();
        try {
            VersionMessage versionMessage = this.versionMessage;
            return versionMessage;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version, @Nullable String comments) {
        int height = this.chain == null ? 0 : this.chain.getBestChainHeight();
        VersionMessage ver = new VersionMessage(this.params, height);
        ver.relayTxesBeforeFilter = false;
        this.updateVersionMessageRelayTxesBeforeFilter(ver);
        ver.appendToSubVer(name, version, comments);
        this.setVersionMessage(ver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionMessageRelayTxesBeforeFilter(VersionMessage ver) {
        this.lock.lock();
        try {
            boolean spvMode = this.chain != null && !this.chain.shouldVerifyTransactions();
            boolean willSendFilter = spvMode && this.peerFilterProviders.size() > 0 && this.vBloomFilteringEnabled;
            ver.relayTxesBeforeFilter = !willSendFilter;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUserAgent(String name, String version) {
        this.setUserAgent(name, version, null);
    }

    public void addEventListener(PeerEventListener listener, Executor executor) {
        this.peerEventListeners.add(new ListenerRegistration<Object>(Preconditions.checkNotNull((Object)listener), executor));
        for (Peer peer : this.getConnectedPeers()) {
            peer.addEventListener(listener, executor);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.addEventListener(listener, executor);
        }
    }

    public void addEventListener(PeerEventListener listener) {
        this.addEventListener(listener, Threading.USER_THREAD);
    }

    public boolean removeEventListener(PeerEventListener listener) {
        boolean result = ListenerRegistration.removeFromList(listener, this.peerEventListeners);
        for (Peer peer : this.getConnectedPeers()) {
            peer.removeEventListener(listener);
        }
        for (Peer peer : this.getPendingPeers()) {
            peer.removeEventListener(listener);
        }
        return result;
    }

    public void clearEventListeners() {
        this.peerEventListeners.clear();
    }

    public List<Peer> getConnectedPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.peers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public List<Peer> getPendingPeers() {
        this.lock.lock();
        try {
            ArrayList<Peer> arrayList = new ArrayList<Peer>(this.pendingPeers);
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addAddress(PeerAddress peerAddress) {
        int newMax;
        this.lock.lock();
        try {
            this.addInactive(peerAddress);
            newMax = this.getMaxConnections() + 1;
        }
        finally {
            this.lock.unlock();
        }
        this.setMaxConnections(newMax);
    }

    private void addInactive(PeerAddress peerAddress) {
        this.lock.lock();
        try {
            if (this.backoffMap.containsKey(peerAddress)) {
                return;
            }
            this.backoffMap.put(peerAddress, new ExponentialBackoff(this.peerBackoffParams));
            this.inactives.offer(peerAddress);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addAddress(InetAddress address) {
        this.addAddress(new PeerAddress(address, this.params.getPort()));
    }

    public void addPeerDiscovery(PeerDiscovery peerDiscovery) {
        this.lock.lock();
        try {
            if (this.getMaxConnections() == 0) {
                this.setMaxConnections(12);
            }
            this.peerDiscoverers.add(peerDiscovery);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected int discoverPeers() throws PeerDiscoveryException {
        Preconditions.checkState((!this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
        int maxPeersToDiscoverCount = this.vMaxPeersToDiscoverCount;
        long start = System.currentTimeMillis();
        LinkedList addressList = Lists.newLinkedList();
        for (PeerDiscovery peerDiscovery : this.peerDiscoverers) {
            InetSocketAddress[] addresses;
            for (InetSocketAddress address : addresses = peerDiscovery.getPeers(5L, TimeUnit.SECONDS)) {
                addressList.add(new PeerAddress(address));
            }
            if (addressList.size() < maxPeersToDiscoverCount) continue;
            break;
        }
        if (!addressList.isEmpty()) {
            for (PeerAddress address : addressList) {
                this.addInactive(address);
            }
            final ImmutableSet peersDiscoveredSet = ImmutableSet.copyOf((Collection)addressList);
            for (final ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
                registration.executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        ((PeerEventListener)registration.listener).onPeersDiscovered((Set<PeerAddress>)peersDiscoveredSet);
                    }
                });
            }
        }
        log.info("Peer discovery took {}msec and returned {} items", (Object)(System.currentTimeMillis() - start), (Object)addressList.size());
        return addressList.size();
    }

    @VisibleForTesting
    void waitForJobQueue() {
        Futures.getUnchecked((Future)this.executor.submit(Runnables.doNothing()));
    }

    private int countConnectedAndPendingPeers() {
        this.lock.lock();
        try {
            int n = this.peers.size() + this.pendingPeers.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean maybeCheckForLocalhostPeer() {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        if (this.localhostCheckState == LocalhostCheckState.NOT_TRIED) {
            try {
                Socket socket = new Socket();
                socket.connect(new InetSocketAddress(InetAddresses.forString((String)"127.0.0.1"), this.params.getPort()), this.vConnectTimeoutMillis);
                this.localhostCheckState = LocalhostCheckState.FOUND;
                try {
                    socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            catch (IOException e) {
                log.info("Localhost peer not detected.");
                this.localhostCheckState = LocalhostCheckState.NOT_THERE;
            }
        }
        return false;
    }

    public ListenableFuture startAsync() {
        if (this.chain == null) {
            log.warn("Starting up with no attached block chain. Did you forget to pass one to the constructor?");
        }
        Preconditions.checkState((!this.vUsedUp ? 1 : 0) != 0, (Object)"Cannot start a peer group twice");
        this.vRunning = true;
        this.vUsedUp = true;
        this.executorStartupLatch.countDown();
        return this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info("Starting ...");
                    if (PeerGroup.this.torClient != null) {
                        log.info("Starting Tor/Orchid ...");
                        PeerGroup.this.torClient.start();
                        try {
                            PeerGroup.this.torClient.waitUntilReady(60000L);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                        log.info("Tor ready");
                    }
                    PeerGroup.this.channels.startAsync();
                    PeerGroup.this.channels.awaitRunning();
                    PeerGroup.this.triggerConnections();
                    PeerGroup.this.setupPinging();
                }
                catch (Throwable e) {
                    log.error("Exception when starting up", e);
                }
            }
        });
    }

    public void start() {
        Futures.getUnchecked((Future)this.startAsync());
    }

    @Deprecated
    public void awaitRunning() {
        this.waitForJobQueue();
    }

    public ListenableFuture stopAsync() {
        Preconditions.checkState((boolean)this.vRunning);
        this.vRunning = false;
        ListenableFuture future = this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    log.info("Stopping ...");
                    PeerGroup.this.channels.stopAsync();
                    PeerGroup.this.channels.awaitTerminated();
                    for (PeerDiscovery peerDiscovery : PeerGroup.this.peerDiscoverers) {
                        peerDiscovery.shutdown();
                    }
                    if (PeerGroup.this.torClient != null) {
                        PeerGroup.this.torClient.stop();
                    }
                    PeerGroup.this.vRunning = false;
                    log.info("Stopped.");
                }
                catch (Throwable e) {
                    log.error("Exception when shutting down", e);
                }
            }
        });
        this.executor.shutdown();
        return future;
    }

    public void stop() {
        try {
            this.stopAsync();
            log.info("Awaiting PeerGroup shutdown ...");
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void awaitTerminated() {
        try {
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWallet(Wallet wallet) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)wallet);
            Preconditions.checkState((!this.wallets.contains(wallet) ? 1 : 0) != 0);
            this.wallets.add(wallet);
            wallet.setTransactionBroadcaster(this);
            wallet.addEventListener(this.walletEventListener, Threading.SAME_THREAD);
            this.addPeerFilterProvider(wallet);
            for (Peer peer : this.peers) {
                peer.addWallet(wallet);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<BloomFilter> addPeerFilterProvider(PeerFilterProvider provider) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)provider);
            Preconditions.checkState((!this.peerFilterProviders.contains(provider) ? 1 : 0) != 0);
            this.peerFilterProviders.add(0, provider);
            ListenableFuture<BloomFilter> future = this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
            this.updateVersionMessageRelayTxesBeforeFilter(this.getVersionMessage());
            ListenableFuture<BloomFilter> listenableFuture = future;
            return listenableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removePeerFilterProvider(PeerFilterProvider provider) {
        this.lock.lock();
        try {
            Preconditions.checkNotNull((Object)provider);
            Preconditions.checkArgument((boolean)this.peerFilterProviders.remove(provider));
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeWallet(Wallet wallet) {
        this.wallets.remove(Preconditions.checkNotNull((Object)wallet));
        this.peerFilterProviders.remove(wallet);
        wallet.removeEventListener(this.walletEventListener);
        wallet.setTransactionBroadcaster(null);
        for (Peer peer : this.peers) {
            peer.removeWallet(wallet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<BloomFilter> recalculateFastCatchupAndFilter(final FilterRecalculateMode mode) {
        final SettableFuture future = SettableFuture.create();
        Map<FilterRecalculateMode, SettableFuture<BloomFilter>> map = this.inFlightRecalculations;
        synchronized (map) {
            if (this.inFlightRecalculations.get((Object)mode) != null) {
                return (ListenableFuture)this.inFlightRecalculations.get((Object)mode);
            }
            this.inFlightRecalculations.put(mode, (SettableFuture<BloomFilter>)future);
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                try {
                    this.go();
                }
                catch (Throwable e) {
                    log.error("Exception when trying to recalculate Bloom filter", e);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void go() {
                boolean send;
                Preconditions.checkState((!PeerGroup.this.lock.isHeldByCurrentThread() ? 1 : 0) != 0);
                if (PeerGroup.this.chain != null && PeerGroup.this.chain.shouldVerifyTransactions() || !PeerGroup.this.vBloomFilteringEnabled) {
                    return;
                }
                FilterMerger.Result result = PeerGroup.this.bloomFilterMerger.calculate((ImmutableList<PeerFilterProvider>)ImmutableList.copyOf((Collection)PeerGroup.this.peerFilterProviders));
                switch (mode) {
                    case SEND_IF_CHANGED: {
                        send = result.changed;
                        break;
                    }
                    case DONT_SEND: {
                        send = false;
                        break;
                    }
                    case FORCE_SEND_FOR_REFRESH: {
                        send = true;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
                if (send) {
                    for (Peer peer : PeerGroup.this.peers) {
                        peer.setBloomFilter(result.filter, mode != FilterRecalculateMode.FORCE_SEND_FOR_REFRESH);
                    }
                    if (PeerGroup.this.chain != null) {
                        PeerGroup.this.chain.resetFalsePositiveEstimate();
                    }
                }
                PeerGroup.this.setFastCatchupTimeSecs(result.earliestKeyTimeSecs);
                Map map = PeerGroup.this.inFlightRecalculations;
                synchronized (map) {
                    PeerGroup.this.inFlightRecalculations.put(mode, null);
                }
                future.set((Object)result.filter);
            }
        };
        try {
            this.executor.execute(command);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        return future;
    }

    public void setBloomFilterFalsePositiveRate(double bloomFilterFPRate) {
        this.lock.lock();
        try {
            this.bloomFilterMerger.setBloomFilterFPRate(bloomFilterFPRate);
            this.recalculateFastCatchupAndFilter(FilterRecalculateMode.SEND_IF_CHANGED);
        }
        finally {
            this.lock.unlock();
        }
    }

    public int numConnectedPeers() {
        return this.peers.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Peer connectTo(InetSocketAddress address) {
        this.lock.lock();
        try {
            PeerAddress peerAddress = new PeerAddress(address);
            this.backoffMap.put(peerAddress, new ExponentialBackoff(this.peerBackoffParams));
            Peer peer = this.connectTo(peerAddress, true, this.vConnectTimeoutMillis);
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public Peer connectToLocalHost() {
        this.lock.lock();
        try {
            PeerAddress localhost = PeerAddress.localhost(this.params);
            this.backoffMap.put(localhost, new ExponentialBackoff(this.peerBackoffParams));
            Peer peer = this.connectTo(localhost, true, this.vConnectTimeoutMillis);
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    @GuardedBy(value="lock")
    protected Peer connectTo(PeerAddress address, boolean incrementMaxConnections, int connectTimeoutMillis) {
        Preconditions.checkState((boolean)this.lock.isHeldByCurrentThread());
        VersionMessage ver = this.getVersionMessage().duplicate();
        ver.bestHeight = this.chain == null ? 0L : (long)this.chain.getBestChainHeight();
        ver.time = Utils.currentTimeSeconds();
        Peer peer = new Peer(this.params, ver, address, this.chain, this.downloadTxDependencies);
        peer.addEventListener(this.startupListener, Threading.SAME_THREAD);
        peer.setMinProtocolVersion(this.vMinRequiredProtocolVersion);
        this.pendingPeers.add(peer);
        try {
            log.info("Attempting connection to {}     ({} connected, {} pending, {} max)", new Object[]{address, this.peers.size(), this.pendingPeers.size(), this.maxConnections});
            ListenableFuture<SocketAddress> future = this.channels.openConnection(address.toSocketAddress(), peer);
            if (future.isDone()) {
                Uninterruptibles.getUninterruptibly(future);
            }
        }
        catch (ExecutionException e) {
            Throwable cause = Throwables.getRootCause((Throwable)e);
            log.warn("Failed to connect to " + address + ": " + cause.getMessage());
            this.handlePeerDeath(peer, cause);
            return null;
        }
        peer.setSocketTimeout(connectTimeoutMillis);
        if (incrementMaxConnections) {
            ++this.maxConnections;
        }
        return peer;
    }

    public void setConnectTimeoutMillis(int connectTimeoutMillis) {
        this.vConnectTimeoutMillis = connectTimeoutMillis;
    }

    public void startBlockChainDownload(PeerEventListener listener) {
        this.lock.lock();
        try {
            if (this.downloadPeer != null && this.downloadListener != null) {
                this.downloadPeer.removeEventListener(this.downloadListener);
            }
            if (this.downloadPeer != null && listener != null) {
                this.downloadPeer.addEventListener(listener);
            }
            this.downloadListener = listener;
            if (!this.peers.isEmpty()) {
                this.startBlockChainDownloadFromPeer(this.peers.iterator().next());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void downloadBlockChain() {
        DownloadProgressTracker listener = new DownloadProgressTracker();
        this.startBlockChainDownload(listener);
        try {
            listener.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleNewPeer(final Peer peer) {
        int newSize = -1;
        this.lock.lock();
        try {
            this.groupBackoff.trackSuccess();
            this.backoffMap.get(peer.getAddress()).trackSuccess();
            this.pendingPeers.remove(peer);
            this.peers.add(peer);
            newSize = this.peers.size();
            log.info("{}: New peer      ({} connected, {} pending, {} max)", new Object[]{peer, newSize, this.pendingPeers.size(), this.maxConnections});
            if (this.bloomFilterMerger.getLastFilter() != null) {
                peer.setBloomFilter(this.bloomFilterMerger.getLastFilter());
            }
            peer.setDownloadData(false);
            for (Wallet wallet : this.wallets) {
                peer.addWallet(wallet);
            }
            if (this.downloadPeer == null) {
                boolean shouldDownloadChain;
                this.setDownloadPeer(this.selectDownloadPeer(this.peers));
                boolean bl = shouldDownloadChain = this.downloadListener != null && this.chain != null;
                if (shouldDownloadChain) {
                    this.startBlockChainDownloadFromPeer(this.downloadPeer);
                }
            }
            peer.addEventListener(this.peerListener, Threading.SAME_THREAD);
            for (ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
                peer.addEventListenerWithoutOnDisconnect((PeerEventListener)registration.listener, registration.executor);
            }
        }
        finally {
            this.lock.unlock();
        }
        final int fNewSize = newSize;
        for (final ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onPeerConnected(peer, fNewSize);
                }
            });
        }
    }

    private void setupPinging() {
        if (this.getPingIntervalMsec() <= 0L) {
            return;
        }
        this.vPingTask = this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (PeerGroup.this.getPingIntervalMsec() <= 0L) {
                        ListenableScheduledFuture task = PeerGroup.this.vPingTask;
                        if (task != null) {
                            task.cancel(false);
                            PeerGroup.this.vPingTask = null;
                        }
                        return;
                    }
                    for (Peer peer : PeerGroup.this.getConnectedPeers()) {
                        if (peer.getPeerVersionMessage().clientVersion < 60001) continue;
                        peer.ping();
                    }
                }
                catch (Throwable e) {
                    log.error("Exception in ping loop", e);
                }
            }
        }, this.getPingIntervalMsec(), this.getPingIntervalMsec(), TimeUnit.MILLISECONDS);
    }

    private void setDownloadPeer(@Nullable Peer peer) {
        this.lock.lock();
        try {
            if (this.downloadPeer == peer) {
                return;
            }
            if (this.downloadPeer != null) {
                log.info("Unsetting download peer: {}", (Object)this.downloadPeer);
                if (this.downloadListener != null) {
                    this.downloadPeer.removeEventListener(this.downloadListener);
                }
                this.downloadPeer.setDownloadData(false);
            }
            this.downloadPeer = peer;
            if (this.downloadPeer != null) {
                log.info("Setting download peer: {}", (Object)this.downloadPeer);
                if (this.downloadListener != null) {
                    peer.addEventListener(this.downloadListener, Threading.SAME_THREAD);
                }
                this.downloadPeer.setDownloadData(true);
                if (this.chain != null) {
                    this.downloadPeer.setDownloadParameters(this.fastCatchupTimeSecs, this.bloomFilterMerger.getLastFilter() != null);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Deprecated
    @Nullable
    public TxConfidenceTable getMemoryPool() {
        return Context.get().getConfidenceTable();
    }

    public void setFastCatchupTimeSecs(long secondsSinceEpoch) {
        this.lock.lock();
        try {
            Preconditions.checkState((this.chain == null || !this.chain.shouldVerifyTransactions() ? 1 : 0) != 0, (Object)"Fast catchup is incompatible with fully verifying");
            this.fastCatchupTimeSecs = secondsSinceEpoch;
            if (this.downloadPeer != null) {
                this.downloadPeer.setDownloadParameters(secondsSinceEpoch, this.bloomFilterMerger.getLastFilter() != null);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public long getFastCatchupTimeSecs() {
        this.lock.lock();
        try {
            long l = this.fastCatchupTimeSecs;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handlePeerDeath(final Peer peer, @Nullable Throwable exception) {
        if (!this.isRunning()) {
            return;
        }
        int numConnectedPeers = 0;
        this.lock.lock();
        try {
            this.pendingPeers.remove(peer);
            this.peers.remove(peer);
            PeerAddress address = peer.getAddress();
            log.info("{}: Peer died      ({} connected, {} pending, {} max)", new Object[]{address, this.peers.size(), this.pendingPeers.size(), this.maxConnections});
            if (peer == this.downloadPeer) {
                log.info("Download peer died. Picking a new one.");
                this.setDownloadPeer(null);
                Peer newDownloadPeer = this.selectDownloadPeer(this.peers);
                if (newDownloadPeer != null) {
                    this.setDownloadPeer(newDownloadPeer);
                    if (this.downloadListener != null) {
                        this.startBlockChainDownloadFromPeer(newDownloadPeer);
                    }
                }
            }
            int numPeers = this.peers.size() + this.pendingPeers.size();
            numConnectedPeers = this.peers.size();
            this.groupBackoff.trackFailure();
            if (exception instanceof NoRouteToHostException) {
                if (address.getAddr() instanceof Inet6Address && !this.ipv6Unreachable) {
                    this.ipv6Unreachable = true;
                    log.warn("IPv6 peer connect failed due to routing failure, ignoring IPv6 addresses from now on");
                }
            } else {
                this.backoffMap.get(address).trackFailure();
                this.inactives.offer(address);
            }
            if (numPeers < this.getMaxConnections()) {
                this.triggerConnections();
            }
        }
        finally {
            this.lock.unlock();
        }
        peer.removeEventListener(this.peerListener);
        for (Wallet wallet : this.wallets) {
            peer.removeWallet(wallet);
        }
        final int fNumConnectedPeers = numConnectedPeers;
        for (final ListenerRegistration<PeerEventListener> registration : this.peerEventListeners) {
            registration.executor.execute(new Runnable(){

                @Override
                public void run() {
                    ((PeerEventListener)registration.listener).onPeerDisconnected(peer, fNumConnectedPeers);
                }
            });
            peer.removeEventListener((PeerEventListener)registration.listener);
        }
    }

    public void setStallThreshold(int periodSecs, int bytesPerSecond) {
        this.lock.lock();
        try {
            this.stallPeriodSeconds = periodSecs;
            this.stallMinSpeedBytesSec = bytesPerSecond;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startBlockChainDownloadFromPeer(Peer peer) {
        this.lock.lock();
        try {
            this.setDownloadPeer(peer);
            if (this.chainDownloadSpeedCalculator == null) {
                this.chainDownloadSpeedCalculator = new ChainDownloadSpeedCalculator();
                this.executor.scheduleAtFixedRate((Runnable)this.chainDownloadSpeedCalculator, 1L, 1L, TimeUnit.SECONDS);
            }
            peer.addEventListener(this.chainDownloadSpeedCalculator, Threading.SAME_THREAD);
            peer.startBlockChainDownload();
        }
        finally {
            this.lock.unlock();
        }
    }

    public ListenableFuture<List<Peer>> waitForPeers(int numPeers) {
        return this.waitForPeersOfVersion(numPeers, 0L);
    }

    public ListenableFuture<List<Peer>> waitForPeersOfVersion(final int numPeers, final long protocolVersion) {
        List<Peer> foundPeers = this.findPeersOfAtLeastVersion(protocolVersion);
        if (foundPeers.size() >= numPeers) {
            return Futures.immediateFuture(foundPeers);
        }
        final SettableFuture future = SettableFuture.create();
        this.addEventListener(new AbstractPeerEventListener(){

            @Override
            public void onPeerConnected(Peer peer, int peerCount) {
                List<Peer> peers = PeerGroup.this.findPeersOfAtLeastVersion(protocolVersion);
                if (peers.size() >= numPeers) {
                    future.set(peers);
                    PeerGroup.this.removeEventListener(this);
                }
            }
        });
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> findPeersOfAtLeastVersion(long protocolVersion) {
        this.lock.lock();
        try {
            ArrayList<Peer> results = new ArrayList<Peer>(this.peers.size());
            for (Peer peer : this.peers) {
                if ((long)peer.getPeerVersionMessage().clientVersion < protocolVersion) continue;
                results.add(peer);
            }
            ArrayList<Peer> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<List<Peer>> waitForPeersWithServiceMask(final int numPeers, final int mask) {
        this.lock.lock();
        try {
            List<Peer> foundPeers = this.findPeersWithServiceMask(mask);
            if (foundPeers.size() >= numPeers) {
                ListenableFuture listenableFuture = Futures.immediateFuture(foundPeers);
                return listenableFuture;
            }
            final SettableFuture future = SettableFuture.create();
            this.addEventListener(new AbstractPeerEventListener(){

                @Override
                public void onPeerConnected(Peer peer, int peerCount) {
                    List<Peer> peers = PeerGroup.this.findPeersWithServiceMask(mask);
                    if (peers.size() >= numPeers) {
                        future.set(peers);
                        PeerGroup.this.removeEventListener(this);
                    }
                }
            });
            SettableFuture settableFuture = future;
            return settableFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peer> findPeersWithServiceMask(int mask) {
        this.lock.lock();
        try {
            ArrayList<Peer> results = new ArrayList<Peer>(this.peers.size());
            for (Peer peer : this.peers) {
                if ((peer.getPeerVersionMessage().localServices & (long)mask) != (long)mask) continue;
                results.add(peer);
            }
            ArrayList<Peer> arrayList = results;
            return arrayList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMinBroadcastConnections() {
        this.lock.lock();
        try {
            if (this.minBroadcastConnections == 0) {
                int max = this.getMaxConnections();
                if (max <= 1) {
                    int n = max;
                    return n;
                }
                int n = (int)Math.round((double)this.getMaxConnections() * 0.8);
                return n;
            }
            int n = this.minBroadcastConnections;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMinBroadcastConnections(int value) {
        this.lock.lock();
        try {
            this.minBroadcastConnections = value;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public TransactionBroadcast broadcastTransaction(Transaction tx) {
        return this.broadcastTransaction(tx, Math.max(1, this.getMinBroadcastConnections()));
    }

    public TransactionBroadcast broadcastTransaction(Transaction tx, int minConnections) {
        if (tx.getConfidence().getSource().equals((Object)TransactionConfidence.Source.UNKNOWN)) {
            tx.getConfidence().setSource(TransactionConfidence.Source.SELF);
        }
        final TransactionBroadcast broadcast = new TransactionBroadcast(this, tx);
        broadcast.setMinConnections(minConnections);
        Futures.addCallback(broadcast.future(), (FutureCallback)new FutureCallback<Transaction>(){

            public void onSuccess(Transaction transaction) {
                PeerGroup.this.runningBroadcasts.remove(broadcast);
                for (Wallet wallet : PeerGroup.this.wallets) {
                    try {
                        wallet.receivePending(transaction, null);
                    }
                    catch (VerificationException e) {
                        throw new RuntimeException(e);
                    }
                }
            }

            public void onFailure(Throwable throwable) {
                PeerGroup.this.runningBroadcasts.remove(broadcast);
            }
        });
        this.runningBroadcasts.add(broadcast);
        broadcast.broadcast();
        return broadcast;
    }

    public long getPingIntervalMsec() {
        this.lock.lock();
        try {
            long l = this.pingIntervalMsec;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPingIntervalMsec(long pingIntervalMsec) {
        this.lock.lock();
        try {
            this.pingIntervalMsec = pingIntervalMsec;
            ListenableScheduledFuture<?> task = this.vPingTask;
            if (task != null) {
                task.cancel(false);
            }
            this.setupPinging();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setMinRequiredProtocolVersion(int minRequiredProtocolVersion) {
        this.vMinRequiredProtocolVersion = minRequiredProtocolVersion;
    }

    public int getMinRequiredProtocolVersion() {
        return this.vMinRequiredProtocolVersion;
    }

    public int getMostCommonChainHeight() {
        this.lock.lock();
        try {
            int n = PeerGroup.getMostCommonChainHeight(this.peers);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static int getMostCommonChainHeight(List<Peer> peers) {
        if (peers.isEmpty()) {
            return 0;
        }
        ArrayList<Integer> heights = new ArrayList<Integer>(peers.size());
        for (Peer peer : peers) {
            heights.add((int)peer.getBestHeight());
        }
        return Utils.maxOfMostFreq(heights);
    }

    @Nullable
    protected Peer selectDownloadPeer(List<Peer> peers) {
        if (peers.isEmpty()) {
            return null;
        }
        int mostCommonChainHeight = PeerGroup.getMostCommonChainHeight(peers);
        ArrayList<Peer> candidates = new ArrayList<Peer>();
        for (Peer peer : peers) {
            if (peer.getBestHeight() != (long)mostCommonChainHeight) continue;
            candidates.add(peer);
        }
        int highestVersion = 0;
        int preferredVersion = 0;
        int PREFERRED_VERSION = 70000;
        for (Peer peer : candidates) {
            highestVersion = Math.max(peer.getPeerVersionMessage().clientVersion, highestVersion);
            preferredVersion = Math.min(highestVersion, 70000);
        }
        ArrayList<Peer> candidates2 = new ArrayList<Peer>(candidates.size());
        for (Peer peer : candidates) {
            if (peer.getPeerVersionMessage().clientVersion < preferredVersion) continue;
            candidates2.add(peer);
        }
        int n = (int)(Math.random() * (double)candidates2.size());
        return (Peer)candidates2.get(n);
    }

    public Peer getDownloadPeer() {
        this.lock.lock();
        try {
            Peer peer = this.downloadPeer;
            return peer;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Nullable
    public TorClient getTorClient() {
        return this.torClient;
    }

    public int getMaxPeersToDiscoverCount() {
        return this.vMaxPeersToDiscoverCount;
    }

    public void setMaxPeersToDiscoverCount(int maxPeersToDiscoverCount) {
        this.vMaxPeersToDiscoverCount = maxPeersToDiscoverCount;
    }

    public boolean getUseLocalhostPeerWhenPossible() {
        this.lock.lock();
        try {
            boolean bl = this.useLocalhostPeerWhenPossible;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setUseLocalhostPeerWhenPossible(boolean useLocalhostPeerWhenPossible) {
        this.lock.lock();
        try {
            this.useLocalhostPeerWhenPossible = useLocalhostPeerWhenPossible;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isRunning() {
        return this.vRunning;
    }

    public void setBloomFilteringEnabled(boolean bloomFilteringEnabled) {
        this.vBloomFilteringEnabled = bloomFilteringEnabled;
    }

    public boolean isBloomFilteringEnabled() {
        return this.vBloomFilteringEnabled;
    }

    private class ChainDownloadSpeedCalculator
    extends AbstractPeerEventListener
    implements Runnable {
        private int blocksInLastSecond;
        private int txnsInLastSecond;
        private int origTxnsInLastSecond;
        private long bytesInLastSecond;
        private int maxStalls = 3;
        private int warmupSeconds = -1;
        private long[] samples;
        private int cursor;
        private boolean syncDone;

        private ChainDownloadSpeedCalculator() {
        }

        @Override
        public synchronized void onBlocksDownloaded(Peer peer, Block block, @Nullable FilteredBlock filteredBlock, int blocksLeft) {
            ++this.blocksInLastSecond;
            this.bytesInLastSecond += 80L;
            List<Transaction> blockTransactions = block.getTransactions();
            int txCount = (blockTransactions != null ? this.countAndMeasureSize(blockTransactions) : 0) + (filteredBlock != null ? this.countAndMeasureSize(filteredBlock.getAssociatedTransactions().values()) : 0);
            this.txnsInLastSecond += txCount;
            if (filteredBlock != null) {
                this.origTxnsInLastSecond += filteredBlock.getTransactionCount();
            }
        }

        private int countAndMeasureSize(Collection<Transaction> transactions) {
            for (Transaction transaction : transactions) {
                this.bytesInLastSecond += (long)transaction.getMessageSize();
            }
            return transactions.size();
        }

        @Override
        public void run() {
            try {
                this.calculate();
            }
            catch (Throwable e) {
                log.error("Error in speed calculator", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void calculate() {
            int period;
            int minSpeedBytesPerSec;
            PeerGroup.this.lock.lock();
            try {
                minSpeedBytesPerSec = PeerGroup.this.stallMinSpeedBytesSec;
                period = PeerGroup.this.stallPeriodSeconds;
            }
            finally {
                PeerGroup.this.lock.unlock();
            }
            ChainDownloadSpeedCalculator chainDownloadSpeedCalculator = this;
            synchronized (chainDownloadSpeedCalculator) {
                boolean behindPeers;
                if (this.samples == null || this.samples.length != period) {
                    this.samples = new long[period];
                    Arrays.fill(this.samples, (long)(minSpeedBytesPerSec * 2));
                    this.warmupSeconds = 15;
                }
                boolean bl = behindPeers = PeerGroup.this.chain != null && PeerGroup.this.chain.getBestChainHeight() < PeerGroup.this.getMostCommonChainHeight();
                if (!behindPeers) {
                    this.syncDone = true;
                }
                if (!this.syncDone) {
                    if (this.warmupSeconds < 0) {
                        this.samples[this.cursor++] = this.bytesInLastSecond;
                        if (this.cursor == this.samples.length) {
                            this.cursor = 0;
                        }
                        long average = 0L;
                        for (long sample : this.samples) {
                            average += sample;
                        }
                        log.info(String.format("%d blocks/sec, %d tx/sec, %d pre-filtered tx/sec, avg/last %.2f/%.2f kilobytes per sec (stall threshold <%.2f KB/sec for %d seconds)", this.blocksInLastSecond, this.txnsInLastSecond, this.origTxnsInLastSecond, (double)(average /= (long)this.samples.length) / 1024.0, (double)this.bytesInLastSecond / 1024.0, (double)minSpeedBytesPerSec / 1024.0, this.samples.length));
                        if (average < (long)minSpeedBytesPerSec && this.maxStalls > 0) {
                            --this.maxStalls;
                            if (this.maxStalls == 0) {
                                log.warn("This network seems to be slower than the requested stall threshold - won't do stall disconnects any more.");
                            } else {
                                Peer peer = PeerGroup.this.getDownloadPeer();
                                log.warn(String.format("Chain download stalled: received %.2f KB/sec for %d seconds, require average of %.2f KB/sec, disconnecting %s", (double)average / 1024.0, this.samples.length, (double)minSpeedBytesPerSec / 1024.0, peer));
                                peer.close();
                                this.samples = null;
                                this.warmupSeconds = period;
                            }
                        }
                    } else {
                        --this.warmupSeconds;
                        if (this.bytesInLastSecond > 0L) {
                            log.info(String.format("%d blocks/sec, %d tx/sec, %d pre-filtered tx/sec, last %.2f kilobytes per sec", this.blocksInLastSecond, this.txnsInLastSecond, this.origTxnsInLastSecond, (double)this.bytesInLastSecond / 1024.0));
                        }
                    }
                }
                this.blocksInLastSecond = 0;
                this.txnsInLastSecond = 0;
                this.origTxnsInLastSecond = 0;
                this.bytesInLastSecond = 0L;
            }
        }
    }

    public static enum FilterRecalculateMode {
        SEND_IF_CHANGED,
        FORCE_SEND_FOR_REFRESH,
        DONT_SEND;

    }

    private static enum LocalhostCheckState {
        NOT_TRIED,
        FOUND,
        FOUND_AND_CONNECTED,
        NOT_THERE;

    }

    private class PeerStartupListener
    extends AbstractPeerEventListener {
        private PeerStartupListener() {
        }

        @Override
        public void onPeerConnected(Peer peer, int peerCount) {
            PeerGroup.this.handleNewPeer(peer);
        }

        @Override
        public void onPeerDisconnected(Peer peer, int peerCount) {
            PeerGroup.this.handlePeerDeath(peer, null);
        }
    }
}

