package org.bitbucket.bradleysmithllc.etlunit.feature.postgresql_database;

import org.bitbucket.bradleysmithllc.etlunit.feature.database.BaseDatabaseImplemenation;
import org.bitbucket.bradleysmithllc.etlunit.feature.database.DatabaseConnection;
import org.bitbucket.bradleysmithllc.etlunit.parser.ETLTestValueObject;
import org.postgresql.Driver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;

public class PostgreSQLDatabaseImplementation extends BaseDatabaseImplemenation
{
	public database_state getDatabaseState(DatabaseConnection databaseConnection, String s)
	{
		return database_state.fail;
	}

	public String getImplementationId()
	{
		return "postgresql";
	}

	public Object processOperationSub(operation op, OperationRequest request) throws UnsupportedOperationException
	{
		return null;
	}

	@Override
	public String getJdbcUrl(DatabaseConnection dc, String mode, int id)
	{
		return "jdbc:postgresql:/" + dc.getServerName() + "/" + dc.getDatabaseName(mode);
	}

	@Override
	public Class getJdbcDriverClass()
	{
		return Driver.class;
	}

	public String getDefaultSchema(DatabaseConnection databaseConnection, String mode)
	{
		return "PUBLIC";
	}
}
