package org.bitbucket.bradleysmithllc.etlunit.feature.postgresql_database;

import com.google.inject.Injector;
import org.bitbucket.bradleysmithllc.etlunit.feature.FeatureModule;
import org.bitbucket.bradleysmithllc.etlunit.feature.AbstractFeature;
import org.bitbucket.bradleysmithllc.etlunit.feature.database.DatabaseFeatureModule;

import javax.inject.Inject;
import java.util.Arrays;
import java.util.List;

@FeatureModule
public class PostgreSQLDatabaseFeatureModule extends AbstractFeature {
	private DatabaseFeatureModule databaseFeatureModule;
	private PostgreSQLDatabaseImplementation postgreSQLDatabaseImplementation;

	private static final List<String> prerequisites = Arrays.asList("database");

	@Inject
	public void setDatabaseFeatureModule(DatabaseFeatureModule module)
	{
		databaseFeatureModule = module;
	}

	@Override
	public void dispose()
	{
		postgreSQLDatabaseImplementation.dispose();
	}

	@Override
	public List<String> getPrerequisites() {
		return prerequisites;
	}

	@Override
	public void initialize(Injector inj)
	{
		postgreSQLDatabaseImplementation = postCreate(new PostgreSQLDatabaseImplementation());
		databaseFeatureModule.addDatabaseImplementation(postgreSQLDatabaseImplementation);
	}
}