/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.statement;

import java.util.HashMap;
import java.util.Map;
import org.beetl.core.Context;
import org.beetl.core.InferContext;
import org.beetl.core.statement.Expression;
import org.beetl.core.statement.GrammarToken;
import org.beetl.core.statement.Type;

public class JsonMapExpression
extends Expression {
    Map<String, Expression> map;
    public Expression[] array;

    public JsonMapExpression(Map<String, Expression> map, GrammarToken token) {
        super(token);
        this.map = map;
        this.array = map.values().toArray(new Expression[0]);
    }

    @Override
    public Object evaluate(Context ctx) {
        if (this.map.size() == 0) {
            return new HashMap();
        }
        HashMap<String, Object> values = new HashMap<String, Object>(this.map.size());
        for (Map.Entry<String, Expression> entry : this.map.entrySet()) {
            values.put(entry.getKey(), entry.getValue().evaluate(ctx));
        }
        return values;
    }

    @Override
    public void infer(InferContext inferCtx) {
        for (Expression exp : this.array) {
            exp.infer(inferCtx);
        }
        this.type = Type.MapType;
    }
}

