/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.misc;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class ClassSearch {
    Set<String> pkgList;
    Map<String, Class> map = new ConcurrentHashMap<String, Class>();

    public ClassSearch(Set<String> pkgList) {
        this.pkgList = pkgList;
    }

    public Class getClassByName(String name) {
        if (name.indexOf(".") != -1) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        Class<?> cls = this.map.get(name);
        if (cls == null) {
            for (String pkg : this.pkgList) {
                try {
                    String clsName = pkg.concat(name);
                    cls = Class.forName(clsName);
                    this.map.put(name, cls);
                    return cls;
                }
                catch (Exception ex) {
                }
            }
            return null;
        }
        return cls;
    }
}

