/*
 * Decompiled with CFR 0.152.
 */
package org.beetl.core.misc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.beetl.core.ByteWriter;
import org.beetl.core.io.ByteWriter_Byte;
import org.beetl.core.io.ByteWriter_Char;

public class BeetlUtil {
    static char[] commonArray = new char[12];
    static byte[] chars = new byte[]{36, 0, 0, 0, 0, 0, 0, 0, 0, 0, 46, 0, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 0, 0, 0, 0, 0, 0, 0, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 0, 0, 0, 0, 95, 0, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
    static int[] checkReult = new int[2];
    static List<String> chineseTokens = new ArrayList<String>();
    static List<String> englishTokens = new ArrayList<String>();

    public static boolean isOutsideOfRoot(String child) {
        if (child == null) {
            return true;
        }
        char[] array = child.toCharArray();
        int root = 0;
        if (array.length == 0) {
            return true;
        }
        int start = 0;
        if (array[0] == '/' || array[0] == '\\') {
            start = 1;
        }
        StringBuilder dir = new StringBuilder();
        for (int i = start; i < array.length; ++i) {
            char c = array[i];
            if (c == '/' || c == '\\') {
                if (dir.toString().equals("..")) {
                    if (++root == 1) {
                        return true;
                    }
                } else {
                    if (dir.length() == 0) {
                        return true;
                    }
                    --root;
                }
                dir.setLength(0);
                continue;
            }
            dir.append(c);
        }
        return root > 0;
    }

    public static String getRelPath(String siblings, String resourceId) {
        String relResourceId = null;
        if (resourceId != null && resourceId.length() != 0) {
            char cs = resourceId.charAt(0);
            if (cs != '\\' && cs != '/') {
                int i;
                boolean find = false;
                for (i = siblings.length() - 1; i > 0; --i) {
                    char c = siblings.charAt(i);
                    if (c != '\\' && c != '/') continue;
                    find = true;
                    break;
                }
                if (find) {
                    String parent = siblings.substring(0, i + 1);
                    relResourceId = parent.concat(resourceId);
                } else {
                    relResourceId = resourceId;
                }
            } else {
                relResourceId = resourceId;
            }
            if (BeetlUtil.isOutsideOfRoot(relResourceId)) {
                throw new RuntimeException("\u4e0d\u80fd\u8bbf\u95ee\u5916\u90e8\u6587\u4ef6\u6216\u8005\u6a21\u677f");
            }
            return relResourceId;
        }
        throw new RuntimeException("\u8d44\u6e90ID\u4e3a\u7a7a\uff0c\u53c2\u6570\u9519");
    }

    public static Writer getWriterByByteWriter(ByteWriter byteWriter) {
        Writer w = null;
        if (byteWriter instanceof ByteWriter_Char) {
            ByteWriter_Char bw = (ByteWriter_Char)byteWriter;
            w = bw.getW();
        } else {
            ByteWriter_Byte bw = (ByteWriter_Byte)byteWriter;
            try {
                w = new OutputStreamWriter(bw.getOs(), bw.getCs());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return w;
    }

    public static String getWebRoot() {
        try {
            String path = BeetlUtil.class.getClassLoader().getResource("").toURI().getPath();
            if (path == null) {
                throw new NullPointerException("Beetl\u672a\u80fd\u81ea\u52a8\u68c0\u6d4b\u5230WebRoot\uff0c\u8bf7\u624b\u5de5\u6307\u5b9aWebRoot\u8def\u5f84");
            }
            String root = new File(path).getParentFile().getParentFile().getCanonicalPath();
            return root;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean checkNameing(String str) {
        int len = 0;
        if (str == null || (len = str.length()) == 0) {
            return false;
        }
        if (len > commonArray.length) {
            commonArray = new char[len];
        }
        str.getChars(0, len, commonArray, 0);
        int index = 0;
        char word = commonArray[index++];
        if (word >= '.' && word <= '9') {
            BeetlUtil.setLog(1, word);
        } else if (commonArray[len - 1] == '.') {
            BeetlUtil.setLog(len, 46);
        } else {
            while (true) {
                if (word < '$' || word > 'z' || chars[word - 36] == 0) {
                    BeetlUtil.setLog(index + 1, word);
                    return false;
                }
                if (index == len) {
                    return true;
                }
                word = commonArray[index++];
            }
        }
        return false;
    }

    private static void setLog(int index, int errorChar) {
        BeetlUtil.checkReult[0] = index;
        BeetlUtil.checkReult[1] = errorChar;
    }

    public static int[] getLog() {
        return checkReult;
    }

    public static String reportChineseTokenError(String msg) {
        if (chineseTokens.contains(msg)) {
            return msg + " \u8c8c\u4f3c\u8f93\u5165\u4e86\u4e2d\u6587\u7b26\u53f7,\u5e94\u8be5\u662f " + englishTokens.get(chineseTokens.indexOf(msg));
        }
        return msg;
    }

    static {
        chineseTokens.add("\uff0c");
        englishTokens.add(",");
        chineseTokens.add("\uff1b");
        englishTokens.add(";");
        chineseTokens.add("\uff09");
        englishTokens.add(")");
        chineseTokens.add("\uff08");
        englishTokens.add("(");
        chineseTokens.add("\u2018");
        englishTokens.add("'");
        chineseTokens.add("\u201c");
        englishTokens.add("\"");
        chineseTokens.add("\u3002");
        englishTokens.add(".");
        chineseTokens.add("\uff5d");
        englishTokens.add("}");
        chineseTokens.add("\uff5b");
        englishTokens.add("{");
        chineseTokens.add("\uff1d");
        englishTokens.add("=");
        chineseTokens.add("\uff01");
        englishTokens.add("!");
        chineseTokens.add("\uff05");
        englishTokens.add("%");
        chineseTokens.add("\uff0f");
        englishTokens.add("/");
        chineseTokens.add("\uff3c");
        englishTokens.add("\\");
        chineseTokens.add("\uff0e");
        englishTokens.add(".");
    }
}

