/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.hibernate.h2;

import org.apache.log4j.Logger;
import org.bedework.util.hibernate.h2.H2DbMBean;
import org.h2.tools.Server;

public class H2Db
implements H2DbMBean {
    private transient Logger log;
    private boolean running;
    protected String account = "sa";
    protected String pw = "";
    protected String dbName;
    protected int port = 9092;
    protected boolean trace;
    protected Server server;

    @Override
    public String getName() {
        return "org.bedework:service=H2Db";
    }

    @Override
    public void setAccount(String val) {
        this.account = val;
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    @Override
    public void setPw(String val) {
        this.pw = val;
    }

    @Override
    public String getPw() {
        return this.pw;
    }

    @Override
    public void setTrace(boolean val) {
        this.trace = val;
    }

    @Override
    public boolean getTrace() {
        return this.trace;
    }

    @Override
    public void setDbName(String val) {
        this.dbName = val;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public void setPort(int val) {
        this.port = val;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            this.error("Already started");
            return;
        }
        this.info("************************************************************");
        this.info(" * Starting " + this.getName());
        this.info("************************************************************");
        try {
            String[] args = this.trace ? new String[5] : new String[]{"-tcpPort", String.valueOf(this.port), "-tcpPassword", "stopthis"};
            if (this.trace) {
                args[4] = "-trace";
            }
            this.server = Server.createTcpServer((String[])args).start();
        }
        catch (Throwable t) {
            this.error("Error starting server");
            this.error(t);
        }
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            this.error("Already stopped");
            return;
        }
        this.info("************************************************************");
        this.info(" * Stopping " + this.getName());
        this.info("************************************************************");
        try {
            this.server.stop();
        }
        catch (Throwable t) {
            this.error("Error shutting down server");
            this.error(t);
        }
        this.running = false;
        this.info("************************************************************");
        this.info(" * " + this.getName() + " terminated");
        this.info("************************************************************");
    }

    protected void info(String msg) {
        this.getLogger().info((Object)msg);
    }

    protected void trace(String msg) {
        this.getLogger().debug((Object)msg);
    }

    protected void warn(String msg) {
        this.getLogger().warn((Object)msg);
    }

    protected void error(Throwable t) {
        this.getLogger().error((Object)t);
    }

    protected void error(String msg) {
        this.getLogger().error((Object)msg);
    }

    protected Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }
}

