/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.hibernate.derby;

import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.log4j.Logger;
import org.bedework.util.hibernate.derby.DerbyDbMBean;

public class DerbyDb
implements DerbyDbMBean {
    private transient Logger log;
    private boolean running;
    protected String account = "sa";
    protected String pw = "";
    protected String dbName;
    protected int port = 1527;
    protected int maxThreads;
    protected int minThreads;

    @Override
    public String getName() {
        return "org.bedework:service=DerbyDb";
    }

    @Override
    public void setAccount(String val) {
        this.account = val;
    }

    @Override
    public String getAccount() {
        return this.account;
    }

    @Override
    public void setPw(String val) {
        this.pw = val;
    }

    @Override
    public String getPw() {
        return this.pw;
    }

    @Override
    public void setDbName(String val) {
        this.dbName = val;
    }

    @Override
    public String getDbName() {
        return this.dbName;
    }

    @Override
    public void setPort(int val) {
        this.port = val;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public boolean isStarted() {
        return this.running;
    }

    @Override
    public synchronized void start() {
        if (this.running) {
            this.error("Already started");
            return;
        }
        this.info("************************************************************");
        this.info(" * Starting " + this.getName());
        this.info("************************************************************");
        try {
            InetAddress addr = InetAddress.getByName("localhost");
            NetworkServerControl server = new NetworkServerControl(addr, this.port, this.account, this.pw);
            server.start(null);
        }
        catch (Throwable t) {
            this.error("Error starting server");
            this.error(t);
        }
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            this.error("Already stopped");
            return;
        }
        this.info("************************************************************");
        this.info(" * Stopping " + this.getName());
        this.info("************************************************************");
        try {
            NetworkServerControl server = new NetworkServerControl(this.account, this.pw);
            server.shutdown();
        }
        catch (Throwable t) {
            this.error("Error shutting down server");
            this.error(t);
        }
        this.running = false;
        this.info("************************************************************");
        this.info(" * " + this.getName() + " terminated");
        this.info("************************************************************");
    }

    protected void info(String msg) {
        this.getLogger().info((Object)msg);
    }

    protected void trace(String msg) {
        this.getLogger().debug((Object)msg);
    }

    protected void warn(String msg) {
        this.getLogger().warn((Object)msg);
    }

    protected void error(Throwable t) {
        this.getLogger().error((Object)t);
    }

    protected void error(String msg) {
        this.getLogger().error((Object)msg);
    }

    protected Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }
}

