/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.hibernate;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.EnumSet;
import java.util.Map;
import java.util.Properties;
import org.bedework.util.jmx.InfoLines;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.BootstrapServiceRegistry;
import org.hibernate.boot.registry.BootstrapServiceRegistryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.boot.spi.MetadataImplementor;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.schema.TargetType;

public class Schema {
    private Schema() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(InfoLines infoLines, String outFile, boolean export, Properties hibConfig) {
        try {
            infoLines.addLn("Started export of schema");
            long startTime = System.currentTimeMillis();
            SchemaExport se = new SchemaExport();
            se.setFormat(true);
            se.setHaltOnError(false);
            se.setOutputFile(outFile);
            EnumSet<TargetType> targets = EnumSet.noneOf(TargetType.class);
            if (export) {
                targets.add(TargetType.DATABASE);
            } else {
                targets.add(TargetType.SCRIPT);
            }
            BootstrapServiceRegistry bsr = new BootstrapServiceRegistryBuilder().build();
            StandardServiceRegistryBuilder ssrBuilder = new StandardServiceRegistryBuilder(bsr);
            ssrBuilder.configure();
            ssrBuilder.applySettings((Map)hibConfig);
            StandardServiceRegistry ssr = ssrBuilder.build();
            se.execute(targets, SchemaExport.Action.BOTH, (Metadata)Schema.buildMetadata(ssr), (ServiceRegistry)ssr);
            long millis = System.currentTimeMillis() - startTime;
            long seconds = millis / 1000L;
            long minutes = seconds / 60L;
            infoLines.addLn("Elapsed time: " + minutes + ":" + Schema.twoDigits(seconds -= minutes * 60L));
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            infoLines.add((Object)sw.toString());
            boolean bl = false;
            return bl;
        }
        finally {
            infoLines.addLn("Schema build completed");
        }
    }

    private static MetadataImplementor buildMetadata(StandardServiceRegistry serviceRegistry) throws Exception {
        MetadataSources metadataSources = new MetadataSources((ServiceRegistry)serviceRegistry);
        MetadataBuilder metadataBuilder = metadataSources.getMetadataBuilder();
        return (MetadataImplementor)metadataBuilder.build();
    }

    private static String twoDigits(long val) {
        if (val < 10L) {
            return "0" + val;
        }
        return String.valueOf(val);
    }
}

