/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.hibernate;

import java.io.Serializable;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.bedework.util.hibernate.DbStaleStateException;
import org.bedework.util.hibernate.HibException;
import org.bedework.util.hibernate.HibSession;
import org.bedework.util.hibernate.UnversionedDbentity;
import org.bedework.util.hibernate.VersionedDbEntity;
import org.hibernate.Criteria;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.ReplicationMode;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;

public class HibSessionImpl
implements HibSession {
    transient Logger log;
    Session sess;
    transient Transaction tx;
    boolean rolledBack;
    transient Query q;
    transient Criteria crit;
    Throwable exc;
    private SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public void init(SessionFactory sessFactory, Logger log) throws HibException {
        try {
            this.log = log;
            this.sess = sessFactory.openSession();
            this.rolledBack = false;
        }
        catch (Throwable t) {
            this.exc = t;
            this.tx = null;
            this.close();
        }
    }

    @Override
    public Session getSession() throws HibException {
        return this.sess;
    }

    @Override
    public boolean isOpen() throws HibException {
        try {
            if (this.sess == null) {
                return false;
            }
            return this.sess.isOpen();
        }
        catch (Throwable t) {
            this.handleException(t);
            return false;
        }
    }

    @Override
    public void clear() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.sess.clear();
            this.tx = null;
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void disconnect() throws HibException {
        if (this.exc != null) {
            if (this.exc instanceof HibException) {
                throw (HibException)this.exc;
            }
            throw new HibException(this.exc);
        }
        try {
            this.sess.disconnect();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setFlushMode(FlushMode val) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            if (this.tx != null) {
                throw new HibException("Transaction already started");
            }
            this.sess.setFlushMode(val);
        }
        catch (Throwable t) {
            this.exc = t;
            throw new HibException(t);
        }
    }

    @Override
    public void beginTransaction() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            if (this.tx != null) {
                throw new HibException("Transaction already started");
            }
            this.tx = this.sess.beginTransaction();
            this.rolledBack = false;
            if (this.tx == null) {
                throw new HibException("Transaction not started");
            }
        }
        catch (HibException cfe) {
            this.exc = cfe;
            throw cfe;
        }
        catch (Throwable t) {
            this.exc = t;
            throw new HibException(t);
        }
    }

    @Override
    public boolean transactionStarted() {
        return this.tx != null;
    }

    @Override
    public void commit() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            if (this.tx != null) {
                this.tx.commit();
            }
            this.tx = null;
        }
        catch (Throwable t) {
            this.exc = t;
            if (t instanceof StaleStateException) {
                throw new DbStaleStateException(t.getMessage());
            }
            throw new HibException(t);
        }
    }

    @Override
    public void rollback() throws HibException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"Enter rollback");
        }
        try {
            if (this.tx != null && !this.rolledBack) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"About to rollback");
                }
                this.tx.rollback();
                this.clear();
            }
        }
        catch (Throwable t) {
            this.exc = t;
            throw new HibException(t);
        }
        finally {
            this.rolledBack = true;
        }
    }

    @Override
    public boolean rolledback() throws HibException {
        return this.rolledBack;
    }

    public Criteria createCriteria(Class cl) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.crit = this.sess.createCriteria(cl);
            this.q = null;
            return this.crit;
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    @Override
    public void evict(Object val) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.sess.evict(val);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void createQuery(String s) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q = this.sess.createQuery(s);
            this.crit = null;
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void createNoFlushQuery(String s) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q = this.sess.createQuery(s);
            this.crit = null;
            this.q.setFlushMode(FlushMode.COMMIT);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public String getQueryString() throws HibException {
        if (this.q == null) {
            return "*** no query ***";
        }
        try {
            return this.q.getQueryString();
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    public void createSQLQuery(String s, String returnAlias, Class returnClass) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            NativeQuery sq = this.sess.createSQLQuery(s);
            sq.addEntity(returnAlias, returnClass);
            this.q = sq;
            this.crit = null;
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void namedQuery(String name) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q = this.sess.getNamedQuery(name);
            this.crit = null;
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void cacheableQuery() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setCacheable(true);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setString(String parName, String parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setString(parName, parVal);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(String parName, java.util.Date parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            SimpleDateFormat simpleDateFormat = this.dateFormatter;
            synchronized (simpleDateFormat) {
                this.q.setDate(parName, (java.util.Date)Date.valueOf(this.dateFormatter.format(parVal)));
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setBool(String parName, boolean parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setBoolean(parName, parVal);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setInt(String parName, int parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setInteger(parName, parVal);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setLong(String parName, long parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setLong(parName, parVal);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setEntity(String parName, Object parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setEntity(parName, parVal);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setParameter(String parName, Object parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setParameter(parName, parVal);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    public void setParameterList(String parName, Collection parVal) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setParameterList(parName, parVal);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setFirstResult(int val) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setFirstResult(val);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void setMaxResults(int val) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.q.setMaxResults(val);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public Object getUnique() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            if (this.q != null) {
                return this.q.uniqueResult();
            }
            return this.crit.uniqueResult();
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    @Override
    public List getList() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            List l = this.q != null ? this.q.list() : this.crit.list();
            if (l == null) {
                return new ArrayList();
            }
            return l;
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    @Override
    public int executeUpdate() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            if (this.q == null) {
                throw new HibException("No query for execute update");
            }
            return this.q.executeUpdate();
        }
        catch (Throwable t) {
            this.handleException(t);
            return 0;
        }
    }

    @Override
    public void update(Object obj) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.beforeSave(obj);
            this.sess.update(obj);
            this.deleteSubs(obj);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public Object merge(Object obj) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.beforeSave(obj);
            obj = this.sess.merge(obj);
            this.deleteSubs(obj);
            return obj;
        }
        catch (Throwable t) {
            this.handleException(t, obj);
            return null;
        }
    }

    @Override
    public void saveOrUpdate(Object obj) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.beforeSave(obj);
            this.sess.saveOrUpdate(obj);
            this.deleteSubs(obj);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public Object saveOrUpdateCopy(Object obj) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            return this.sess.merge(obj);
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    @Override
    public Object get(Class cl, Serializable id) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            return this.sess.get(cl, id);
        }
        catch (Throwable t) {
            this.handleException(t);
            return null;
        }
    }

    @Override
    public Object get(Class cl, int id) throws HibException {
        return this.get(cl, new Integer(id));
    }

    @Override
    public void save(Object obj) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.beforeSave(obj);
            this.sess.save(obj);
            this.deleteSubs(obj);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void delete(Object obj) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.beforeDelete(obj);
            this.sess.delete(obj);
            this.deleteSubs(obj);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void restore(Object obj) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.sess.replicate(obj, ReplicationMode.IGNORE);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void reAttach(UnversionedDbentity<?, ?> val) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            if (!val.unsaved()) {
                this.sess.lock(val, LockMode.NONE);
            }
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void lockRead(Object o) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.sess.lock(o, LockMode.READ);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void lockUpdate(Object o) throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        try {
            this.sess.lock(o, LockMode.UPGRADE);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void flush() throws HibException {
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"About to flush");
        }
        try {
            this.sess.flush();
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @Override
    public void close() throws HibException {
        if (this.sess == null) {
            return;
        }
        try {
            if (this.sess.isDirty()) {
                this.sess.flush();
            }
            if (this.tx != null && !this.rolledback()) {
                this.tx.commit();
            }
        }
        catch (Throwable t) {
            if (this.exc == null) {
                this.exc = t;
            }
        }
        finally {
            this.tx = null;
            if (this.sess != null) {
                try {
                    this.sess.close();
                }
                catch (Throwable throwable) {}
            }
        }
        this.sess = null;
        if (this.exc != null) {
            throw new HibException(this.exc);
        }
    }

    private void handleException(Throwable t) throws HibException {
        this.handleException(t, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleException(Throwable t, Object o) throws HibException {
        block14: {
            try {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)"handleException called");
                    if (o != null) {
                        this.getLogger().debug((Object)o.toString());
                    }
                    this.getLogger().error((Object)this, t);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.tx == null) break block14;
                try {
                    this.tx.rollback();
                }
                catch (Throwable t1) {
                    this.rollbackException(t1);
                }
                this.tx = null;
            }
            finally {
                try {
                    this.sess.close();
                }
                catch (Throwable throwable) {}
                this.sess = null;
            }
        }
        this.exc = t;
        if (t instanceof StaleStateException) {
            throw new DbStaleStateException(t.getMessage());
        }
        throw new HibException(t);
    }

    private void beforeSave(Object o) throws HibException {
        if (!(o instanceof VersionedDbEntity)) {
            return;
        }
        VersionedDbEntity ent = (VersionedDbEntity)o;
        ent.beforeSave();
    }

    private void beforeDelete(Object o) throws HibException {
        if (!(o instanceof VersionedDbEntity)) {
            return;
        }
        VersionedDbEntity ent = (VersionedDbEntity)o;
        ent.beforeDeletion();
    }

    private void deleteSubs(Object o) throws HibException {
        if (!(o instanceof VersionedDbEntity)) {
            return;
        }
        VersionedDbEntity ent = (VersionedDbEntity)o;
        Collection<VersionedDbEntity<?, ?>> subs = ent.getDeletedEntities();
        if (subs == null) {
            return;
        }
        for (VersionedDbEntity<?, ?> sub : subs) {
            this.delete(sub);
        }
    }

    private void rollbackException(Throwable t) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)"HibSession: ", t);
        }
        this.getLogger().error((Object)this, t);
    }

    protected Logger getLogger() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }
}

