/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.hibernate;

import java.io.StringReader;
import java.util.List;
import java.util.Properties;
import org.bedework.util.hibernate.HibException;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibSessionFactory {
    private static SessionFactory sessionFactory;
    private static volatile Object lock;

    public static SessionFactory getSessionFactory(List<String> hibProps) throws HibException {
        if (sessionFactory != null) {
            return sessionFactory;
        }
        Object object = lock;
        synchronized (object) {
            if (sessionFactory != null) {
                return sessionFactory;
            }
            try {
                Configuration conf = new Configuration();
                if (hibProps != null) {
                    StringBuilder sb = new StringBuilder();
                    for (String p : hibProps) {
                        sb.append(p);
                        sb.append("\n");
                    }
                    Properties hprops = new Properties();
                    hprops.load(new StringReader(sb.toString()));
                    conf.addProperties(hprops);
                }
                conf.configure();
                sessionFactory = conf.buildSessionFactory();
                return sessionFactory;
            }
            catch (Throwable t) {
                throw new HibException(t);
            }
        }
    }

    static {
        lock = new Object();
    }
}

