/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.util.hibernate;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.bedework.util.hibernate.Dump;
import org.bedework.util.hibernate.HibException;
import org.bedework.util.hibernate.NoDump;
import org.bedework.util.hibernate.NoWrap;
import org.bedework.util.xml.XmlEmit;

public class DumpEntity<T> {
    private transient Logger log;

    @NoWrap
    public boolean hasDumpValue() throws HibException {
        return true;
    }

    @NoWrap
    public void dump(XmlEmit xml, DumpType dtype) throws HibException {
        this.dump(xml, dtype, false);
    }

    @NoWrap
    public void dump(XmlEmit xml, DumpType dtype, boolean fromCollection) throws HibException {
        if (!this.hasDumpValue()) {
            return;
        }
        NoDump ndCl = this.getClass().getAnnotation(NoDump.class);
        Dump dCl = this.getClass().getAnnotation(Dump.class);
        boolean dumpKeyFields = dtype == DumpType.reference;
        ArrayList<String> noDumpMethods = null;
        ArrayList<String> firstMethods = null;
        try {
            if (ndCl != null) {
                if (ndCl.value().length == 0) {
                    return;
                }
                noDumpMethods = new ArrayList<String>();
                for (String m : ndCl.value()) {
                    noDumpMethods.add(m);
                }
            }
            if (!dumpKeyFields && dCl != null && dCl.firstFields().length != 0) {
                firstMethods = new ArrayList<String>();
                for (String f : dCl.firstFields()) {
                    firstMethods.add(this.methodName(f));
                }
            }
            QName qn = null;
            if (fromCollection || dtype != DumpType.compound) {
                qn = this.startElement(xml, this.getClass(), dCl);
            }
            Collection<ComparableMethod> ms = this.findGetters(dCl, dtype);
            if (firstMethods != null) {
                block5: for (String methodName : firstMethods) {
                    for (ComparableMethod cm : ms) {
                        Method m = cm.m;
                        if (!methodName.equals(m.getName())) continue;
                        Dump d = m.getAnnotation(Dump.class);
                        this.dumpValue(xml, m, d, m.invoke((Object)this, (Object[])null), fromCollection);
                        continue block5;
                    }
                    this.error("Listed first field has no corresponding getter: " + methodName);
                }
            }
            for (ComparableMethod cm : ms) {
                Method m = cm.m;
                if (noDumpMethods != null && noDumpMethods.contains(this.fieldName(m.getName())) || firstMethods != null && firstMethods.contains(m.getName())) continue;
                Dump d = m.getAnnotation(Dump.class);
                this.dumpValue(xml, m, d, m.invoke((Object)this, (Object[])null), fromCollection);
            }
            if (qn != null) {
                this.closeElement(xml, qn);
            }
        }
        catch (HibException cfe) {
            throw cfe;
        }
        catch (Throwable t) {
            throw new HibException(t);
        }
    }

    private boolean dumpValue(XmlEmit xml, Method m, Dump d, Object methVal, boolean fromCollection) throws Throwable {
        if (methVal instanceof DumpEntity) {
            DumpEntity de = (DumpEntity)methVal;
            if (!de.hasDumpValue()) {
                return false;
            }
            boolean compound = d != null && d.compound();
            QName mqn = this.startElement(xml, m, d, fromCollection);
            DumpType dt = compound ? DumpType.compound : DumpType.reference;
            de.dump(xml, dt);
            if (mqn != null) {
                this.closeElement(xml, mqn);
            }
            return true;
        }
        if (methVal instanceof Collection) {
            Collection c = (Collection)methVal;
            if (c.isEmpty()) {
                return false;
            }
            QName mqn = null;
            for (Object o : c) {
                if (o instanceof DumpEntity && !((DumpEntity)o).hasDumpValue()) continue;
                if (mqn == null) {
                    mqn = this.startElement(xml, m, d, fromCollection);
                }
                this.dumpValue(xml, m, d, o, true);
            }
            if (mqn != null) {
                this.closeElement(xml, mqn);
            }
            return true;
        }
        this.property(xml, m, d, methVal, fromCollection);
        return true;
    }

    private QName startElement(XmlEmit xml, Class c, Dump d) throws HibException {
        try {
            QName qn = d == null ? new QName(c.getName()) : new QName(d.elementName());
            xml.openTag(qn);
            return qn;
        }
        catch (Throwable t) {
            throw new HibException(t);
        }
    }

    private QName startElement(XmlEmit xml, Method m, Dump d, boolean fromCollection) throws HibException {
        try {
            QName qn = this.getTag(m, d, fromCollection);
            if (qn != null) {
                xml.openTag(qn);
            }
            return qn;
        }
        catch (Throwable t) {
            throw new HibException(t);
        }
    }

    private QName getTag(Method m, Dump d, boolean fromCollection) {
        String tagName = null;
        if (d != null) {
            if (!fromCollection) {
                if (d.elementName().length() > 0) {
                    tagName = d.elementName();
                }
            } else if (d.collectionElementName().length() > 0) {
                tagName = d.collectionElementName();
            }
        }
        if (tagName == null && !fromCollection) {
            tagName = this.fieldName(m.getName());
        }
        if (tagName == null) {
            return null;
        }
        return new QName(tagName);
    }

    private void property(XmlEmit xml, Method m, Dump d, Object p, boolean fromCollection) throws HibException {
        if (p == null) {
            return;
        }
        try {
            String sval;
            QName qn = this.getTag(m, d, fromCollection);
            if (qn == null) {
                qn = new QName(p.getClass().getName());
            }
            if ((sval = p instanceof char[] ? new String((char[])p) : String.valueOf(p)).indexOf(38) < 0 && sval.indexOf(60) < 0) {
                xml.property(qn, sval);
            } else {
                xml.cdataProperty(qn, sval);
            }
        }
        catch (Throwable t) {
            throw new HibException(t);
        }
    }

    private void closeElement(XmlEmit xml, QName qn) throws HibException {
        try {
            xml.closeTag(qn);
        }
        catch (Throwable t) {
            throw new HibException(t);
        }
    }

    private Collection<ComparableMethod> findGetters(Dump d, DumpType dt) throws HibException {
        Method[] meths = this.getClass().getMethods();
        TreeSet<ComparableMethod> getters = new TreeSet<ComparableMethod>();
        ArrayList<String> keyMethods = null;
        if (dt == DumpType.reference) {
            if (d == null || d.keyFields().length == 0) {
                this.error("No key fields defined for class " + this.getClass().getCanonicalName());
                throw new HibException("noKeyFields");
            }
            keyMethods = new ArrayList<String>();
            for (String f : d.keyFields()) {
                keyMethods.add(this.methodName(f));
            }
        }
        for (Method m : meths) {
            Class<?>[] parClasses;
            String mname = m.getName();
            if (mname.length() < 4 || !mname.startsWith("get") || mname.equals("getClass") || (parClasses = m.getParameterTypes()).length != 0 || m.getAnnotation(NoDump.class) != null || keyMethods != null && !keyMethods.contains(mname)) continue;
            getters.add(new ComparableMethod(m));
        }
        return getters;
    }

    private String methodName(String val) {
        String m = "get" + val.substring(0, 1).toUpperCase();
        if (val.length() > 1) {
            m = m + val.substring(1);
        }
        return m;
    }

    private String fieldName(String val) {
        if (val.length() < 4) {
            return null;
        }
        return val.substring(3, 4).toLowerCase() + val.substring(4);
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = Logger.getLogger(this.getClass());
        }
        return this.log;
    }

    protected void error(String msg) {
        this.getLog().error((Object)msg);
    }

    private static class ComparableMethod
    implements Comparable<ComparableMethod> {
        Method m;

        ComparableMethod(Method m) {
            this.m = m;
        }

        @Override
        public int compareTo(ComparableMethod that) {
            return this.m.getName().compareTo(that.m.getName());
        }
    }

    public static enum DumpType {
        def,
        compound,
        reference;

    }
}

