/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.test.aggregate;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.axonframework.commandhandling.CommandCallback;
import org.axonframework.commandhandling.CommandMessage;
import org.axonframework.commandhandling.CommandResultMessage;
import org.axonframework.deadline.DeadlineMessage;
import org.axonframework.eventhandling.EventMessage;
import org.axonframework.messaging.HandlerExecutionException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.unitofwork.DefaultUnitOfWork;
import org.axonframework.modelling.command.Aggregate;
import org.axonframework.test.FixtureExecutionException;
import org.axonframework.test.aggregate.Reporter;
import org.axonframework.test.aggregate.ResultValidator;
import org.axonframework.test.deadline.DeadlineManagerValidator;
import org.axonframework.test.deadline.StubDeadlineManager;
import org.axonframework.test.matchers.FieldFilter;
import org.axonframework.test.matchers.MapEntryMatcher;
import org.axonframework.test.matchers.Matchers;
import org.axonframework.test.matchers.PayloadMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;

public class ResultValidatorImpl<T>
implements ResultValidator<T>,
CommandCallback<Object, Object> {
    private final List<EventMessage<?>> publishedEvents;
    private final Reporter reporter = new Reporter();
    private final FieldFilter fieldFilter;
    private final Supplier<Aggregate<T>> state;
    private final DeadlineManagerValidator deadlineManagerValidator;
    private CommandResultMessage<?> actualReturnValue;
    private Throwable actualException;

    public ResultValidatorImpl(List<EventMessage<?>> publishedEvents, FieldFilter fieldFilter, Supplier<Aggregate<T>> aggregateState, StubDeadlineManager stubDeadlineManager) {
        this.publishedEvents = publishedEvents;
        this.fieldFilter = fieldFilter;
        this.state = aggregateState;
        this.deadlineManagerValidator = new DeadlineManagerValidator(stubDeadlineManager, fieldFilter);
    }

    @Override
    public ResultValidator<T> expectEvents(Object ... expectedEvents) {
        if (expectedEvents.length != this.publishedEvents.size()) {
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        Iterator<EventMessage<?>> iterator = this.publishedEvents.iterator();
        for (Object expectedEvent : expectedEvents) {
            EventMessage<?> actualEvent = iterator.next();
            if (this.verifyPayloadEquality(expectedEvent, actualEvent.getPayload())) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectEvents(EventMessage<?> ... expectedEvents) {
        this.expectEvents(Stream.of(expectedEvents).map(Message::getPayload).toArray());
        Iterator<EventMessage<?>> iterator = this.publishedEvents.iterator();
        for (EventMessage<?> expectedEvent : expectedEvents) {
            EventMessage<?> actualEvent = iterator.next();
            if (this.verifyMetaDataEquality(expectedEvent.getPayloadType(), (Map<String, Object>)expectedEvent.getMetaData(), (Map<String, Object>)actualEvent.getMetaData())) continue;
            this.reporter.reportWrongEvent(this.publishedEvents, Arrays.asList(expectedEvents), this.actualException);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectEventsMatching(Matcher<? extends List<? super EventMessage<?>>> matcher) {
        if (!matcher.matches(this.publishedEvents)) {
            this.reporter.reportWrongEvent(this.publishedEvents, this.descriptionOf(matcher), this.actualException);
        }
        return this;
    }

    private StringDescription descriptionOf(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        return description;
    }

    @Override
    public ResultValidator<T> expectSuccessfulHandlerExecution() {
        return this.expectResultMessageMatching(CoreMatchers.anything());
    }

    @Override
    public ResultValidator<T> expectState(Consumer<T> aggregateStateValidator) {
        DefaultUnitOfWork uow = DefaultUnitOfWork.startAndGet(null);
        try {
            this.state.get().execute(aggregateStateValidator);
        }
        finally {
            uow.rollback();
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineMatching(Duration duration, Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertScheduledDeadlineMatching(duration, matcher);
        return this;
    }

    @Override
    public ResultValidator<T> expectScheduledDeadline(Duration duration, Object deadline) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineOfType(Duration duration, Class<?> deadlineType) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineWithName(Duration duration, String deadlineName) {
        return this.expectScheduledDeadlineMatching(duration, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineMatching(Instant scheduledTime, Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertScheduledDeadlineMatching(scheduledTime, matcher);
        return this;
    }

    @Override
    public ResultValidator<T> expectScheduledDeadline(Instant scheduledTime, Object deadline) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineOfType(Instant scheduledTime, Class<?> deadlineType) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public ResultValidator<T> expectScheduledDeadlineWithName(Instant scheduledTime, String deadlineName) {
        return this.expectScheduledDeadlineMatching(scheduledTime, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlines() {
        this.deadlineManagerValidator.assertNoScheduledDeadlines();
        return this;
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineMatching(Matcher<? super DeadlineMessage<?>> matcher) {
        this.deadlineManagerValidator.assertNoScheduledDeadlineMatching(matcher);
        return this;
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineMatching(Duration durationToScheduledTime, Matcher<? super DeadlineMessage<?>> matcher) {
        Instant scheduledTime = this.deadlineManagerValidator.currentDateTime().plus(durationToScheduledTime);
        return this.expectNoScheduledDeadlineMatching(scheduledTime, matcher);
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadline(Duration durationToScheduledTime, Object deadline) {
        return this.expectNoScheduledDeadlineMatching(durationToScheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineOfType(Duration durationToScheduledTime, Class<?> deadlineType) {
        return this.expectNoScheduledDeadlineMatching(durationToScheduledTime, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineWithName(Duration durationToScheduledTime, String deadlineName) {
        return this.expectNoScheduledDeadlineMatching(durationToScheduledTime, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineMatching(Instant scheduledTime, Matcher<? super DeadlineMessage<?>> matcher) {
        return this.expectNoScheduledDeadlineMatching(Matchers.matches(deadlineMessage -> deadlineMessage.getTimestamp().equals(scheduledTime) && matcher.matches(deadlineMessage)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadline(Instant scheduledTime, Object deadline) {
        return this.expectNoScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(Matchers.deepEquals(deadline, this.fieldFilter)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineOfType(Instant scheduledTime, Class<?> deadlineType) {
        return this.expectNoScheduledDeadlineMatching(scheduledTime, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineWithName(Instant scheduledTime, String deadlineName) {
        return this.expectNoScheduledDeadlineMatching(scheduledTime, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineMatching(Instant from, Instant to, Matcher<? super DeadlineMessage<?>> matcher) {
        return this.expectNoScheduledDeadlineMatching(Matchers.matches(deadlineMessage -> !deadlineMessage.getTimestamp().isBefore(from) && !deadlineMessage.getTimestamp().isAfter(to) && matcher.matches(deadlineMessage)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadline(Instant from, Instant to, Object deadline) {
        return this.expectNoScheduledDeadlineMatching(from, to, Matchers.messageWithPayload(Matchers.equalTo(deadline, this.fieldFilter)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineOfType(Instant from, Instant to, Class<?> deadlineType) {
        return this.expectNoScheduledDeadlineMatching(from, to, Matchers.messageWithPayload(CoreMatchers.any(deadlineType)));
    }

    @Override
    public ResultValidator<T> expectNoScheduledDeadlineWithName(Instant from, Instant to, String deadlineName) {
        return this.expectNoScheduledDeadlineMatching(from, to, Matchers.matches(deadlineMessage -> deadlineMessage.getDeadlineName().equals(deadlineName)));
    }

    @Override
    public ResultValidator<T> expectDeadlinesMetMatching(Matcher<? extends List<? super DeadlineMessage<?>>> matcher) {
        return this.expectTriggeredDeadlinesMatching(matcher);
    }

    @Override
    public ResultValidator<T> expectTriggeredDeadlinesMatching(Matcher<? extends List<? super DeadlineMessage<?>>> matcher) {
        this.deadlineManagerValidator.assertTriggeredDeadlinesMatching(matcher);
        return this;
    }

    @Override
    public ResultValidator<T> expectDeadlinesMet(Object ... expected) {
        return this.expectTriggeredDeadlines(expected);
    }

    @Override
    public ResultValidator<T> expectTriggeredDeadlines(Object ... expected) {
        this.deadlineManagerValidator.assertTriggeredDeadlines(expected);
        return this;
    }

    @Override
    public ResultValidator<T> expectTriggeredDeadlinesWithName(String ... expectedDeadlineNames) {
        this.deadlineManagerValidator.assertTriggeredDeadlinesWithName(expectedDeadlineNames);
        return this;
    }

    @Override
    public ResultValidator<T> expectTriggeredDeadlinesOfType(Class<?> ... expectedDeadlineTypes) {
        this.deadlineManagerValidator.assertTriggeredDeadlinesOfType(expectedDeadlineTypes);
        return this;
    }

    @Override
    public ResultValidator<T> expectResultMessagePayload(Object expectedPayload) {
        StringDescription expectedDescription = new StringDescription();
        StringDescription actualDescription = new StringDescription();
        PayloadMatcher expectedMatcher = new PayloadMatcher(CoreMatchers.equalTo((Object)expectedPayload));
        expectedMatcher.describeTo((Description)expectedDescription);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)expectedDescription);
        } else if (!this.verifyPayloadEquality(expectedPayload, this.actualReturnValue.getPayload())) {
            PayloadMatcher actualMatcher = new PayloadMatcher(CoreMatchers.equalTo((Object)this.actualReturnValue.getPayload()));
            actualMatcher.describeTo((Description)actualDescription);
            this.reporter.reportWrongResult(actualDescription, expectedDescription);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectResultMessagePayloadMatching(Matcher<?> matcher) {
        if (matcher == null) {
            return this.expectResultMessagePayloadMatching(CoreMatchers.nullValue());
        }
        StringDescription expectedDescription = new StringDescription();
        matcher.describeTo((Description)expectedDescription);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)expectedDescription);
        } else if (!matcher.matches(this.actualReturnValue.getPayload())) {
            this.reporter.reportWrongResult(this.actualReturnValue.getPayload(), expectedDescription);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectResultMessage(CommandResultMessage<?> expectedResultMessage) {
        this.expectResultMessagePayload(expectedResultMessage.getPayload());
        StringDescription expectedDescription = new StringDescription();
        StringDescription actualDescription = new StringDescription();
        MapEntryMatcher expectedMatcher = new MapEntryMatcher((Map<String, Object>)expectedResultMessage.getMetaData());
        MapEntryMatcher actualMatcher = new MapEntryMatcher((Map<String, Object>)this.actualReturnValue.getMetaData());
        expectedMatcher.describeTo((Description)expectedDescription);
        actualMatcher.describeTo((Description)actualDescription);
        if (!this.verifyMetaDataEquality(expectedResultMessage.getPayloadType(), (Map<String, Object>)expectedResultMessage.getMetaData(), (Map<String, Object>)this.actualReturnValue.getMetaData())) {
            this.reporter.reportWrongResult(actualDescription, expectedDescription);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectResultMessageMatching(Matcher<? super CommandResultMessage<?>> matcher) {
        if (matcher == null) {
            return this.expectResultMessageMatching(CoreMatchers.nullValue());
        }
        StringDescription expectedDescription = new StringDescription();
        matcher.describeTo((Description)expectedDescription);
        if (this.actualException != null) {
            this.reporter.reportUnexpectedException(this.actualException, (Description)expectedDescription);
        } else if (!matcher.matches(this.actualReturnValue)) {
            this.reporter.reportWrongResult(this.actualReturnValue, expectedDescription);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectExceptionMessage(Matcher<?> exceptionMessageMatcher) {
        StringDescription emptyMatcherDescription = new StringDescription((Appendable)new StringBuilder("Given exception message matcher is null!"));
        if (exceptionMessageMatcher == null) {
            this.reporter.reportWrongExceptionMessage(this.actualException, (Description)emptyMatcherDescription);
            return this;
        }
        StringDescription description = new StringDescription();
        exceptionMessageMatcher.describeTo((Description)description);
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue.getPayload(), (Description)description);
        }
        if (this.actualException != null && !exceptionMessageMatcher.matches((Object)this.actualException.getMessage())) {
            this.reporter.reportWrongExceptionMessage(this.actualException, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectExceptionMessage(String exceptionMessage) {
        return this.expectExceptionMessage(CoreMatchers.equalTo((Object)exceptionMessage));
    }

    @Override
    public ResultValidator<T> expectException(Class<? extends Throwable> expectedException) {
        return this.expectException(CoreMatchers.instanceOf(expectedException));
    }

    @Override
    public ResultValidator<T> expectException(Matcher<?> matcher) {
        StringDescription description = new StringDescription();
        matcher.describeTo((Description)description);
        if (this.actualException == null) {
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue.getPayload(), (Description)description);
        }
        if (!matcher.matches((Object)this.actualException)) {
            this.reporter.reportWrongException(this.actualException, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectExceptionDetails(Object exceptionDetails) {
        return this.expectExceptionDetails(CoreMatchers.equalTo((Object)exceptionDetails));
    }

    @Override
    public ResultValidator<T> expectExceptionDetails(Class<?> exceptionDetails) {
        return this.expectExceptionDetails(CoreMatchers.instanceOf(exceptionDetails));
    }

    @Override
    public ResultValidator<T> expectExceptionDetails(Matcher<?> exceptionDetailsMatcher) {
        Object actualDetails = HandlerExecutionException.resolveDetails((Throwable)this.actualException).orElse(null);
        if (exceptionDetailsMatcher == null) {
            StringDescription emptyMatcherDescription = new StringDescription((Appendable)new StringBuilder("Given exception details matcher is null!"));
            this.reporter.reportWrongExceptionDetails(actualDetails, (Description)emptyMatcherDescription);
            return this;
        }
        if (this.actualException == null) {
            StringDescription description = new StringDescription((Appendable)new StringBuilder("an exception with details matching "));
            exceptionDetailsMatcher.describeTo((Description)description);
            this.reporter.reportUnexpectedReturnValue(this.actualReturnValue.getPayload(), (Description)description);
            return this;
        }
        if (!exceptionDetailsMatcher.matches(actualDetails)) {
            StringDescription description = new StringDescription();
            exceptionDetailsMatcher.describeTo((Description)description);
            this.reporter.reportWrongExceptionDetails(actualDetails, (Description)description);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectMarkedDeleted() {
        if (!this.state.get().isDeleted()) {
            this.reporter.reportIncorrectDeletedState(true);
        }
        return this;
    }

    @Override
    public ResultValidator<T> expectNotMarkedDeleted() {
        if (this.state.get().isDeleted()) {
            this.reporter.reportIncorrectDeletedState(false);
        }
        return this;
    }

    public void onResult(@Nonnull CommandMessage<?> commandMessage, @Nonnull CommandResultMessage<?> commandResultMessage) {
        if (commandResultMessage.isExceptional()) {
            this.actualException = commandResultMessage.exceptionResult();
        } else {
            this.actualReturnValue = commandResultMessage;
        }
    }

    public void assertValidRecording() {
        if (this.actualException instanceof Error) {
            throw (Error)this.actualException;
        }
        if (this.actualException instanceof FixtureExecutionException) {
            throw (FixtureExecutionException)((Object)this.actualException);
        }
    }

    private boolean verifyPayloadEquality(Object expectedPayload, Object actualPayload) {
        if (Objects.equals(expectedPayload, actualPayload)) {
            return true;
        }
        if (expectedPayload != null && actualPayload == null) {
            return false;
        }
        if (expectedPayload == null) {
            return false;
        }
        if (!expectedPayload.getClass().equals(actualPayload.getClass())) {
            return false;
        }
        Matcher<Object> matcher = Matchers.deepEquals(expectedPayload, this.fieldFilter);
        if (!matcher.matches(actualPayload)) {
            this.reporter.reportDifferentPayloads(expectedPayload.getClass(), actualPayload, expectedPayload);
        }
        return true;
    }

    private boolean verifyMetaDataEquality(Class<?> eventType, Map<String, Object> expectedMetaData, Map<String, Object> actualMetaData) {
        MapEntryMatcher matcher = new MapEntryMatcher(expectedMetaData);
        if (!matcher.matches(actualMetaData)) {
            this.reporter.reportDifferentMetaData(eventType, matcher.getMissingEntries(), matcher.getAdditionalEntries());
        }
        return true;
    }
}

