/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.axonserver.connector.query.subscription;

import io.axoniq.axonserver.grpc.query.QueryUpdate;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.axonframework.axonserver.connector.ErrorCode;
import org.axonframework.axonserver.connector.util.GrpcMetaData;
import org.axonframework.axonserver.connector.util.GrpcSerializedObject;
import org.axonframework.messaging.IllegalPayloadAccessException;
import org.axonframework.messaging.MetaData;
import org.axonframework.queryhandling.SubscriptionQueryUpdateMessage;
import org.axonframework.serialization.LazyDeserializingObject;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;

class GrpcBackedQueryUpdateMessage<U>
implements SubscriptionQueryUpdateMessage<U> {
    private final QueryUpdate queryUpdate;
    private final LazyDeserializingObject<U> serializedPayload;
    private final Throwable exception;
    private final Supplier<MetaData> metaDataSupplier;

    public GrpcBackedQueryUpdateMessage(QueryUpdate queryUpdate, Serializer serializer) {
        this.queryUpdate = queryUpdate;
        this.serializedPayload = queryUpdate.hasPayload() ? new LazyDeserializingObject((SerializedObject)new GrpcSerializedObject(queryUpdate.getPayload()), serializer) : null;
        Supplier<Object> exceptionDetails = this.serializedPayload == null ? () -> null : () -> this.serializedPayload.getObject();
        this.exception = queryUpdate.hasErrorMessage() ? ErrorCode.getFromCode(queryUpdate.getErrorCode()).convert(queryUpdate.getErrorMessage(), exceptionDetails) : null;
        this.metaDataSupplier = new GrpcMetaData(queryUpdate.getMetaDataMap(), serializer);
    }

    private GrpcBackedQueryUpdateMessage(QueryUpdate queryUpdate, LazyDeserializingObject<U> serializedPayload, Throwable exception, Supplier<MetaData> metaDataSupplier) {
        this.queryUpdate = queryUpdate;
        this.serializedPayload = serializedPayload;
        this.exception = exception;
        this.metaDataSupplier = metaDataSupplier;
    }

    public String getIdentifier() {
        return this.queryUpdate.getMessageIdentifier();
    }

    public MetaData getMetaData() {
        return this.metaDataSupplier.get();
    }

    public U getPayload() {
        if (this.isExceptional()) {
            throw new IllegalPayloadAccessException("This result completed exceptionally, payload is not available. Try calling 'exceptionResult' to see the cause of failure.", this.exception);
        }
        return (U)(this.serializedPayload == null ? null : this.serializedPayload.getObject());
    }

    public Class<U> getPayloadType() {
        return this.serializedPayload.getType();
    }

    public boolean isExceptional() {
        return this.exception != null;
    }

    public Optional<Throwable> optionalExceptionResult() {
        return Optional.ofNullable(this.exception);
    }

    public GrpcBackedQueryUpdateMessage<U> withMetaData(@Nonnull Map<String, ?> metaData) {
        return new GrpcBackedQueryUpdateMessage<U>(this.queryUpdate, this.serializedPayload, this.exception, () -> MetaData.from((Map)metaData));
    }

    public GrpcBackedQueryUpdateMessage<U> andMetaData(@Nonnull Map<String, ?> metaData) {
        return this.withMetaData((Map)this.getMetaData().mergedWith(metaData));
    }
}

