/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.serialization;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.annotation.Nonnull;
import org.axonframework.common.AxonConfigurationException;
import org.axonframework.common.BuilderUtils;
import org.axonframework.common.io.IOUtils;
import org.axonframework.serialization.ChainingConverter;
import org.axonframework.serialization.Converter;
import org.axonframework.serialization.RevisionResolver;
import org.axonframework.serialization.SerialVersionUIDRevisionResolver;
import org.axonframework.serialization.SerializationException;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.SerializedType;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.axonframework.serialization.SimpleSerializedType;
import org.axonframework.serialization.UnknownSerializedType;

@Deprecated
public class JavaSerializer
implements Serializer {
    private final RevisionResolver revisionResolver;
    private final Converter converter = new ChainingConverter();

    protected JavaSerializer(Builder builder) {
        builder.validate();
        this.revisionResolver = builder.revisionResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SerializedObject<T> serialize(Object instance, @Nonnull Class<T> expectedType) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            try {
                oos.writeObject(instance);
            }
            finally {
                oos.flush();
            }
        }
        catch (IOException e) {
            throw new SerializationException("An exception occurred writing serialized data to the output stream", e);
        }
        T converted = this.converter.convert(baos.toByteArray(), expectedType);
        return new SimpleSerializedObject<T>(converted, expectedType, this.getSerializedType(instance));
    }

    private SerializedType getSerializedType(Object instance) {
        SerializedType serializedType = instance == null ? SimpleSerializedType.emptyType() : new SimpleSerializedType(instance.getClass().getName(), this.revisionOf(instance.getClass()));
        return serializedType;
    }

    @Override
    public <T> boolean canSerializeTo(@Nonnull Class<T> expectedRepresentation) {
        return this.converter.canConvert(byte[].class, expectedRepresentation);
    }

    @Override
    public <S, T> T deserialize(@Nonnull SerializedObject<S> serializedObject) {
        Object object;
        if (SerializedType.emptyType().equals(serializedObject.getType())) {
            return null;
        }
        if (UnknownSerializedType.class.isAssignableFrom(this.classForType(serializedObject.getType()))) {
            return (T)new UnknownSerializedType(this, serializedObject);
        }
        SerializedObject<InputStream> converted = this.converter.convert(serializedObject, InputStream.class);
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(converted.getData());
            object = ois.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            try {
                throw new SerializationException("An error occurred while deserializing: " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(ois);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(ois);
        return (T)object;
    }

    @Override
    public Class classForType(@Nonnull SerializedType type) {
        if (SerializedType.emptyType().equals(type)) {
            return Void.class;
        }
        try {
            return Class.forName(type.getName());
        }
        catch (ClassNotFoundException e) {
            return UnknownSerializedType.class;
        }
    }

    @Override
    public SerializedType typeForClass(Class type) {
        return new SimpleSerializedType(type.getName(), this.revisionOf(type));
    }

    @Override
    public Converter getConverter() {
        return this.converter;
    }

    private String revisionOf(Class<?> type) {
        return this.revisionResolver.revisionOf(type);
    }

    public static class Builder {
        private RevisionResolver revisionResolver = new SerialVersionUIDRevisionResolver();

        public Builder revisionResolver(RevisionResolver revisionResolver) {
            BuilderUtils.assertNonNull(revisionResolver, "RevisionResolver may not be null");
            this.revisionResolver = revisionResolver;
            return this;
        }

        public JavaSerializer build() {
            return new JavaSerializer(this);
        }

        protected void validate() throws AxonConfigurationException {
        }
    }
}

