/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore.jdbc;

import java.util.function.Function;

public class EventSchema {
    private final String domainEventTable;
    private final String snapshotTable;
    private final String globalIndexColumn;
    private final String timestampColumn;
    private final String eventIdentifierColumn;
    private final String aggregateIdentifierColumn;
    private final String sequenceNumberColumn;
    private final String typeColumn;
    private final String payloadTypeColumn;
    private final String payloadRevisionColumn;
    private final String payloadColumn;
    private final String metaDataColumn;
    private final Function<EventSchema, String> domainEventFields;
    private final Function<EventSchema, String> trackedEventFields;

    public EventSchema() {
        this(EventSchema.builder());
    }

    private EventSchema(Builder builder) {
        this.domainEventTable = builder.domainEventTable;
        this.snapshotTable = builder.snapshotTable;
        this.globalIndexColumn = builder.globalIndexColumn;
        this.timestampColumn = builder.timestampColumn;
        this.eventIdentifierColumn = builder.eventIdentifierColumn;
        this.aggregateIdentifierColumn = builder.aggregateIdentifierColumn;
        this.sequenceNumberColumn = builder.sequenceNumberColumn;
        this.typeColumn = builder.typeColumn;
        this.payloadTypeColumn = builder.payloadTypeColumn;
        this.payloadRevisionColumn = builder.payloadRevisionColumn;
        this.payloadColumn = builder.payloadColumn;
        this.metaDataColumn = builder.metaDataColumn;
        this.domainEventFields = builder.domainEventFields;
        this.trackedEventFields = builder.trackedEventFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String domainEventTable() {
        return this.domainEventTable;
    }

    public String snapshotTable() {
        return this.snapshotTable;
    }

    public String globalIndexColumn() {
        return this.globalIndexColumn;
    }

    public String timestampColumn() {
        return this.timestampColumn;
    }

    public String eventIdentifierColumn() {
        return this.eventIdentifierColumn;
    }

    public String aggregateIdentifierColumn() {
        return this.aggregateIdentifierColumn;
    }

    public String sequenceNumberColumn() {
        return this.sequenceNumberColumn;
    }

    public String typeColumn() {
        return this.typeColumn;
    }

    public String payloadTypeColumn() {
        return this.payloadTypeColumn;
    }

    public String payloadRevisionColumn() {
        return this.payloadRevisionColumn;
    }

    public String payloadColumn() {
        return this.payloadColumn;
    }

    public String metaDataColumn() {
        return this.metaDataColumn;
    }

    public String domainEventFields() {
        return this.domainEventFields.apply(this);
    }

    public String trackedEventFields() {
        return this.trackedEventFields.apply(this);
    }

    public static class Builder {
        private String domainEventTable = "DomainEventEntry";
        private String snapshotTable = "SnapshotEventEntry";
        private String globalIndexColumn = "globalIndex";
        private String timestampColumn = "timeStamp";
        private String eventIdentifierColumn = "eventIdentifier";
        private String aggregateIdentifierColumn = "aggregateIdentifier";
        private String sequenceNumberColumn = "sequenceNumber";
        private String typeColumn = "type";
        private String payloadTypeColumn = "payloadType";
        private String payloadRevisionColumn = "payloadRevision";
        private String payloadColumn = "payload";
        private String metaDataColumn = "metaData";
        private Function<EventSchema, String> domainEventFields = eventSchema -> String.join((CharSequence)", ", eventSchema.eventIdentifierColumn(), eventSchema.aggregateIdentifierColumn(), eventSchema.sequenceNumberColumn(), eventSchema.typeColumn(), eventSchema.timestampColumn(), eventSchema.payloadTypeColumn(), eventSchema.payloadRevisionColumn(), eventSchema.payloadColumn(), eventSchema.metaDataColumn());
        private Function<EventSchema, String> trackedEventFields = eventSchema -> eventSchema.globalIndexColumn() + ", " + eventSchema.domainEventFields();

        public Builder eventTable(String eventTable) {
            this.domainEventTable = eventTable;
            return this;
        }

        public Builder snapshotTable(String snapshotTable) {
            this.snapshotTable = snapshotTable;
            return this;
        }

        public Builder globalIndexColumn(String globalIndexColumn) {
            this.globalIndexColumn = globalIndexColumn;
            return this;
        }

        public Builder timestampColumn(String timestampColumn) {
            this.timestampColumn = timestampColumn;
            return this;
        }

        public Builder eventIdentifierColumn(String eventIdentifierColumn) {
            this.eventIdentifierColumn = eventIdentifierColumn;
            return this;
        }

        public Builder aggregateIdentifierColumn(String aggregateIdentifierColumn) {
            this.aggregateIdentifierColumn = aggregateIdentifierColumn;
            return this;
        }

        public Builder sequenceNumberColumn(String sequenceNumberColumn) {
            this.sequenceNumberColumn = sequenceNumberColumn;
            return this;
        }

        public Builder typeColumn(String typeColumn) {
            this.typeColumn = typeColumn;
            return this;
        }

        public Builder payloadTypeColumn(String payloadTypeColumn) {
            this.payloadTypeColumn = payloadTypeColumn;
            return this;
        }

        public Builder payloadRevisionColumn(String payloadRevisionColumn) {
            this.payloadRevisionColumn = payloadRevisionColumn;
            return this;
        }

        public Builder payloadColumn(String payloadColumn) {
            this.payloadColumn = payloadColumn;
            return this;
        }

        public Builder metaDataColumn(String metaDataColumn) {
            this.metaDataColumn = metaDataColumn;
            return this;
        }

        public Builder domainEventFields(Function<EventSchema, String> domainEventFields) {
            this.domainEventFields = domainEventFields;
            return this;
        }

        public Builder trackedEventFields(Function<EventSchema, String> trackedEventFields) {
            this.trackedEventFields = trackedEventFields;
            return this;
        }

        public EventSchema build() {
            return new EventSchema(this);
        }
    }
}

