/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing.eventstore;

import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Objects;
import org.axonframework.eventhandling.AbstractEventEntry;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.serialization.Serializer;

@MappedSuperclass
@IdClass(value=PK.class)
public abstract class AbstractSnapshotEventEntry<T>
extends AbstractEventEntry<T>
implements DomainEventData<T> {
    @Id
    private String aggregateIdentifier;
    @Id
    private long sequenceNumber;
    @Id
    private String type;

    public AbstractSnapshotEventEntry(DomainEventMessage<?> eventMessage, Serializer serializer, Class<T> contentType) {
        super(eventMessage, serializer, contentType);
        this.type = eventMessage.getType();
        this.aggregateIdentifier = eventMessage.getAggregateIdentifier();
        this.sequenceNumber = eventMessage.getSequenceNumber();
    }

    public AbstractSnapshotEventEntry(String type, String aggregateIdentifier, long sequenceNumber, String eventIdentifier, Object timestamp, String payloadType, String payloadRevision, T payload, T metaData) {
        super(eventIdentifier, timestamp, payloadType, payloadRevision, payload, metaData);
        this.type = type;
        this.aggregateIdentifier = aggregateIdentifier;
        this.sequenceNumber = sequenceNumber;
    }

    protected AbstractSnapshotEventEntry() {
    }

    public String getType() {
        return this.type;
    }

    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public static class PK
    implements Serializable {
        private static final long serialVersionUID = 9182347799552520594L;
        private String aggregateIdentifier;
        private long sequenceNumber;
        private String type;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PK pk = (PK)o;
            return this.sequenceNumber == pk.sequenceNumber && Objects.equals(this.aggregateIdentifier, pk.aggregateIdentifier) && Objects.equals(this.type, pk.type);
        }

        public int hashCode() {
            return Objects.hash(this.aggregateIdentifier, this.type, this.sequenceNumber);
        }

        public String toString() {
            return "PK{type='" + this.type + '\'' + ", aggregateIdentifier='" + this.aggregateIdentifier + '\'' + ", sequenceNumber=" + this.sequenceNumber + '}';
        }
    }
}

