/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.axonframework.common.Assert;
import org.axonframework.common.ReflectionUtils;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AbstractAggregateFactory;
import org.axonframework.eventsourcing.IncompatibleAggregateException;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;

public class GenericAggregateFactory<T>
extends AbstractAggregateFactory<T> {
    private final Map<Class<?>, Constructor<?>> constructors = new HashMap();

    public GenericAggregateFactory(Class<T> aggregateType) {
        this(AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateType));
        Assert.isFalse((boolean)Modifier.isAbstract(aggregateType.getModifiers()), () -> "Given aggregateType may not be abstract");
    }

    public GenericAggregateFactory(AggregateModel<T> aggregateModel) {
        super(aggregateModel);
        aggregateModel.types().filter(type -> !Modifier.isInterface(type.getModifiers())).filter(type -> !Modifier.isAbstract(type.getModifiers())).forEach(type -> {
            try {
                Constructor constructor = (Constructor)ReflectionUtils.ensureAccessible(type.getDeclaredConstructor(new Class[0]));
                this.constructors.put((Class<?>)type, constructor);
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleAggregateException(String.format("The aggregate [%s] doesn't provide a no-arg constructor.", type.getName()));
            }
        });
    }

    @Override
    protected T doCreateAggregate(String aggregateIdentifier, DomainEventMessage firstEvent) {
        Class type = this.aggregateModel().type(firstEvent.getType()).orElse(this.getAggregateType());
        return this.newInstance(type, this.constructors.get(type));
    }

    private T newInstance(Class<?> type, Constructor<?> constructor) {
        try {
            return (T)constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate [%s] does not have a suitable no-arg constructor.", type.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new IncompatibleAggregateException(String.format("The aggregate no-arg constructor of the aggregate [%s] is not accessible. Please ensure that the constructor is public or that the Security Manager allows access through reflection.", type.getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new IncompatibleAggregateException(String.format("The no-arg constructor of [%s] threw an exception on invocation.", type.getSimpleName()), e);
        }
    }
}

