/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.eventsourcing;

import java.util.Optional;
import java.util.Set;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.eventsourcing.AggregateFactory;
import org.axonframework.modelling.command.inspection.AggregateModel;
import org.axonframework.modelling.command.inspection.AnnotatedAggregateMetaModelFactory;

public abstract class AbstractAggregateFactory<T>
implements AggregateFactory<T> {
    private final Class<T> aggregateBaseType;
    private final AggregateModel<T> aggregateModel;

    protected AbstractAggregateFactory(Class<T> aggregateBaseType) {
        this(AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateBaseType));
    }

    protected AbstractAggregateFactory(Class<T> aggregateBaseType, Set<Class<? extends T>> aggregateSubTypes) {
        this(AnnotatedAggregateMetaModelFactory.inspectAggregate(aggregateBaseType, aggregateSubTypes));
    }

    protected AbstractAggregateFactory(AggregateModel<T> aggregateModel) {
        this.aggregateBaseType = aggregateModel.entityClass();
        this.aggregateModel = aggregateModel;
    }

    protected AggregateModel<T> aggregateModel() {
        return this.aggregateModel;
    }

    @Override
    public final T createAggregateRoot(String aggregateIdentifier, DomainEventMessage<?> firstEvent) {
        return (T)this.postProcessInstance(this.fromSnapshot(firstEvent).orElseGet(() -> this.doCreateAggregate(aggregateIdentifier, firstEvent)));
    }

    private Optional<T> fromSnapshot(DomainEventMessage<?> firstEvent) {
        if (this.aggregateModel.types().anyMatch(firstEvent.getPayloadType()::equals)) {
            return Optional.of(firstEvent.getPayload());
        }
        return Optional.empty();
    }

    protected T postProcessInstance(T aggregate) {
        return aggregate;
    }

    protected abstract T doCreateAggregate(String var1, DomainEventMessage var2);

    @Override
    public Class<T> getAggregateType() {
        return this.aggregateBaseType;
    }
}

