/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.loadcontext;

import com.avaje.ebeaninternal.server.loadcontext.DLoadList;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DLoadWeakList<T>
implements DLoadList<T> {
    private static final Logger logger = Logger.getLogger(DLoadWeakList.class.getName());
    protected final ArrayList<WeakReference<T>> list = new ArrayList();
    protected int removedFromTop;

    protected DLoadWeakList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int add(T e) {
        DLoadWeakList dLoadWeakList = this;
        synchronized (dLoadWeakList) {
            int i = this.list.size();
            this.list.add(new WeakReference<T>(e));
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(int position) {
        DLoadWeakList dLoadWeakList = this;
        synchronized (dLoadWeakList) {
            WeakReference<T> wref = this.list.get(position);
            if (wref == null) {
                logger.log(Level.WARNING, "removeEntry found no WeakReference for position[" + position + "]");
            } else {
                this.list.set(position, null);
                Object object = wref.get();
                if (object == null) {
                    logger.log(Level.WARNING, "removeEntry found no Object held by WeakReference for position[" + position + "]");
                }
            }
            if (position == this.removedFromTop) {
                ++this.removedFromTop;
            }
        }
    }

    @Override
    public List<T> getNextBatch(int batchSize) {
        if (this.removedFromTop >= this.list.size()) {
            return new ArrayList(0);
        }
        return this.getLoadBatch(this.removedFromTop, batchSize, true);
    }

    @Override
    public List<T> getLoadBatch(int position, int batchSize) {
        return this.getLoadBatch(position, batchSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<T> getLoadBatch(int position, int batchSize, boolean ignoreMissing) {
        DLoadWeakList dLoadWeakList = this;
        synchronized (dLoadWeakList) {
            int i;
            if (batchSize < 1) {
                throw new RuntimeException("batchSize " + batchSize + " < 1 ??!!");
            }
            ArrayList batch = new ArrayList();
            if (!this.addObjectToBatchAt(batch, position) && !ignoreMissing) {
                String msg = "getLoadBatch position[" + position + "] didn't find a bean in the list?";
                throw new IllegalStateException(msg);
            }
            for (i = position; i < this.list.size(); ++i) {
                this.addObjectToBatchAt(batch, i);
                if (batch.size() != batchSize) continue;
                return batch;
            }
            for (i = this.removedFromTop; i < position; ++i) {
                this.addObjectToBatchAt(batch, i);
                if (batch.size() != batchSize) continue;
                return batch;
            }
            return batch;
        }
    }

    private boolean addObjectToBatchAt(ArrayList<T> batch, int i) {
        boolean found = false;
        WeakReference<T> wref = this.list.get(i);
        if (wref != null) {
            Object object = wref.get();
            if (object == null) {
                logger.log(Level.WARNING, "Bean is null from weak reference");
            } else {
                found = true;
                batch.add(object);
            }
            this.list.set(i, null);
        }
        if (i == this.removedFromTop) {
            ++this.removedFromTop;
        }
        return found;
    }
}

