/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.bean;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.common.BeanList;
import com.avaje.ebean.event.BeanFinder;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebean.meta.MetaAutoFetchStatistic;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.autofetch.AutoFetchManager;
import com.avaje.ebeaninternal.server.autofetch.Statistics;
import java.util.Iterator;
import javax.persistence.PersistenceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BFAutoFetchStatisticFinder
implements BeanFinder<MetaAutoFetchStatistic> {
    @Override
    public MetaAutoFetchStatistic find(BeanQueryRequest<MetaAutoFetchStatistic> request) {
        SpiQuery query = (SpiQuery)request.getQuery();
        try {
            String queryPointKey = (String)query.getId();
            SpiEbeanServer server = (SpiEbeanServer)request.getEbeanServer();
            AutoFetchManager manager = server.getAutoFetchManager();
            Statistics stats = manager.getStatistics(queryPointKey);
            if (stats != null) {
                return stats.createPublicMeta();
            }
            return null;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    @Override
    public BeanCollection<MetaAutoFetchStatistic> findMany(BeanQueryRequest<MetaAutoFetchStatistic> request) {
        SpiQuery.Type queryType = ((SpiQuery)request.getQuery()).getType();
        if (!queryType.equals((Object)SpiQuery.Type.LIST)) {
            throw new PersistenceException("Only findList() supported at this stage.");
        }
        SpiEbeanServer server = (SpiEbeanServer)request.getEbeanServer();
        AutoFetchManager manager = server.getAutoFetchManager();
        BeanList<MetaAutoFetchStatistic> list = new BeanList<MetaAutoFetchStatistic>();
        Iterator<Statistics> it = manager.iterateStatistics();
        while (it.hasNext()) {
            Statistics stats = it.next();
            list.add(stats.createPublicMeta());
        }
        String orderBy = request.getQuery().order().toStringFormat();
        if (orderBy == null) {
            orderBy = "beanType";
        }
        server.sort(list, orderBy);
        return list;
    }
}

