/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.http.HttpServletRequest;
import org.atmosphere.container.JSR356AsyncSupport;
import org.atmosphere.cpr.AsyncSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereFrameworkInitializer;
import org.atmosphere.cpr.DefaultAsyncSupportResolver;
import org.atmosphere.cpr.SessionSupport;
import org.atmosphere.util.IOUtils;
import org.atmosphere.util.Utils;

@HandlesTypes(value={})
public class ContainerInitializer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> classes, ServletContext c) throws ServletException {
        c.log("Initializing AtmosphereFramework");
        for (Map.Entry reg : c.getServletRegistrations().entrySet()) {
            String disableSwitchValue = ((ServletRegistration)reg.getValue()).getInitParameter("org.atmosphere.cpr.AtmosphereInitializer.disabled");
            if (Boolean.parseBoolean(disableSwitchValue)) {
                c.log("Container managed initialization disabled for servlet: " + ((ServletRegistration)reg.getValue()).getName());
                continue;
            }
            if (c.getAttribute((String)reg.getKey()) != null || !IOUtils.isAtmosphere(((ServletRegistration)reg.getValue()).getClassName())) continue;
            final AtmosphereFramework framework = AtmosphereFrameworkInitializer.newAtmosphereFramework(c, false, true);
            DefaultAsyncSupportResolver resolver = new DefaultAsyncSupportResolver(framework.getAtmosphereConfig());
            List<Class<? extends AsyncSupport>> l = resolver.detectWebSocketPresent(false, true);
            int size = c.getServerInfo().contains("WebLogic") ? 1 : 0;
            String s = ((ServletRegistration)reg.getValue()).getInitParameter("org.atmosphere.cpr.asyncSupport");
            boolean force = false;
            if (s != null && s.equals(JSR356AsyncSupport.class.getName())) {
                force = true;
            }
            if (force || l.size() == size && resolver.testClassExists("javax.websocket.Endpoint")) {
                try {
                    framework.setAsyncSupport(new JSR356AsyncSupport(framework.getAtmosphereConfig(), c));
                }
                catch (IllegalStateException ex) {
                    c.log("Unable to initialize websocket support", (Throwable)ex);
                }
            }
            try {
                c.addListener((EventListener)new ServletRequestListener(){

                    public void requestDestroyed(ServletRequestEvent sre) {
                    }

                    public void requestInitialized(ServletRequestEvent sre) {
                        HttpServletRequest r = (HttpServletRequest)HttpServletRequest.class.cast(sre.getServletRequest());
                        AtmosphereConfig config = framework.getAtmosphereConfig();
                        if (config.isSupportSession() && Utils.webSocketEnabled(r)) {
                            r.getSession(config.getInitParameter("org.atmosphere.cpr.sessionCreate", true));
                        }
                    }
                });
            }
            catch (Throwable t) {
                c.log("AtmosphereFramework : Unable to install WebSocket Session Creator", t);
            }
            try {
                boolean sessionSupport;
                s = c.getInitParameter("org.atmosphere.cpr.sessionSupport");
                if (s != null && (sessionSupport = Boolean.valueOf(s).booleanValue()) && c.getMajorVersion() > 2) {
                    c.addListener(SessionSupport.class);
                    c.log("AtmosphereFramework : Installed " + SessionSupport.class);
                }
            }
            catch (Throwable t) {
                c.log("AtmosphereFramework : SessionSupport error. Make sure you also define {} as a listener in web.xml, see https://github.com/Atmosphere/atmosphere/wiki/Enabling-HttpSession-Support", t);
            }
            c.setAttribute((String)reg.getKey(), (Object)framework);
        }
    }
}

