/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager.internal;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.asteriskjava.manager.event.ManagerEvent;
import org.asteriskjava.manager.event.PeerEntryEvent;
import org.asteriskjava.manager.event.PeersEvent;
import org.asteriskjava.manager.event.ResponseEvent;
import org.asteriskjava.manager.event.UserEvent;
import org.asteriskjava.manager.internal.EventBuilder;
import org.asteriskjava.manager.internal.ManagerUtil;
import org.asteriskjava.manager.util.EventAttributesHelper;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

class EventBuilderImpl
implements EventBuilder {
    private static final Set<String> ignoredAttributes = new HashSet<String>(Arrays.asList("event"));
    private Map<String, Class<?>> registeredEventClasses;
    private final Set<String> eventClassNegativeCache = new HashSet<String>();
    private static final Log logger = LogFactory.getLog(EventBuilderImpl.class);
    private static final Set<Class<? extends ManagerEvent>> knownManagerEventClasses = new Reflections("org.asteriskjava.manager.event", new Scanner[0]).getSubTypesOf(ManagerEvent.class);

    EventBuilderImpl() {
        this.registeredEventClasses = new HashMap();
        this.registerBuiltinEventClasses();
    }

    private void registerBuiltinEventClasses() {
        for (Class<? extends ManagerEvent> managerEventClass : knownManagerEventClasses) {
            if (Modifier.isAbstract(managerEventClass.getModifiers())) continue;
            this.registerEventClass(managerEventClass);
        }
    }

    @Override
    public final void registerEventClass(Class<? extends ManagerEvent> clazz) throws IllegalArgumentException {
        String className = clazz.getName();
        String eventType = className.substring(className.lastIndexOf(46) + 1).toLowerCase(Locale.ENGLISH);
        if (eventType.endsWith("event")) {
            eventType = eventType.substring(0, eventType.length() - "event".length());
        }
        if (UserEvent.class.isAssignableFrom(clazz) && !eventType.startsWith("userevent")) {
            eventType = "userevent" + eventType;
        }
        this.registerEventClass(eventType, clazz);
    }

    public final void registerEventClass(String eventType, Class<? extends ManagerEvent> clazz) throws IllegalArgumentException {
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new IllegalArgumentException(clazz + " is abstract");
        }
        if (clazz.isInterface()) {
            throw new IllegalArgumentException(clazz + " is abstract");
        }
        try {
            Constructor<? extends ManagerEvent> defaultConstructor = clazz.getConstructor(Object.class);
            if (!Modifier.isPublic(defaultConstructor.getModifiers())) {
                throw new IllegalArgumentException(clazz + " has no public default constructor");
            }
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(clazz + " has no usable constructor");
        }
        this.registeredEventClasses.put(eventType.toLowerCase(Locale.US), clazz);
        logger.debug("Registered event type '" + eventType + "' (" + clazz + ")");
    }

    @Override
    public ManagerEvent buildEvent(Object source, Map<String, Object> attributes) {
        ResponseEvent responseEvent;
        String actionId;
        ManagerEvent event;
        Constructor<?> constructor;
        String eventType = null;
        if (attributes.get("event") == null) {
            logger.error("No event type in properties");
            return null;
        }
        if (attributes.get("event") instanceof List) {
            List eventNames = (List)attributes.get("event");
            if (!eventNames.isEmpty() && "PeerEntry".equals(eventNames.get(0))) {
                int peersAmount = attributes.get("listitems") != null ? Integer.parseInt((String)attributes.get("listitems")) : eventNames.size() - 1;
                ArrayList<Map<String, Object>> peersAttributes = new ArrayList<Map<String, Object>>();
                for (Map.Entry<String, Object> attribute : attributes.entrySet()) {
                    String key = attribute.getKey();
                    Object value = attribute.getValue();
                    for (int i = 0; i < peersAmount; ++i) {
                        Map<String, Object> peerAttrs;
                        if (peersAttributes.size() > i) {
                            peerAttrs = (Map)peersAttributes.get(i);
                        } else {
                            peerAttrs = new HashMap();
                            peersAttributes.add(i, peerAttrs);
                        }
                        if (value instanceof List) {
                            peerAttrs.put(key, ((List)value).get(i));
                            continue;
                        }
                        if (!(value instanceof String) || "listitems".equals(key)) continue;
                        peerAttrs.put(key, value);
                    }
                }
                attributes.put("peersAttributes", peersAttributes);
                eventType = "peers";
            }
        } else {
            if (!(attributes.get("event") instanceof String)) {
                logger.error("Event type is not a String or List");
                return null;
            }
            eventType = ((String)attributes.get("event")).toLowerCase(Locale.US);
            if ("userevent".equals(eventType)) {
                if (attributes.get("userevent") == null) {
                    logger.error("No user event type in properties");
                    return null;
                }
                if (!(attributes.get("userevent") instanceof String)) {
                    logger.error("User event type is not a String");
                    return null;
                }
                String userEventType = ((String)attributes.get("userevent")).toLowerCase(Locale.US);
                eventType = eventType + userEventType;
            }
        }
        Class<?> eventClass = this.registeredEventClasses.get(eventType);
        if (eventClass == null) {
            if (this.eventClassNegativeCache.add(eventType)) {
                logger.info("No event class registered for event type '" + eventType + "', attributes: " + attributes + ". Please report at https://github.com/asterisk-java/asterisk-java/issues");
            }
            return null;
        }
        try {
            constructor = eventClass.getConstructor(Object.class);
        }
        catch (NoSuchMethodException ex) {
            logger.error("Unable to get constructor of " + eventClass.getName(), ex);
            return null;
        }
        try {
            event = (ManagerEvent)constructor.newInstance(source);
        }
        catch (Exception ex) {
            logger.error("Unable to create new instance of " + eventClass.getName(), ex);
            return null;
        }
        if (attributes.get("peersAttributes") != null && attributes.get("peersAttributes") instanceof List) {
            PeersEvent peersEvent = (PeersEvent)event;
            for (Map peerAttrs : (List)attributes.get("peersAttributes")) {
                PeerEntryEvent peerEntryEvent = new PeerEntryEvent(source);
                EventAttributesHelper.setAttributes(peerEntryEvent, peerAttrs, ignoredAttributes);
                List<PeerEntryEvent> peerEntryEvents = peersEvent.getChildEvents();
                if (peerEntryEvents == null) {
                    peerEntryEvents = new ArrayList<PeerEntryEvent>();
                    peersEvent.setChildEvents(peerEntryEvents);
                }
                peerEntryEvents.add(peerEntryEvent);
            }
            peersEvent.setActionId(peersEvent.getChildEvents().get(0).getActionId());
        } else {
            EventAttributesHelper.setAttributes(event, attributes, ignoredAttributes);
        }
        if (event instanceof ResponseEvent && (actionId = (responseEvent = (ResponseEvent)event).getActionId()) != null) {
            responseEvent.setActionId(ManagerUtil.stripInternalActionId(actionId));
            responseEvent.setInternalActionId(ManagerUtil.getInternalActionId(actionId));
        }
        return event;
    }

    @Override
    public void deregisterEventClass(Class<? extends ManagerEvent> eventClass) {
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, Class<?>> registered : this.registeredEventClasses.entrySet()) {
            if (!registered.getValue().equals(eventClass)) continue;
            toRemove.add(registered.getKey());
        }
        if (toRemove.isEmpty()) {
            logger.warn("Couldn't remove event type " + eventClass);
        } else {
            for (String key : toRemove) {
                this.registeredEventClasses.remove(key);
                logger.warn("Removed event type " + key);
            }
        }
    }
}

