/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.internal.UnambiguousRepresentation;
import org.assertj.core.presentation.Representation;

public class ComparisonDifference
implements Comparable<ComparisonDifference> {
    private static final String TOP_LEVEL_ELEMENT_PATTERN = "^\\[\\d+]$";
    private static final String FIELD = "field/property '%s'";
    private static final String TOP_LEVEL_OBJECTS = "Top level actual and expected objects";
    private static final String TOP_LEVEL_ELEMENTS = "Top level actual and expected objects element at index %s";
    public static final String DEFAULT_TEMPLATE = "%s differ:%n- actual value  : %s%n- expected value: %s%s";
    final List<String> decomposedPath;
    final String concatenatedPath;
    final Object actual;
    final Object expected;
    final Optional<String> additionalInformation;
    final String template;

    public ComparisonDifference(DualValue dualValue) {
        this(dualValue.getDecomposedPath(), dualValue.actual, dualValue.expected, null, DEFAULT_TEMPLATE);
    }

    public ComparisonDifference(DualValue dualValue, String additionalInformation) {
        this(dualValue.getDecomposedPath(), dualValue.actual, dualValue.expected, additionalInformation, DEFAULT_TEMPLATE);
    }

    public ComparisonDifference(DualValue dualValue, String additionalInformation, String template) {
        this(dualValue.getDecomposedPath(), dualValue.actual, dualValue.expected, additionalInformation, template);
    }

    private ComparisonDifference(List<String> decomposedPath, Object actual, Object other, String additionalInformation, String template) {
        this.decomposedPath = Collections.unmodifiableList(Objects.requireNonNull(decomposedPath, "a path can't be null"));
        this.concatenatedPath = ComparisonDifference.toConcatenatedPath(decomposedPath);
        this.actual = actual;
        this.expected = other;
        this.additionalInformation = Optional.ofNullable(additionalInformation);
        this.template = template != null ? template : DEFAULT_TEMPLATE;
    }

    public static ComparisonDifference rootComparisonDifference(Object actual, Object other, String additionalInformation) {
        return new ComparisonDifference(DualValue.rootDualValue(actual, other), additionalInformation);
    }

    public Object getActual() {
        return this.actual;
    }

    public Object getExpected() {
        return this.expected;
    }

    public String getTemplate() {
        return this.template;
    }

    public Optional<String> getAdditionalInformation() {
        return this.additionalInformation;
    }

    public List<String> getDecomposedPath() {
        return this.decomposedPath;
    }

    public String toString() {
        return this.additionalInformation.map(s -> String.format("ComparisonDifference [path=%s, actual=%s, expected=%s, template=%s, additionalInformation=%s]", this.concatenatedPath, this.actual, this.expected, this.template, s)).orElseGet(() -> String.format("ComparisonDifference [path=%s, actual=%s, template=%s, expected=%s]", this.concatenatedPath, this.actual, this.template, this.expected));
    }

    public String multiLineDescription() {
        return this.multiLineDescription(ConfigurationProvider.CONFIGURATION_PROVIDER.representation());
    }

    public String multiLineDescription(Representation representation) {
        UnambiguousRepresentation unambiguousRepresentation = new UnambiguousRepresentation(representation, this.actual, this.expected);
        String additionalInfo = this.additionalInformation.map(ComparisonDifference::formatOnNewline).orElse("");
        return String.format(this.getTemplate(), this.fieldPathDescription(), unambiguousRepresentation.getActual(), unambiguousRepresentation.getExpected(), additionalInfo);
    }

    protected String fieldPathDescription() {
        if (this.concatenatedPath.isEmpty()) {
            return TOP_LEVEL_OBJECTS;
        }
        if (this.concatenatedPath.matches(TOP_LEVEL_ELEMENT_PATTERN)) {
            return String.format(TOP_LEVEL_ELEMENTS, ComparisonDifference.extractIndex(this.concatenatedPath));
        }
        return String.format(FIELD, this.concatenatedPath);
    }

    private static String extractIndex(String path) {
        String index = path.substring(1);
        return index.replaceFirst("]", "");
    }

    private static String formatOnNewline(String info) {
        return String.format("%n%s", info);
    }

    private static String toConcatenatedPath(List<String> decomposedPath) {
        String concatenatedPath = String.join((CharSequence)".", decomposedPath);
        return concatenatedPath.replaceAll("\\.\\[", "[");
    }

    public boolean equals(Object other) {
        if (!(other instanceof ComparisonDifference)) {
            return false;
        }
        ComparisonDifference castOther = (ComparisonDifference)other;
        return Objects.equals(this.concatenatedPath, castOther.concatenatedPath) && Objects.equals(this.actual, castOther.actual) && Objects.equals(this.expected, castOther.expected) && Objects.equals(this.template, castOther.template) && Objects.equals(this.additionalInformation, castOther.additionalInformation);
    }

    public int hashCode() {
        return Objects.hash(this.concatenatedPath, this.actual, this.expected, this.template, this.additionalInformation);
    }

    @Override
    public int compareTo(ComparisonDifference other) {
        return ComparisonDifference.concat(this.decomposedPath).compareTo(ComparisonDifference.concat(other.decomposedPath));
    }

    private static String concat(List<String> decomposedPath) {
        return String.join((CharSequence)"", decomposedPath);
    }
}

