/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.assertj.core.api.recursive.comparison.ComparisonDifference;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.DualValueDeque;
import org.assertj.core.api.recursive.comparison.RecursiveComparisonConfiguration;
import org.assertj.core.internal.Objects;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class RecursiveComparisonDifferenceCalculator {
    private static final String MISSING_FIELDS = "%s can't be compared to %s as %s does not declare all %s fields, it lacks these:%s";
    private static final Map<Class<?>, Boolean> customEquals = new ConcurrentHashMap();
    private static final Map<Class<?>, Boolean> customHash = new ConcurrentHashMap();

    public List<ComparisonDifference> determineDifferences(Object actual, Object expected, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(actual, expected)) {
            return Lists.list(RecursiveComparisonDifferenceCalculator.expectedAndActualTypeDifference(actual, expected));
        }
        List<String> rootPath = Lists.list(new String[0]);
        HashSet<DualValue> visited = new HashSet<DualValue>();
        return RecursiveComparisonDifferenceCalculator.determineDifferences(actual, expected, rootPath, visited, recursiveComparisonConfiguration);
    }

    private static List<ComparisonDifference> determineDifferences(Object actual, Object expected, List<String> parentPath, Set<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        Deque<DualValue> toCompare = RecursiveComparisonDifferenceCalculator.initStack(actual, expected, parentPath, visited, recursiveComparisonConfiguration);
        ArrayList<ComparisonDifference> differences = new ArrayList<ComparisonDifference>();
        while (!toCompare.isEmpty()) {
            Class<?> actualFieldClass;
            DualValue dualValue = toCompare.removeFirst();
            visited.add(dualValue);
            List<String> currentPath = dualValue.getPath();
            Object actualFieldValue = dualValue.actual;
            Object expectedFieldValue = dualValue.expected;
            if (actualFieldValue == expectedFieldValue) continue;
            if (RecursiveComparisonDifferenceCalculator.hasCustomComparator(dualValue, recursiveComparisonConfiguration)) {
                if (RecursiveComparisonDifferenceCalculator.propertyOrFieldValuesAreEqual(actualFieldValue, expectedFieldValue, dualValue.getConcatenatedPath(), recursiveComparisonConfiguration)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue == null || expectedFieldValue == null) {
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof Collection) {
                if (!(expectedFieldValue instanceof Collection)) {
                    differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                    continue;
                }
            } else if (expectedFieldValue instanceof Collection) {
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof SortedSet) {
                if (!(expectedFieldValue instanceof SortedSet)) {
                    differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                    continue;
                }
            } else if (expectedFieldValue instanceof SortedSet) {
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof SortedMap) {
                if (!(expectedFieldValue instanceof SortedMap)) {
                    differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                    continue;
                }
            } else if (expectedFieldValue instanceof SortedMap) {
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof Map) {
                if (!(expectedFieldValue instanceof Map)) {
                    differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                    continue;
                }
            } else if (expectedFieldValue instanceof Map) {
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if ((actualFieldClass = actualFieldValue.getClass()).isArray()) {
                if (RecursiveComparisonDifferenceCalculator.compareArrays(actualFieldValue, expectedFieldValue, currentPath, toCompare, visited)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof SortedSet) {
                if (RecursiveComparisonDifferenceCalculator.compareOrderedCollection((Collection)actualFieldValue, (Collection)expectedFieldValue, currentPath, toCompare, visited)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof List) {
                if (RecursiveComparisonDifferenceCalculator.compareOrderedCollection((Collection)actualFieldValue, (Collection)expectedFieldValue, currentPath, toCompare, visited)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof Collection) {
                if (RecursiveComparisonDifferenceCalculator.compareUnorderedCollection((Collection)actualFieldValue, (Collection)expectedFieldValue, currentPath, toCompare, visited, recursiveComparisonConfiguration)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof SortedMap) {
                if (RecursiveComparisonDifferenceCalculator.compareSortedMap((SortedMap)actualFieldValue, (SortedMap)expectedFieldValue, currentPath, toCompare, visited)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (actualFieldValue instanceof Map) {
                if (RecursiveComparisonDifferenceCalculator.compareUnorderedMap((Map)actualFieldValue, (Map)expectedFieldValue, currentPath, toCompare, visited)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            if (!recursiveComparisonConfiguration.shouldIgnoreOverriddenEqualsOf(dualValue) && RecursiveComparisonDifferenceCalculator.hasCustomEquals(actualFieldClass)) {
                if (actualFieldValue.equals(expectedFieldValue)) continue;
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue));
                continue;
            }
            Class<?> expectedFieldClass = expectedFieldValue.getClass();
            if (recursiveComparisonConfiguration.isInStrictTypeCheckingMode() && RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualValue)) {
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue, String.format("the fields are considered different since the comparison enforces strict type check and %s is not a subtype of %s", expectedFieldClass.getName(), actualFieldClass.getName())));
                continue;
            }
            Set<String> actualFieldsNames = RecursiveComparisonDifferenceCalculator.getNonIgnoredFieldNames(actualFieldClass, currentPath, recursiveComparisonConfiguration);
            Set<String> expectedFieldsNames = RecursiveComparisonDifferenceCalculator.getFieldsNames(expectedFieldClass);
            if (!expectedFieldsNames.containsAll(actualFieldsNames)) {
                HashSet<String> actualFieldsNamesNotInExpected = Sets.newHashSet(actualFieldsNames);
                actualFieldsNamesNotInExpected.removeAll(expectedFieldsNames);
                String missingFields = ((Object)actualFieldsNamesNotInExpected).toString();
                String expectedClassName = expectedFieldClass.getName();
                String actualClassName = actualFieldClass.getName();
                String missingFieldsDescription = String.format(MISSING_FIELDS, actualClassName, expectedClassName, expectedFieldClass.getSimpleName(), actualFieldClass.getSimpleName(), missingFields);
                differences.add(new ComparisonDifference(currentPath, actualFieldValue, expectedFieldValue, missingFieldsDescription));
                continue;
            }
            for (String fieldName : actualFieldsNames) {
                ArrayList<String> path = new ArrayList<String>(currentPath);
                path.add(fieldName);
                DualValue newDualValue = new DualValue(path, PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, actualFieldValue), PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, expectedFieldValue));
                if (visited.contains(newDualValue)) continue;
                toCompare.addFirst(newDualValue);
            }
        }
        Collections.sort(differences);
        return differences;
    }

    private static boolean hasCustomComparator(DualValue dualValue, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        String fieldName = dualValue.getConcatenatedPath();
        if (recursiveComparisonConfiguration.hasComparatorForField(fieldName)) {
            return true;
        }
        Class<?> valueType = dualValue.actual != null ? dualValue.actual.getClass() : dualValue.expected.getClass();
        return recursiveComparisonConfiguration.hasComparatorForType(valueType);
    }

    private static Deque<DualValue> initStack(Object actual, Object expected, List<String> parentPath, Set<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        DualValueDeque stack = new DualValueDeque(recursiveComparisonConfiguration);
        boolean isRootObject = parentPath.isEmpty();
        ArrayList<String> currentPath = new ArrayList<String>(parentPath);
        DualValue dualValue = new DualValue(currentPath, actual, expected);
        if (!(actual == null || expected == null || RecursiveComparisonDifferenceCalculator.isContainerType(actual) || RecursiveComparisonDifferenceCalculator.isContainerType(expected) || !isRootObject && RecursiveComparisonDifferenceCalculator.hasCustomComparator(dualValue, recursiveComparisonConfiguration))) {
            Set<String> actualFieldsNameSet = RecursiveComparisonDifferenceCalculator.getNonIgnoredFieldNames(actual.getClass(), parentPath, recursiveComparisonConfiguration);
            if (!actualFieldsNameSet.isEmpty()) {
                Set<String> expectedFieldsNameSet = RecursiveComparisonDifferenceCalculator.getFieldsNames(expected.getClass());
                if (!expectedFieldsNameSet.containsAll(actualFieldsNameSet)) {
                    stack.addFirst(dualValue);
                } else {
                    for (String fieldName : actualFieldsNameSet) {
                        ArrayList<String> fieldPath = new ArrayList<String>(currentPath);
                        fieldPath.add(fieldName);
                        DualValue fieldDualKey = new DualValue(fieldPath, PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, actual), PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, expected));
                        stack.addFirst(fieldDualKey);
                    }
                }
            } else {
                stack.addFirst(dualValue);
            }
        } else {
            stack.addFirst(dualValue);
        }
        stack.removeAll(visited);
        return stack;
    }

    private static Set<String> getNonIgnoredFieldNames(Class<?> actualClass, List<String> parentPath, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        String parentConcatenatedPath = Strings.join(parentPath).with(".");
        return RecursiveComparisonDifferenceCalculator.getFieldsNames(actualClass).stream().filter(recursiveComparisonConfiguration.shouldKeepField(parentConcatenatedPath)).collect(Collectors.toSet());
    }

    private static Set<String> getFieldsNames(Class<?> clazz) {
        Set<Field> fields = Objects.getDeclaredFieldsIncludingInherited(clazz);
        LinkedHashSet<String> fieldNames = new LinkedHashSet<String>();
        for (Field field : fields) {
            fieldNames.add(field.getName());
        }
        return fieldNames;
    }

    private static boolean isContainerType(Object o) {
        return o instanceof Collection || o instanceof Map;
    }

    private static boolean compareArrays(Object array1, Object array2, List<String> path, Deque<DualValue> toCompare, Set<DualValue> visited) {
        int length = Array.getLength(array1);
        if (length != Array.getLength(array2)) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            DualValue dualValue = new DualValue(path, Array.get(array1, i), Array.get(array2, i));
            if (visited.contains(dualValue)) continue;
            toCompare.addFirst(dualValue);
        }
        return true;
    }

    private static <K, V> boolean compareOrderedCollection(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualValue> toCompare, Set<DualValue> visited) {
        if (col1.size() != col2.size()) {
            return false;
        }
        Iterator<V> i2 = col2.iterator();
        for (K k : col1) {
            DualValue dualValue = new DualValue(path, k, i2.next());
            if (visited.contains(dualValue)) continue;
            toCompare.addFirst(dualValue);
        }
        return true;
    }

    private static <K, V> boolean compareUnorderedCollectionByHashCodes(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualValue> toCompare, Set<DualValue> visited) {
        HashMap<Integer, V> fastLookup = new HashMap<Integer, V>();
        for (Object o : col2) {
            fastLookup.put(RecursiveComparisonDifferenceCalculator.deepHashCode(o), o);
        }
        for (Object o : col1) {
            Object other = fastLookup.get(RecursiveComparisonDifferenceCalculator.deepHashCode(o));
            if (other == null) {
                return false;
            }
            DualValue dk = new DualValue(path, o, other);
            if (visited.contains(dk)) continue;
            toCompare.addFirst(dk);
        }
        return true;
    }

    private static <K, V> boolean compareUnorderedCollection(Collection<K> col1, Collection<V> col2, List<String> path, Deque<DualValue> toCompare, Set<DualValue> visited, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (col1.size() != col2.size()) {
            return false;
        }
        if (col1 instanceof Set && !recursiveComparisonConfiguration.hasCustomComparators()) {
            return RecursiveComparisonDifferenceCalculator.compareUnorderedCollectionByHashCodes(col1, col2, path, toCompare, visited);
        }
        LinkedList<V> col2Copy = new LinkedList<V>(col2);
        block0: for (K o1 : col1) {
            Iterator iterator = col2Copy.iterator();
            while (iterator.hasNext()) {
                Object o2 = iterator.next();
                if (!RecursiveComparisonDifferenceCalculator.determineDifferences(o1, o2, path, visited, recursiveComparisonConfiguration).isEmpty()) continue;
                iterator.remove();
                continue block0;
            }
        }
        return col2Copy.isEmpty();
    }

    private static <K1, V1, K2, V2> boolean compareSortedMap(SortedMap<K1, V1> map1, SortedMap<K2, V2> map2, List<String> path, Deque<DualValue> toCompare, Set<DualValue> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        Iterator<Map.Entry<K2, V2>> i2 = map2.entrySet().iterator();
        for (Map.Entry<K1, V1> entry1 : map1.entrySet()) {
            Map.Entry<K2, V2> entry2 = i2.next();
            DualValue dualValue = new DualValue(path, entry1.getKey(), entry2.getKey());
            if (!visited.contains(dualValue)) {
                toCompare.addFirst(dualValue);
            }
            if (visited.contains(dualValue = new DualValue(path, entry1.getValue(), entry2.getValue()))) continue;
            toCompare.addFirst(dualValue);
        }
        return true;
    }

    private static <K1, V1, K2, V2> boolean compareUnorderedMap(Map<K1, V1> map1, Map<K2, V2> map2, List<String> path, Deque<DualValue> toCompare, Set<DualValue> visited) {
        if (map1.size() != map2.size()) {
            return false;
        }
        HashMap<Integer, Map.Entry<K2, V2>> fastLookup = new HashMap<Integer, Map.Entry<K2, V2>>();
        for (Map.Entry<K2, V2> entry : map2.entrySet()) {
            fastLookup.put(RecursiveComparisonDifferenceCalculator.deepHashCode(entry.getKey()), entry);
        }
        for (Map.Entry<Object, Object> entry : map1.entrySet()) {
            Map.Entry other = (Map.Entry)fastLookup.get(RecursiveComparisonDifferenceCalculator.deepHashCode(entry.getKey()));
            if (other == null) {
                return false;
            }
            DualValue dualValue = new DualValue(path, entry.getKey(), other.getKey());
            if (!visited.contains(dualValue)) {
                toCompare.addFirst(dualValue);
            }
            if (visited.contains(dualValue = new DualValue(path, entry.getValue(), other.getValue()))) continue;
            toCompare.addFirst(dualValue);
        }
        return true;
    }

    static boolean hasCustomEquals(Class<?> c) {
        if (customEquals.containsKey(c)) {
            return customEquals.get(c);
        }
        Class<?> origClass = c;
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("equals", Object.class);
                customEquals.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customEquals.put(origClass, false);
        return false;
    }

    static int deepHashCode(Object obj) {
        HashSet<Object> visited = new HashSet<Object>();
        LinkedList<Object> stack = new LinkedList<Object>();
        stack.addFirst(obj);
        int hash = 0;
        while (!stack.isEmpty()) {
            obj = stack.removeFirst();
            if (obj == null || visited.contains(obj)) continue;
            visited.add(obj);
            if (obj.getClass().isArray()) {
                int len = Array.getLength(obj);
                for (int i = 0; i < len; ++i) {
                    stack.addFirst(Array.get(obj, i));
                }
                continue;
            }
            if (obj instanceof Collection) {
                stack.addAll(0, (Collection)obj);
                continue;
            }
            if (obj instanceof Map) {
                stack.addAll(0, ((Map)obj).keySet());
                stack.addAll(0, ((Map)obj).values());
                continue;
            }
            if (obj instanceof Double || obj instanceof Float) {
                stack.add(Math.round(((Number)obj).doubleValue()));
                continue;
            }
            if (RecursiveComparisonDifferenceCalculator.hasCustomHashCode(obj.getClass())) {
                hash += obj.hashCode();
                continue;
            }
            Set<Field> fields = Objects.getDeclaredFieldsIncludingInherited(obj.getClass());
            for (Field field : fields) {
                stack.addFirst(PropertyOrFieldSupport.COMPARISON.getSimpleValue(field.getName(), obj));
            }
        }
        return hash;
    }

    static boolean hasCustomHashCode(Class<?> c) {
        Class<?> origClass = c;
        if (customHash.containsKey(c)) {
            return customHash.get(c);
        }
        while (!Object.class.equals(c)) {
            try {
                c.getDeclaredMethod("hashCode", new Class[0]);
                customHash.put(origClass, true);
                return true;
            }
            catch (Exception exception) {
                c = c.getSuperclass();
            }
        }
        customHash.put(origClass, false);
        return false;
    }

    private static boolean propertyOrFieldValuesAreEqual(Object actualFieldValue, Object otherFieldValue, String fieldName, RecursiveComparisonConfiguration recursiveComparisonConfiguration) {
        if (actualFieldValue == otherFieldValue) {
            return true;
        }
        Comparator<?> fieldComparator = recursiveComparisonConfiguration.getComparatorForField(fieldName);
        if (fieldComparator != null) {
            return fieldComparator.compare(actualFieldValue, otherFieldValue) == 0;
        }
        Class<?> fieldType = actualFieldValue != null ? actualFieldValue.getClass() : otherFieldValue.getClass();
        Comparator<?> typeComparator = recursiveComparisonConfiguration.getComparatorForType(fieldType);
        if (typeComparator != null) {
            return typeComparator.compare(actualFieldValue, otherFieldValue) == 0;
        }
        return org.assertj.core.util.Objects.areEqual(actualFieldValue, otherFieldValue);
    }

    private static ComparisonDifference expectedAndActualTypeDifference(Object actual, Object expected) {
        String additionalInformation = String.format("actual and expected are considered different since the comparison enforces strict type check and expected type %s is not a subtype of actual type %s", expected.getClass().getName(), actual.getClass().getName());
        return ComparisonDifference.rootComparisonDifference(actual, expected, additionalInformation);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(DualValue dualField) {
        return RecursiveComparisonDifferenceCalculator.expectedTypeIsNotSubtypeOfActualType(dualField.actual, dualField.expected);
    }

    private static boolean expectedTypeIsNotSubtypeOfActualType(Object actual, Object expected) {
        return !actual.getClass().isAssignableFrom(expected.getClass());
    }
}

