/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.util.ArrayFormatter;
import org.assertj.core.util.Preconditions;

public class Arrays {
    private static final ArrayFormatter FORMATTER = new ArrayFormatter();

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || !Arrays.hasElements(array);
    }

    public static <T> T[] array(T ... values) {
        return values;
    }

    public static String format(Object array) {
        return FORMATTER.format(array);
    }

    public static <T> List<T> nonNullElementsIn(T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        for (T o : array) {
            if (o == null) continue;
            nonNullElements.add(o);
        }
        return nonNullElements;
    }

    public static <T> boolean hasOnlyNullElements(T[] array) {
        Preconditions.checkNotNull(array);
        if (!Arrays.hasElements(array)) {
            return false;
        }
        for (T o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    private static <T> boolean hasElements(T[] array) {
        return array.length > 0;
    }

    private Arrays() {
    }
}

