/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.error.ConditionAndGroupGenericParameterTypeShouldBeTheSame;
import org.assertj.core.error.ElementsShouldBe;
import org.assertj.core.error.ElementsShouldBeAtLeast;
import org.assertj.core.error.ElementsShouldBeExactly;
import org.assertj.core.error.ElementsShouldHave;
import org.assertj.core.error.ElementsShouldHaveAtLeast;
import org.assertj.core.error.ElementsShouldHaveAtMost;
import org.assertj.core.error.ElementsShouldHaveExactly;
import org.assertj.core.error.ElementsShouldNotBe;
import org.assertj.core.error.ElementsShouldNotBeAtLeast;
import org.assertj.core.error.ElementsShouldNotBeAtMost;
import org.assertj.core.error.ElementsShouldNotBeExactly;
import org.assertj.core.error.ElementsShouldNotHave;
import org.assertj.core.error.ElementsShouldNotHaveAtLeast;
import org.assertj.core.error.ElementsShouldNotHaveAtMost;
import org.assertj.core.error.ElementsShouldNotHaveExactly;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldBeSubsetOf;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainExactly;
import org.assertj.core.error.ShouldContainNull;
import org.assertj.core.error.ShouldContainOnly;
import org.assertj.core.error.ShouldContainSequence;
import org.assertj.core.error.ShouldEndWith;
import org.assertj.core.error.ShouldHaveSameSizeAs;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.error.ShouldNotContainNull;
import org.assertj.core.error.ShouldNotHaveDuplicates;
import org.assertj.core.error.ShouldStartWith;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Conditions;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Lists;
import org.assertj.core.util.VisibleForTesting;

public class Iterables {
    private static final Iterables INSTANCE = new Iterables();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();
    @VisibleForTesting
    Conditions conditions = Conditions.instance();

    public static Iterables instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Iterables() {
        this(StandardComparisonStrategy.instance());
    }

    public Iterables(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        if (this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy) {
            return ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator();
        }
        return null;
    }

    public void assertNullOrEmpty(AssertionInfo info, Iterable<?> actual) {
        if (actual == null || org.assertj.core.util.Iterables.isNullOrEmpty(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeNullOrEmpty.shouldBeNullOrEmpty(actual));
    }

    public void assertEmpty(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (org.assertj.core.util.Iterables.isNullOrEmpty(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEmpty.shouldBeEmpty(actual));
    }

    public void assertNotEmpty(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (!org.assertj.core.util.Iterables.isNullOrEmpty(actual)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEmpty.shouldNotBeEmpty());
    }

    public void assertHasSize(AssertionInfo info, Iterable<?> actual, int expectedSize) {
        this.assertNotNull(info, actual);
        int sizeOfActual = org.assertj.core.util.Iterables.sizeOf(actual);
        if (sizeOfActual == expectedSize) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSize.shouldHaveSize(actual, sizeOfActual, expectedSize));
    }

    public void assertHasSameSizeAs(AssertionInfo info, Iterable<?> actual, Object[] other) {
        this.assertNotNull(info, actual);
        CommonValidations.checkIsNotNull(other);
        int sizeOfActual = org.assertj.core.util.Iterables.sizeOf(actual);
        int sizeOfOther = other.length;
        if (sizeOfActual == sizeOfOther) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(actual, sizeOfActual, sizeOfOther));
    }

    public void assertHasSameSizeAs(AssertionInfo info, Iterable<?> actual, Iterable<?> other) {
        this.assertNotNull(info, actual);
        Iterables.checkNotNull(info, other);
        int sizeOfActual = org.assertj.core.util.Iterables.sizeOf(actual);
        int sizeOfOther = org.assertj.core.util.Iterables.sizeOf(other);
        if (sizeOfActual == sizeOfOther) {
            return;
        }
        throw this.failures.failure(info, ShouldHaveSameSizeAs.shouldHaveSameSizeAs(actual, sizeOfActual, sizeOfOther));
    }

    public void assertContains(AssertionInfo info, Iterable<?> actual, Object[] values) {
        CommonValidations.checkIsNotNull(values);
        this.assertNotNull(info, actual);
        if (!actual.iterator().hasNext() && values.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty(values);
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object value : values) {
            if (this.iterableContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContain.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    private boolean iterableContains(Iterable<?> actual, Object value) {
        return this.comparisonStrategy.iterableContains(actual, value);
    }

    private void iterableRemoves(Iterable<?> actual, Object value) {
        this.comparisonStrategy.iterableRemoves(actual, value);
    }

    public void assertContainsOnly(AssertionInfo info, Iterable<?> actual, Object[] values) {
        CommonValidations.checkIsNotNull(values);
        this.assertNotNull(info, actual);
        if (!actual.iterator().hasNext() && values.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty(values);
        Set<Object> notExpected = this.setFromIterable(actual);
        Set<Object> notFound = this.containsOnly(notExpected, values);
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContainOnly.shouldContainOnly(actual, values, notFound, notExpected, this.comparisonStrategy));
    }

    private Set<Object> containsOnly(Set<Object> actual, Object[] values) {
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object o : this.set(values)) {
            if (this.iterableContains(actual, o)) {
                this.iterableRemoves(actual, o);
                continue;
            }
            notFound.add(o);
        }
        return notFound;
    }

    private Set<Object> set(Object ... elements) {
        if (elements == null) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object e : elements) {
            if (this.iterableContains(set, e)) continue;
            set.add(e);
        }
        return set;
    }

    private Set<Object> setFromIterable(Iterable<?> iterable) {
        if (iterable == null) {
            return null;
        }
        HashSet<Object> set = new HashSet<Object>();
        for (Object e : iterable) {
            if (this.iterableContains(set, e)) continue;
            set.add(e);
        }
        return set;
    }

    public void assertContainsSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        CommonValidations.checkIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!actual.iterator().hasNext() && sequence.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty(sequence);
        ArrayList<?> actualAsList = Lists.newArrayList(actual);
        for (int i = 0; i < actualAsList.size(); ++i) {
            if (!this.containsSequenceAtGivenIndex(actualAsList, sequence, i)) continue;
            return;
        }
        throw this.actualDoesNotContainSequence(info, actual, sequence);
    }

    public void assertIsSubsetOf(AssertionInfo info, Iterable<?> actual, Iterable<?> values) {
        this.assertNotNull(info, actual);
        Iterables.checkNotNull(info, values);
        ArrayList<Object> extra = Lists.newArrayList(new Object[0]);
        for (Object actualElement : actual) {
            if (this.iterableContains(values, actualElement)) continue;
            extra.add(actualElement);
        }
        if (extra.size() > 0) {
            throw this.actualIsNotSubsetOfSet(info, actual, values, extra);
        }
    }

    private static void checkNotNull(AssertionInfo info, Iterable<?> set) {
        if (set == null) {
            throw Iterables.iterableToLookForIsNull();
        }
    }

    private AssertionError actualIsNotSubsetOfSet(AssertionInfo info, Object actual, Iterable<?> set, Iterable<?> extra) {
        return this.failures.failure(info, ShouldBeSubsetOf.shouldBeSubsetOf(actual, set, extra, this.comparisonStrategy));
    }

    private boolean containsSequenceAtGivenIndex(List<?> actualAsList, Object[] sequence, int startingIndex) {
        if (actualAsList.size() - startingIndex < sequence.length) {
            return false;
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (this.areEqual(actualAsList.get(startingIndex + i), sequence[i])) continue;
            return false;
        }
        return true;
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    private AssertionError actualDoesNotContainSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        return this.failures.failure(info, ShouldContainSequence.shouldContainSequence(actual, sequence, this.comparisonStrategy));
    }

    public void assertDoesNotContain(AssertionInfo info, Iterable<?> actual, Object[] values) {
        CommonValidations.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        LinkedHashSet<Object> found = new LinkedHashSet<Object>();
        for (Object o : values) {
            if (!this.iterableContains(actual, o)) continue;
            found.add(o);
        }
        if (found.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldNotContain.shouldNotContain(actual, values, found, this.comparisonStrategy));
    }

    public <T> void assertDoesNotContainAnyElementsOf(AssertionInfo info, Iterable<T> actual, Iterable<? extends T> iterable) {
        CommonValidations.checkIsNotNullAndNotEmpty(iterable);
        ArrayList<T> values = Lists.newArrayList(iterable);
        this.assertDoesNotContain(info, actual, values.toArray());
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        Iterable<?> duplicates = this.comparisonStrategy.duplicatesFrom(actual);
        if (org.assertj.core.util.Iterables.isNullOrEmpty(duplicates)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotHaveDuplicates.shouldNotHaveDuplicates(actual, duplicates, this.comparisonStrategy));
    }

    public void assertStartsWith(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        CommonValidations.checkIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!actual.iterator().hasNext() && sequence.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty(sequence);
        int sequenceSize = sequence.length;
        if (org.assertj.core.util.Iterables.sizeOf(actual) < sequenceSize) {
            throw this.actualDoesNotStartWithSequence(info, actual, sequence);
        }
        int i = 0;
        for (Object o : actual) {
            if (i >= sequenceSize) break;
            if (this.areEqual(o, sequence[i++])) continue;
            throw this.actualDoesNotStartWithSequence(info, actual, sequence);
        }
    }

    private AssertionError actualDoesNotStartWithSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        return this.failures.failure(info, ShouldStartWith.shouldStartWith(actual, sequence, this.comparisonStrategy));
    }

    public void assertEndsWith(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        CommonValidations.checkIsNotNull(sequence);
        this.assertNotNull(info, actual);
        if (!actual.iterator().hasNext() && sequence.length == 0) {
            return;
        }
        CommonValidations.failIfEmptySinceActualIsNotEmpty(sequence);
        int sequenceSize = sequence.length;
        int sizeOfActual = org.assertj.core.util.Iterables.sizeOf(actual);
        if (sizeOfActual < sequenceSize) {
            throw this.actualDoesNotEndWithSequence(info, actual, sequence);
        }
        int start = sizeOfActual - sequenceSize;
        int sequenceIndex = 0;
        int indexOfActual = 0;
        for (Object o : actual) {
            if (indexOfActual++ < start || this.areEqual(o, sequence[sequenceIndex++])) continue;
            throw this.actualDoesNotEndWithSequence(info, actual, sequence);
        }
    }

    public void assertContainsNull(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (!this.iterableContains(actual, null)) {
            throw this.failures.failure(info, ShouldContainNull.shouldContainNull(actual));
        }
    }

    public void assertDoesNotContainNull(AssertionInfo info, Iterable<?> actual) {
        this.assertNotNull(info, actual);
        if (this.iterableContains(actual, null)) {
            throw this.failures.failure(info, ShouldNotContainNull.shouldNotContainNull(actual));
        }
    }

    public <E> void assertAre(AssertionInfo info, Iterable<? extends E> actual, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldBe.elementsShouldBe(actual, notSatisfiesCondition, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreNot(AssertionInfo info, Iterable<? extends E> actual, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotBe.elementsShouldNotBe(actual, satisfiesCondition, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertHave(AssertionInfo info, Iterable<? extends E> actual, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldHave.elementsShouldHave(actual, notSatisfiesCondition, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertDoNotHave(AssertionInfo info, Iterable<? extends E> actual, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.isEmpty()) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotHave.elementsShouldNotHave(actual, satisfiesCondition, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreAtLeast(AssertionInfo info, Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.size() >= n) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldBeAtLeast.elementsShouldBeAtLeast(actual, n, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreNotAtLeast(AssertionInfo info, Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.size() >= n) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotBeAtLeast.elementsShouldNotBeAtLeast(actual, n, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreAtMost(AssertionInfo info, Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.size() <= n) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotBeAtMost.elementsShouldNotBeAtMost(actual, n, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreNotAtMost(AssertionInfo info, Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.size() <= n) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotBeAtMost.elementsShouldNotBeAtMost(actual, n, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreExactly(AssertionInfo info, Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.size() == n) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldBeExactly.elementsShouldBeExactly(actual, n, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertAreNotExactly(AssertionInfo info, Iterable<? extends E> actual, int n, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.size() == n) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotBeExactly.elementsShouldNotBeExactly(actual, n, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertHaveAtLeast(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.size() >= times) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldHaveAtLeast.elementsShouldHaveAtLeast(actual, times, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertDoNotHaveAtLeast(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.size() >= times) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotHaveAtLeast.elementsShouldNotHaveAtLeast(actual, times, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertHaveAtMost(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.size() <= times) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldHaveAtMost.elementsShouldHaveAtMost(actual, times, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertDoNotHaveAtMost(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.size() <= times) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotHaveAtMost.elementsShouldNotHaveAtMost(actual, times, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertHaveExactly(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> satisfiesCondition = this.satisfiesCondition(actual, condition);
            if (satisfiesCondition.size() == times) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldHaveExactly.elementsShouldHaveExactly(actual, times, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public <E> void assertDoNotHaveExactly(AssertionInfo info, Iterable<? extends E> actual, int times, Condition<? super E> condition) {
        this.assertNotNull(info, actual);
        this.conditions.assertIsNotNull(condition);
        try {
            List<E> notSatisfiesCondition = this.notSatisfiesCondition(actual, condition);
            if (notSatisfiesCondition.size() == times) {
                return;
            }
            throw this.failures.failure(info, ElementsShouldNotHaveExactly.elementsShouldNotHaveExactly(actual, times, condition));
        }
        catch (ClassCastException e) {
            throw this.failures.failure(info, ConditionAndGroupGenericParameterTypeShouldBeTheSame.shouldBeSameGenericBetweenIterableAndCondition(actual, condition));
        }
    }

    public void assertContainsAll(AssertionInfo info, Iterable<?> actual, Iterable<?> other) {
        if (other == null) {
            throw Iterables.iterableToLookForIsNull();
        }
        this.assertNotNull(info, actual);
        Object[] values = Lists.newArrayList(other).toArray();
        LinkedHashSet<Object> notFound = new LinkedHashSet<Object>();
        for (Object value : values) {
            if (this.iterableContains(actual, value)) continue;
            notFound.add(value);
        }
        if (notFound.isEmpty()) {
            return;
        }
        throw this.failures.failure(info, ShouldContain.shouldContain(actual, values, notFound, this.comparisonStrategy));
    }

    public void assertContainsExactly(AssertionInfo info, Iterable<?> actual, Object[] values) {
        CommonValidations.checkIsNotNull(values);
        this.assertHasSameSizeAs(info, actual, values);
        Set<Object> notExpected = this.setFromIterable(actual);
        Set<Object> notFound = this.containsOnly(notExpected, values);
        if (notExpected.isEmpty() && notFound.isEmpty()) {
            int i = 0;
            for (Object elementFromActual : actual) {
                if (!this.areEqual(elementFromActual, values[i])) {
                    throw this.failures.failure(info, ShouldContainExactly.shouldContainExactly(elementFromActual, values[i], i, this.comparisonStrategy));
                }
                ++i;
            }
            return;
        }
        throw this.failures.failure(info, ShouldContainExactly.shouldContainExactly(actual, values, notFound, notExpected, this.comparisonStrategy));
    }

    private void assertNotNull(AssertionInfo info, Iterable<?> actual) {
        Objects.instance().assertNotNull(info, actual);
    }

    private AssertionError actualDoesNotEndWithSequence(AssertionInfo info, Iterable<?> actual, Object[] sequence) {
        return this.failures.failure(info, ShouldEndWith.shouldEndWith(actual, sequence, this.comparisonStrategy));
    }

    private <E> List<E> notSatisfiesCondition(Iterable<? extends E> actual, Condition<? super E> condition) {
        LinkedList<E> notSatisfiesCondition = new LinkedList<E>();
        for (E o : actual) {
            if (condition.matches(o)) continue;
            notSatisfiesCondition.add(o);
        }
        return notSatisfiesCondition;
    }

    private <E> List<E> satisfiesCondition(Iterable<? extends E> actual, Condition<? super E> condition) {
        LinkedList<E> satisfiesCondition = new LinkedList<E>();
        for (E o : actual) {
            if (!condition.matches(o)) continue;
            satisfiesCondition.add(o);
        }
        return satisfiesCondition;
    }

    public static NullPointerException iterableToLookForIsNull() {
        return new NullPointerException("The iterable to look for should not be null");
    }

    public static IllegalArgumentException iterableToLookForIsEmpty() {
        return new IllegalArgumentException("The iterable to look for should not be empty");
    }
}

