/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Offset;
import org.assertj.core.error.ShouldBeEqualWithinOffset;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.RealNumbers;
import org.assertj.core.util.Objects;
import org.assertj.core.util.VisibleForTesting;

public class Floats
extends RealNumbers<Float> {
    private static final Floats INSTANCE = new Floats();

    public static Floats instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Floats() {
    }

    public Floats(ComparisonStrategy comparisonStrategy) {
        super(comparisonStrategy);
    }

    @Override
    protected Float zero() {
        return Float.valueOf(0.0f);
    }

    @Override
    protected Float NaN() {
        return Float.valueOf(Float.NaN);
    }

    @Override
    protected boolean isEqualTo(Float actual, Float expected, Offset<?> offset) {
        return Math.abs(expected.floatValue() - actual.floatValue()) <= ((Number)offset.value).floatValue();
    }

    public void assertEqual(AssertionInfo info, Float actual, Float expected, Offset<Float> offset) {
        Floats.assertNotNull(info, actual);
        CommonValidations.checkOffsetIsNotNull(offset);
        CommonValidations.checkNumberIsNotNull(expected);
        if (Objects.areEqual(actual, expected)) {
            return;
        }
        if (this.isEqualTo(actual, expected, offset)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqualWithinOffset.shouldBeEqual(actual, expected, offset, Float.valueOf(Math.abs(expected.floatValue() - actual.floatValue()))));
    }
}

