/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.FloatingPointNumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Floats;
import org.assertj.core.util.VisibleForTesting;

public class FloatAssert
extends AbstractComparableAssert<FloatAssert, Float>
implements FloatingPointNumberAssert<Float> {
    @VisibleForTesting
    Floats floats = Floats.instance();

    protected FloatAssert(Float actual) {
        super(actual, FloatAssert.class);
    }

    public FloatAssert isNaN() {
        this.floats.assertIsNaN(this.info, (Comparable)this.actual);
        return this;
    }

    public FloatAssert isNotNaN() {
        this.floats.assertIsNotNaN(this.info, (Comparable)this.actual);
        return this;
    }

    public FloatAssert isZero() {
        this.floats.assertIsZero(this.info, (Comparable)this.actual);
        return this;
    }

    public FloatAssert isNotZero() {
        this.floats.assertIsNotZero(this.info, (Comparable)this.actual);
        return this;
    }

    public FloatAssert isPositive() {
        this.floats.assertIsPositive(this.info, (Comparable)this.actual);
        return this;
    }

    public FloatAssert isNegative() {
        this.floats.assertIsNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public FloatAssert isNotNegative() {
        this.floats.assertIsNotNegative(this.info, (Comparable)this.actual);
        return this;
    }

    public FloatAssert isNotPositive() {
        this.floats.assertIsNotPositive(this.info, (Comparable)this.actual);
        return this;
    }

    @Override
    public FloatAssert isEqualTo(float expected) {
        this.floats.assertEqual(this.info, this.actual, Float.valueOf(expected));
        return this;
    }

    public FloatAssert isEqualTo(Float expected, Offset<Float> offset) {
        this.floats.assertEqual(this.info, (Float)this.actual, expected, offset);
        return this;
    }

    public FloatAssert isEqualTo(float expected, Offset<Float> offset) {
        this.floats.assertEqual(this.info, (Float)this.actual, Float.valueOf(expected), offset);
        return this;
    }

    @Override
    public FloatAssert isNotEqualTo(float other) {
        this.floats.assertNotEqual(this.info, this.actual, Float.valueOf(other));
        return this;
    }

    @Override
    public FloatAssert isLessThan(float other) {
        this.floats.assertLessThan(this.info, (Comparable)this.actual, Float.valueOf(other));
        return this;
    }

    @Override
    public FloatAssert isLessThanOrEqualTo(float other) {
        this.floats.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, Float.valueOf(other));
        return this;
    }

    @Override
    public FloatAssert isGreaterThan(float other) {
        this.floats.assertGreaterThan(this.info, (Comparable)this.actual, Float.valueOf(other));
        return this;
    }

    @Override
    public FloatAssert isGreaterThanOrEqualTo(float other) {
        this.floats.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, Float.valueOf(other));
        return this;
    }

    public FloatAssert isBetween(Float start, Float end) {
        this.floats.assertIsBetween(this.info, (Comparable)this.actual, start, end);
        return this;
    }

    public FloatAssert isStrictlyBetween(Float start, Float end) {
        this.floats.assertIsStrictlyBetween(this.info, (Comparable)this.actual, start, end);
        return this;
    }

    @Override
    public FloatAssert usingComparator(Comparator<? super Float> customComparator) {
        super.usingComparator(customComparator);
        this.floats = new Floats(new ComparatorBasedComparisonStrategy(customComparator));
        return (FloatAssert)this.myself;
    }

    @Override
    public FloatAssert usingDefaultComparator() {
        super.usingDefaultComparator();
        this.floats = Floats.instance();
        return (FloatAssert)this.myself;
    }
}

