/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.aspectj.apache.bcel.classfile.ClassParser;
import org.aspectj.apache.bcel.classfile.JavaClass;
import org.aspectj.asm.AsmManager;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.bridge.WeaveMessage;
import org.aspectj.bridge.context.CompilationAndWeavingContext;
import org.aspectj.bridge.context.ContextToken;
import org.aspectj.util.FileUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AnnotationAJ;
import org.aspectj.weaver.AnnotationOnTypeMunger;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.CustomMungerFactory;
import org.aspectj.weaver.IClassFileProvider;
import org.aspectj.weaver.IWeaveRequestor;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.ReferenceType;
import org.aspectj.weaver.ReferenceTypeDelegate;
import org.aspectj.weaver.ResolvedType;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.UnresolvedType;
import org.aspectj.weaver.WeaverMessages;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelAdvice;
import org.aspectj.weaver.bcel.BcelClassWeaver;
import org.aspectj.weaver.bcel.BcelMethod;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelPerClauseAspectAdder;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.bcel.Utility;
import org.aspectj.weaver.patterns.AndPointcut;
import org.aspectj.weaver.patterns.BindingPattern;
import org.aspectj.weaver.patterns.BindingTypePattern;
import org.aspectj.weaver.patterns.ConcreteCflowPointcut;
import org.aspectj.weaver.patterns.DeclareAnnotation;
import org.aspectj.weaver.patterns.DeclareParents;
import org.aspectj.weaver.patterns.FastMatchInfo;
import org.aspectj.weaver.patterns.IfPointcut;
import org.aspectj.weaver.patterns.KindedPointcut;
import org.aspectj.weaver.patterns.NameBindingPointcut;
import org.aspectj.weaver.patterns.NotPointcut;
import org.aspectj.weaver.patterns.OrPointcut;
import org.aspectj.weaver.patterns.Pointcut;
import org.aspectj.weaver.patterns.PointcutRewriter;
import org.aspectj.weaver.patterns.WithinPointcut;
import org.aspectj.weaver.tools.Trace;
import org.aspectj.weaver.tools.TraceFactory;

public class BcelWeaver {
    public static final String CLOSURE_CLASS_PREFIX = "$Ajc";
    public static final String SYNTHETIC_CLASS_POSTFIX = "$ajc";
    private final BcelWorld world;
    private final CrosscuttingMembersSet xcutSet;
    private boolean inReweavableMode = false;
    private static Trace trace = TraceFactory.getTraceFactory().getTrace(class$org$aspectj$weaver$bcel$BcelWeaver == null ? (class$org$aspectj$weaver$bcel$BcelWeaver = BcelWeaver.class$("org.aspectj.weaver.bcel.BcelWeaver")) : class$org$aspectj$weaver$bcel$BcelWeaver);
    private List addedClasses = new ArrayList();
    private List deletedTypenames = new ArrayList();
    private Manifest manifest = null;
    private boolean needToReweaveWorld = false;
    private boolean isBatchWeave = true;
    private List shadowMungerList = null;
    private List typeMungerList = null;
    private List lateTypeMungerList = null;
    private List declareParentsList = null;
    private ZipOutputStream zipOutputStream;
    private CustomMungerFactory customMungerFactory;
    private static final String WEAVER_MANIFEST_VERSION = "1.0";
    private static final Attributes.Name CREATED_BY = new Attributes.Name("Created-By");
    private static final String WEAVER_CREATED_BY = "AspectJ Compiler";
    static /* synthetic */ Class class$org$aspectj$weaver$bcel$BcelWeaver;
    static /* synthetic */ Class class$org$aspectj$weaver$patterns$WithinPointcut;
    static /* synthetic */ Class class$org$aspectj$weaver$patterns$KindedPointcut;

    public BcelWeaver(BcelWorld world) {
        if (trace.isTraceEnabled()) {
            trace.enter("<init>", (Object)this, world);
        }
        this.world = world;
        this.xcutSet = world.getCrosscuttingMembersSet();
        if (trace.isTraceEnabled()) {
            trace.exit("<init>");
        }
    }

    public void setShadowMungers(List l) {
        this.shadowMungerList = l;
    }

    public ResolvedType addLibraryAspect(String aspectName) {
        if (trace.isTraceEnabled()) {
            trace.enter("addLibraryAspect", (Object)this, aspectName);
        }
        UnresolvedType unresolvedT = UnresolvedType.forName(aspectName);
        unresolvedT.setNeedsModifiableDelegate(true);
        ResolvedType type = this.world.resolve(unresolvedT, true);
        if (type.isMissing()) {
            String fixedName = aspectName;
            int hasDot = fixedName.lastIndexOf(46);
            while (hasDot > 0) {
                char[] fixedNameChars = fixedName.toCharArray();
                fixedNameChars[hasDot] = 36;
                fixedName = new String(fixedNameChars);
                hasDot = fixedName.lastIndexOf(46);
                UnresolvedType ut = UnresolvedType.forName(fixedName);
                ut.setNeedsModifiableDelegate(true);
                type = this.world.resolve(ut, true);
                if (type.isMissing()) continue;
                break;
            }
        }
        if (type.isAspect()) {
            WeaverStateInfo wsi = type.getWeaverState();
            if (wsi != null && wsi.isReweavable()) {
                BcelObjectType classType = this.getClassType(type.getName());
                JavaClass wovenJavaClass = classType.getJavaClass();
                JavaClass unwovenJavaClass = Utility.makeJavaClass(wovenJavaClass.getFileName(), wsi.getUnwovenClassFileData(wovenJavaClass.getBytes()));
                this.world.storeClass(unwovenJavaClass);
                classType.setJavaClass(unwovenJavaClass);
            }
            this.xcutSet.addOrReplaceAspect(type);
            if (trace.isTraceEnabled()) {
                trace.exit("addLibraryAspect", type);
            }
            if (type.getSuperclass().isAspect()) {
                this.addLibraryAspect(type.getSuperclass().getName());
            }
            return type;
        }
        RuntimeException ex = new RuntimeException("Cannot register non aspect: " + type.getName() + " , " + aspectName);
        if (trace.isTraceEnabled()) {
            trace.exit("addLibraryAspect", ex);
        }
        throw ex;
    }

    public void addLibraryJarFile(File inFile) throws IOException {
        List addedAspects = null;
        addedAspects = inFile.isDirectory() ? this.addAspectsFromDirectory(inFile) : this.addAspectsFromJarFile(inFile);
        Iterator i = addedAspects.iterator();
        while (i.hasNext()) {
            ResolvedType aspectX = (ResolvedType)i.next();
            this.xcutSet.addOrReplaceAspect(aspectX);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List addAspectsFromJarFile(File inFile) throws FileNotFoundException, IOException {
        ZipInputStream inStream = new ZipInputStream(new FileInputStream(inFile));
        ArrayList<ReferenceType> addedAspects = new ArrayList<ReferenceType>();
        try {
            ZipEntry entry;
            while ((entry = inStream.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
                ClassParser parser = new ClassParser(new ByteArrayInputStream(FileUtil.readAsByteArray(inStream)), entry.getName());
                JavaClass jc = parser.parse();
                inStream.closeEntry();
                ReferenceType type = this.world.addSourceObjectType(jc).getResolvedTypeX();
                type.setBinaryPath(inFile.getAbsolutePath());
                if (!((ResolvedType)type).isAspect()) continue;
                addedAspects.add(type);
            }
        }
        finally {
            inStream.close();
        }
        return addedAspects;
    }

    private List addAspectsFromDirectory(File dir) throws FileNotFoundException, IOException {
        ArrayList addedAspects = new ArrayList();
        File[] classFiles = FileUtil.listFiles(dir, new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".class");
            }
        });
        for (int i = 0; i < classFiles.length; ++i) {
            FileInputStream fis = new FileInputStream(classFiles[i]);
            byte[] bytes = FileUtil.readAsByteArray(fis);
            this.addIfAspect(bytes, classFiles[i].getAbsolutePath(), addedAspects, dir);
            fis.close();
        }
        return addedAspects;
    }

    private void addIfAspect(byte[] bytes, String name, List toList, File dir) throws IOException {
        ClassParser parser = new ClassParser(new ByteArrayInputStream(bytes), name);
        JavaClass jc = parser.parse();
        ReferenceType type = this.world.addSourceObjectType(jc).getResolvedTypeX();
        String typeName = type.getName().replace('.', File.separatorChar);
        int end = name.lastIndexOf(typeName + ".class");
        String binaryPath = null;
        binaryPath = end == -1 ? dir.getAbsolutePath() : name.substring(0, end - 1);
        type.setBinaryPath(binaryPath);
        if (((ResolvedType)type).isAspect()) {
            toList.add(type);
        }
    }

    public List addDirectoryContents(File inFile, File outDir) throws IOException {
        ArrayList<UnwovenClassFile> addedClassFiles = new ArrayList<UnwovenClassFile>();
        File[] files = FileUtil.listFiles(inFile, new FileFilter(){

            public boolean accept(File f) {
                boolean accept = !f.isDirectory();
                return accept;
            }
        });
        for (int i = 0; i < files.length; ++i) {
            addedClassFiles.add(this.addClassFile(files[i], inFile, outDir));
        }
        return addedClassFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List addJarFile(File inFile, File outDir, boolean canBeDirectory) {
        ArrayList<UnwovenClassFile> addedClassFiles;
        block22: {
            Message message;
            addedClassFiles = new ArrayList<UnwovenClassFile>();
            this.needToReweaveWorld = true;
            ZipFile inJar = null;
            try {
                if (inFile.isDirectory() && canBeDirectory) {
                    addedClassFiles.addAll(this.addDirectoryContents(inFile, outDir));
                    break block22;
                }
                inJar = new JarFile(inFile);
                try {
                    this.addManifest(((JarFile)inJar).getManifest());
                    Enumeration<JarEntry> entries = ((JarFile)inJar).entries();
                    while (entries.hasMoreElements()) {
                        JarEntry entry = entries.nextElement();
                        InputStream inStream = ((JarFile)inJar).getInputStream(entry);
                        byte[] bytes = FileUtil.readAsByteArray(inStream);
                        String filename = entry.getName();
                        UnwovenClassFile classFile = new UnwovenClassFile(new File(outDir, filename).getAbsolutePath(), bytes);
                        if (filename.endsWith(".class")) {
                            this.addClassFile(classFile);
                            addedClassFiles.add(classFile);
                        }
                        inStream.close();
                    }
                }
                finally {
                    inJar.close();
                }
                inJar.close();
            }
            catch (FileNotFoundException ex) {
                message = new Message("Could not find input jar file " + inFile.getPath() + ", ignoring", new SourceLocation(inFile, 0), false);
                this.world.getMessageHandler().handleMessage(message);
            }
            catch (IOException ex) {
                Message message2 = new Message("Could not read input jar file " + inFile.getPath() + "(" + ex.getMessage() + ")", new SourceLocation(inFile, 0), true);
                this.world.getMessageHandler().handleMessage(message2);
            }
            finally {
                if (inJar != null) {
                    try {
                        inJar.close();
                    }
                    catch (IOException ex) {
                        message = new Message("Could not close input jar file " + inFile.getPath() + "(" + ex.getMessage() + ")", new SourceLocation(inFile, 0), true);
                        this.world.getMessageHandler().handleMessage(message);
                    }
                }
            }
        }
        return addedClassFiles;
    }

    public boolean needToReweaveWorld() {
        return this.needToReweaveWorld;
    }

    public void addClassFile(UnwovenClassFile classFile) {
        this.addedClasses.add(classFile);
        this.world.addSourceObjectType(classFile.getJavaClass());
    }

    public UnwovenClassFile addClassFile(File classFile, File inPathDir, File outDir) throws IOException {
        FileInputStream fis = new FileInputStream(classFile);
        byte[] bytes = FileUtil.readAsByteArray(fis);
        String filename = classFile.getAbsolutePath().substring(inPathDir.getAbsolutePath().length() + 1);
        UnwovenClassFile ucf = new UnwovenClassFile(new File(outDir, filename).getAbsolutePath(), bytes);
        if (filename.endsWith(".class")) {
            this.addClassFile(ucf);
        }
        fis.close();
        return ucf;
    }

    public void deleteClassFile(String typename) {
        this.deletedTypenames.add(typename);
        this.world.deleteSourceObjectType(UnresolvedType.forName(typename));
    }

    public void setIsBatchWeave(boolean b) {
        this.isBatchWeave = b;
    }

    public void prepareForWeave() {
        if (trace.isTraceEnabled()) {
            trace.enter("prepareForWeave", this);
        }
        this.needToReweaveWorld = this.xcutSet.hasChangedSinceLastReset();
        Iterator i = this.addedClasses.iterator();
        while (i.hasNext()) {
            UnwovenClassFile jc = (UnwovenClassFile)i.next();
            String name = jc.getClassName();
            ResolvedType type = this.world.resolve(name);
            if (!type.isAspect()) continue;
            this.needToReweaveWorld |= this.xcutSet.addOrReplaceAspect(type);
        }
        i = this.deletedTypenames.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            if (!this.xcutSet.deleteAspect(UnresolvedType.forName(name))) continue;
            this.needToReweaveWorld = true;
        }
        this.shadowMungerList = this.xcutSet.getShadowMungers();
        this.rewritePointcuts(this.shadowMungerList);
        this.typeMungerList = this.xcutSet.getTypeMungers();
        this.lateTypeMungerList = this.xcutSet.getLateTypeMungers();
        this.declareParentsList = this.xcutSet.getDeclareParents();
        this.addCustomMungers();
        Collections.sort(this.shadowMungerList, new Comparator(){

            public int compare(Object o1, Object o2) {
                ShadowMunger sm1 = (ShadowMunger)o1;
                ShadowMunger sm2 = (ShadowMunger)o2;
                if (sm1.getSourceLocation() == null) {
                    return sm2.getSourceLocation() == null ? 0 : 1;
                }
                if (sm2.getSourceLocation() == null) {
                    return -1;
                }
                return sm2.getSourceLocation().getOffset() - sm1.getSourceLocation().getOffset();
            }
        });
        if (this.inReweavableMode) {
            this.world.showMessage(IMessage.INFO, WeaverMessages.format("reweavableMode"), null, null);
        }
        if (trace.isTraceEnabled()) {
            trace.exit("prepareForWeave");
        }
    }

    private void addCustomMungers() {
        if (this.customMungerFactory != null) {
            Iterator i = this.addedClasses.iterator();
            while (i.hasNext()) {
                Collection typeMungers;
                UnwovenClassFile jc = (UnwovenClassFile)i.next();
                String name = jc.getClassName();
                ResolvedType type = this.world.resolve(name);
                if (!type.isAspect()) continue;
                Collection shadowMungers = this.customMungerFactory.createCustomShadowMungers(type);
                if (shadowMungers != null) {
                    this.shadowMungerList.addAll(shadowMungers);
                }
                if ((typeMungers = this.customMungerFactory.createCustomTypeMungers(type)) == null) continue;
                this.typeMungerList.addAll(typeMungers);
            }
        }
    }

    public void setCustomMungerFactory(CustomMungerFactory factory) {
        this.customMungerFactory = factory;
    }

    private void rewritePointcuts(List shadowMungers) {
        PointcutRewriter rewriter = new PointcutRewriter();
        Iterator iter = shadowMungers.iterator();
        while (iter.hasNext()) {
            Advice advice;
            ShadowMunger munger = (ShadowMunger)iter.next();
            Pointcut p = munger.getPointcut();
            Pointcut newP = rewriter.rewrite(p);
            if (munger instanceof Advice && (advice = (Advice)munger).getSignature() != null) {
                String[] names;
                int numFormals;
                if (advice.getConcreteAspect().isAnnotationStyleAspect() && advice.getDeclaringAspect() != null && advice.getDeclaringAspect().resolve(this.world).isAnnotationStyleAspect()) {
                    numFormals = advice.getBaseParameterCount();
                    int numArgs = advice.getSignature().getParameterTypes().length;
                    if (numFormals > 0) {
                        names = advice.getSignature().getParameterNames(this.world);
                        this.validateBindings(newP, p, numArgs, names);
                    }
                } else {
                    numFormals = advice.getBaseParameterCount();
                    if (numFormals > 0) {
                        names = advice.getBaseParameterNames(this.world);
                        this.validateBindings(newP, p, numFormals, names);
                    }
                }
            }
            munger.setPointcut(newP);
        }
        HashMap pcMap = new HashMap();
        Iterator iter2 = shadowMungers.iterator();
        while (iter2.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter2.next();
            Pointcut p = munger.getPointcut();
            munger.setPointcut(this.shareEntriesFromMap(p, pcMap));
        }
    }

    private Pointcut shareEntriesFromMap(Pointcut p, Map pcMap) {
        if (p instanceof NameBindingPointcut) {
            return p;
        }
        if (p instanceof IfPointcut) {
            return p;
        }
        if (p instanceof ConcreteCflowPointcut) {
            return p;
        }
        if (p instanceof AndPointcut) {
            AndPointcut apc = (AndPointcut)p;
            Pointcut left = this.shareEntriesFromMap(apc.getLeft(), pcMap);
            Pointcut right = this.shareEntriesFromMap(apc.getRight(), pcMap);
            return new AndPointcut(left, right);
        }
        if (p instanceof OrPointcut) {
            OrPointcut opc = (OrPointcut)p;
            Pointcut left = this.shareEntriesFromMap(opc.getLeft(), pcMap);
            Pointcut right = this.shareEntriesFromMap(opc.getRight(), pcMap);
            return new OrPointcut(left, right);
        }
        if (p instanceof NotPointcut) {
            NotPointcut npc = (NotPointcut)p;
            Pointcut not = this.shareEntriesFromMap(npc.getNegatedPointcut(), pcMap);
            return new NotPointcut(not);
        }
        if (pcMap.containsKey(p)) {
            return (Pointcut)pcMap.get(p);
        }
        pcMap.put(p, p);
        return p;
    }

    private void validateBindings(Pointcut dnfPointcut, Pointcut userPointcut, int numFormals, String[] names) {
        if (numFormals == 0) {
            return;
        }
        if (dnfPointcut.couldMatchKinds() == Shadow.NO_SHADOW_KINDS_BITS) {
            return;
        }
        if (dnfPointcut instanceof OrPointcut) {
            OrPointcut orBasedDNFPointcut = (OrPointcut)dnfPointcut;
            Pointcut[] leftBindings = new Pointcut[numFormals];
            Pointcut[] rightBindings = new Pointcut[numFormals];
            this.validateOrBranch(orBasedDNFPointcut, userPointcut, numFormals, names, leftBindings, rightBindings);
        } else {
            Pointcut[] bindings = new Pointcut[numFormals];
            this.validateSingleBranch(dnfPointcut, userPointcut, numFormals, names, bindings);
        }
    }

    private void validateOrBranch(OrPointcut pc, Pointcut userPointcut, int numFormals, String[] names, Pointcut[] leftBindings, Pointcut[] rightBindings) {
        Pointcut left = pc.getLeft();
        Pointcut right = pc.getRight();
        if (left instanceof OrPointcut) {
            Pointcut[] newRightBindings = new Pointcut[numFormals];
            this.validateOrBranch((OrPointcut)left, userPointcut, numFormals, names, leftBindings, newRightBindings);
        } else if (left.couldMatchKinds() != Shadow.NO_SHADOW_KINDS_BITS) {
            this.validateSingleBranch(left, userPointcut, numFormals, names, leftBindings);
        }
        if (right instanceof OrPointcut) {
            Pointcut[] newLeftBindings = new Pointcut[numFormals];
            this.validateOrBranch((OrPointcut)right, userPointcut, numFormals, names, newLeftBindings, rightBindings);
        } else if (right.couldMatchKinds() != Shadow.NO_SHADOW_KINDS_BITS) {
            this.validateSingleBranch(right, userPointcut, numFormals, names, rightBindings);
        }
        int kindsInCommon = left.couldMatchKinds() & right.couldMatchKinds();
        if (kindsInCommon != Shadow.NO_SHADOW_KINDS_BITS && this.couldEverMatchSameJoinPoints(left, right)) {
            ArrayList<String> ambiguousNames = new ArrayList<String>();
            for (int i = 0; i < numFormals; ++i) {
                if (leftBindings[i] == null) {
                    if (rightBindings[i] == null) continue;
                    ambiguousNames.add(names[i]);
                    continue;
                }
                if (leftBindings[i].equals(rightBindings[i])) continue;
                ambiguousNames.add(names[i]);
            }
            if (!ambiguousNames.isEmpty()) {
                this.raiseAmbiguityInDisjunctionError(userPointcut, ambiguousNames);
            }
        }
    }

    private void validateSingleBranch(Pointcut pc, Pointcut userPointcut, int numFormals, String[] names, Pointcut[] bindings) {
        int i;
        boolean[] foundFormals = new boolean[numFormals];
        for (i = 0; i < foundFormals.length; ++i) {
            foundFormals[i] = false;
        }
        this.validateSingleBranchRecursion(pc, userPointcut, foundFormals, names, bindings);
        for (i = 0; i < foundFormals.length; ++i) {
            if (foundFormals[i]) continue;
            boolean ignore = false;
            for (int j = 0; j < userPointcut.m_ignoreUnboundBindingForNames.length; ++j) {
                if (names[i] == null || !names[i].equals(userPointcut.m_ignoreUnboundBindingForNames[j])) continue;
                ignore = true;
                break;
            }
            if (ignore) continue;
            this.raiseUnboundFormalError(names[i], userPointcut);
        }
    }

    private void validateSingleBranchRecursion(Pointcut pc, Pointcut userPointcut, boolean[] foundFormals, String[] names, Pointcut[] bindings) {
        block12: {
            block11: {
                NameBindingPointcut nnbp;
                if (!(pc instanceof NotPointcut)) break block11;
                NotPointcut not = (NotPointcut)pc;
                if (!(not.getNegatedPointcut() instanceof NameBindingPointcut) || (nnbp = (NameBindingPointcut)not.getNegatedPointcut()).getBindingAnnotationTypePatterns().isEmpty() || nnbp.getBindingTypePatterns().isEmpty()) break block12;
                this.raiseNegationBindingError(userPointcut);
                break block12;
            }
            if (pc instanceof AndPointcut) {
                AndPointcut and = (AndPointcut)pc;
                this.validateSingleBranchRecursion(and.getLeft(), userPointcut, foundFormals, names, bindings);
                this.validateSingleBranchRecursion(and.getRight(), userPointcut, foundFormals, names, bindings);
            } else if (pc instanceof NameBindingPointcut) {
                List btps = ((NameBindingPointcut)pc).getBindingTypePatterns();
                Iterator iter = btps.iterator();
                while (iter.hasNext()) {
                    BindingTypePattern btp = (BindingTypePattern)iter.next();
                    int index = btp.getFormalIndex();
                    bindings[index] = pc;
                    if (foundFormals[index]) {
                        this.raiseAmbiguousBindingError(names[index], userPointcut);
                        continue;
                    }
                    foundFormals[index] = true;
                }
                List baps = ((NameBindingPointcut)pc).getBindingAnnotationTypePatterns();
                Iterator iter2 = baps.iterator();
                while (iter2.hasNext()) {
                    BindingPattern bap = (BindingPattern)iter2.next();
                    int index = bap.getFormalIndex();
                    bindings[index] = pc;
                    if (foundFormals[index]) {
                        this.raiseAmbiguousBindingError(names[index], userPointcut);
                        continue;
                    }
                    foundFormals[index] = true;
                }
            } else if (pc instanceof ConcreteCflowPointcut) {
                ConcreteCflowPointcut cfp = (ConcreteCflowPointcut)pc;
                int[] slots = cfp.getUsedFormalSlots();
                for (int i = 0; i < slots.length; ++i) {
                    bindings[slots[i]] = cfp;
                    if (foundFormals[slots[i]]) {
                        this.raiseAmbiguousBindingError(names[slots[i]], userPointcut);
                        continue;
                    }
                    foundFormals[slots[i]] = true;
                }
            }
        }
    }

    private boolean couldEverMatchSameJoinPoints(Pointcut left, Pointcut right) {
        if (left instanceof OrPointcut) {
            OrPointcut leftOrPointcut = (OrPointcut)left;
            if (this.couldEverMatchSameJoinPoints(leftOrPointcut.getLeft(), right)) {
                return true;
            }
            return this.couldEverMatchSameJoinPoints(leftOrPointcut.getRight(), right);
        }
        if (right instanceof OrPointcut) {
            OrPointcut rightOrPointcut = (OrPointcut)right;
            if (this.couldEverMatchSameJoinPoints(left, rightOrPointcut.getLeft())) {
                return true;
            }
            return this.couldEverMatchSameJoinPoints(left, rightOrPointcut.getRight());
        }
        WithinPointcut leftWithin = (WithinPointcut)this.findFirstPointcutIn(left, class$org$aspectj$weaver$patterns$WithinPointcut == null ? (class$org$aspectj$weaver$patterns$WithinPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.WithinPointcut")) : class$org$aspectj$weaver$patterns$WithinPointcut);
        WithinPointcut rightWithin = (WithinPointcut)this.findFirstPointcutIn(right, class$org$aspectj$weaver$patterns$WithinPointcut == null ? (class$org$aspectj$weaver$patterns$WithinPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.WithinPointcut")) : class$org$aspectj$weaver$patterns$WithinPointcut);
        if (leftWithin != null && rightWithin != null && !leftWithin.couldEverMatchSameJoinPointsAs(rightWithin)) {
            return false;
        }
        KindedPointcut leftKind = (KindedPointcut)this.findFirstPointcutIn(left, class$org$aspectj$weaver$patterns$KindedPointcut == null ? (class$org$aspectj$weaver$patterns$KindedPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.KindedPointcut")) : class$org$aspectj$weaver$patterns$KindedPointcut);
        KindedPointcut rightKind = (KindedPointcut)this.findFirstPointcutIn(right, class$org$aspectj$weaver$patterns$KindedPointcut == null ? (class$org$aspectj$weaver$patterns$KindedPointcut = BcelWeaver.class$("org.aspectj.weaver.patterns.KindedPointcut")) : class$org$aspectj$weaver$patterns$KindedPointcut);
        return leftKind == null || rightKind == null || leftKind.couldEverMatchSameJoinPointsAs(rightKind);
    }

    private Pointcut findFirstPointcutIn(Pointcut toSearch, Class toLookFor) {
        if (toSearch instanceof NotPointcut) {
            return null;
        }
        if (toLookFor.isInstance(toSearch)) {
            return toSearch;
        }
        if (toSearch instanceof AndPointcut) {
            AndPointcut apc = (AndPointcut)toSearch;
            Pointcut left = this.findFirstPointcutIn(apc.getLeft(), toLookFor);
            if (left != null) {
                return left;
            }
            return this.findFirstPointcutIn(apc.getRight(), toLookFor);
        }
        return null;
    }

    private void raiseNegationBindingError(Pointcut userPointcut) {
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("negationDoesntAllowBinding"), userPointcut.getSourceContext().makeSourceLocation(userPointcut), null);
    }

    private void raiseAmbiguousBindingError(String name, Pointcut userPointcut) {
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("ambiguousBindingInPC", name), userPointcut.getSourceContext().makeSourceLocation(userPointcut), null);
    }

    private void raiseAmbiguityInDisjunctionError(Pointcut userPointcut, List names) {
        StringBuffer formalNames = new StringBuffer(names.get(0).toString());
        for (int i = 1; i < names.size(); ++i) {
            formalNames.append(", ");
            formalNames.append(names.get(i));
        }
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("ambiguousBindingInOrPC", formalNames), userPointcut.getSourceContext().makeSourceLocation(userPointcut), null);
    }

    private void raiseUnboundFormalError(String name, Pointcut userPointcut) {
        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("unboundFormalInPC", name), userPointcut.getSourceLocation(), null);
    }

    public void addManifest(Manifest newManifest) {
        if (this.manifest == null) {
            this.manifest = newManifest;
        }
    }

    public Manifest getManifest(boolean shouldCreate) {
        if (this.manifest == null && shouldCreate) {
            this.manifest = new Manifest();
            Attributes attributes = this.manifest.getMainAttributes();
            attributes.put(Attributes.Name.MANIFEST_VERSION, WEAVER_MANIFEST_VERSION);
            attributes.put(CREATED_BY, WEAVER_CREATED_BY);
        }
        return this.manifest;
    }

    public Collection weave(File file) throws IOException {
        BufferedOutputStream os = FileUtil.makeOutputStream(file);
        this.zipOutputStream = new ZipOutputStream(os);
        this.prepareForWeave();
        Collection c = this.weave(new IClassFileProvider(){

            public boolean isApplyAtAspectJMungersOnly() {
                return false;
            }

            public Iterator getClassFileIterator() {
                return BcelWeaver.this.addedClasses.iterator();
            }

            public IWeaveRequestor getRequestor() {
                return new IWeaveRequestor(){

                    public void acceptResult(UnwovenClassFile result) {
                        try {
                            BcelWeaver.this.writeZipEntry(result.filename, result.bytes);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }

                    public void processingReweavableState() {
                    }

                    public void addingTypeMungers() {
                    }

                    public void weavingAspects() {
                    }

                    public void weavingClasses() {
                    }

                    public void weaveCompleted() {
                    }
                };
            }
        });
        this.zipOutputStream.close();
        return c;
    }

    public Collection weave(IClassFileProvider input) throws IOException {
        String className;
        UnwovenClassFile classFile;
        Iterator i;
        BcelObjectType classType;
        UnwovenClassFile classFile2;
        if (trace.isTraceEnabled()) {
            trace.enter("weave", (Object)this, input);
        }
        ContextToken weaveToken = CompilationAndWeavingContext.enteringPhase(22, "");
        ArrayList<String> wovenClassNames = new ArrayList<String>();
        IWeaveRequestor requestor = input.getRequestor();
        Iterator i2 = input.getClassFileIterator();
        while (i2.hasNext()) {
            classFile2 = (UnwovenClassFile)i2.next();
            if (!AsmManager.isCreatingModel() || this.isBatchWeave) continue;
            AsmManager.getDefault().removeRelationshipsTargettingThisType(classFile2.getClassName());
        }
        i2 = input.getClassFileIterator();
        while (i2.hasNext()) {
            classFile2 = (UnwovenClassFile)i2.next();
            String className2 = classFile2.getClassName();
            ResolvedType theType = this.world.resolve(className2);
            if (theType == null || (classType = BcelWorld.getBcelObjectType(theType)) == null) continue;
            classType.ensureDelegateConsistent();
        }
        if (input.isApplyAtAspectJMungersOnly()) {
            ContextToken atAspectJMungersOnly = CompilationAndWeavingContext.enteringPhase(32, "");
            requestor.weavingAspects();
            CompilationAndWeavingContext.enteringPhase(25, "");
            i = input.getClassFileIterator();
            while (i.hasNext()) {
                classFile = (UnwovenClassFile)i.next();
                className = classFile.getClassName();
                ResolvedType theType = this.world.resolve(className);
                if (!theType.isAnnotationStyleAspect()) continue;
                BcelObjectType classType2 = BcelWorld.getBcelObjectType(theType);
                if (classType2 == null) {
                    throw new BCException("Can't find bcel delegate for " + className + " type=" + theType.getClass());
                }
                LazyClassGen clazz = classType2.getLazyClassGen();
                BcelPerClauseAspectAdder selfMunger = new BcelPerClauseAspectAdder(theType, theType.getPerClause().getKind());
                selfMunger.forceMunge(clazz, true);
                classType2.finishedWith();
                UnwovenClassFile[] newClasses = this.getClassFilesFor(clazz);
                for (int news = 0; news < newClasses.length; ++news) {
                    requestor.acceptResult(newClasses[news]);
                }
                wovenClassNames.add(classFile.getClassName());
            }
            requestor.weaveCompleted();
            CompilationAndWeavingContext.leavingPhase(atAspectJMungersOnly);
            return wovenClassNames;
        }
        requestor.processingReweavableState();
        ContextToken reweaveToken = CompilationAndWeavingContext.enteringPhase(23, "");
        this.prepareToProcessReweavableState();
        i = input.getClassFileIterator();
        while (i.hasNext()) {
            classFile = (UnwovenClassFile)i.next();
            className = classFile.getClassName();
            classType = this.getClassType(className);
            if (classType == null) continue;
            ContextToken tok = CompilationAndWeavingContext.enteringPhase(23, className);
            this.processReweavableStateIfPresent(className, classType);
            CompilationAndWeavingContext.leavingPhase(tok);
        }
        CompilationAndWeavingContext.leavingPhase(reweaveToken);
        ContextToken typeMungingToken = CompilationAndWeavingContext.enteringPhase(24, "");
        requestor.addingTypeMungers();
        ArrayList<String> typesToProcess = new ArrayList<String>();
        Iterator iter = input.getClassFileIterator();
        while (iter.hasNext()) {
            UnwovenClassFile clf = (UnwovenClassFile)iter.next();
            typesToProcess.add(clf.getClassName());
        }
        while (typesToProcess.size() > 0) {
            this.weaveParentsFor(typesToProcess, (String)typesToProcess.get(0));
        }
        Iterator i3 = input.getClassFileIterator();
        while (i3.hasNext()) {
            UnwovenClassFile classFile3 = (UnwovenClassFile)i3.next();
            String className3 = classFile3.getClassName();
            this.addNormalTypeMungers(className3);
        }
        CompilationAndWeavingContext.leavingPhase(typeMungingToken);
        requestor.weavingAspects();
        ContextToken aspectToken = CompilationAndWeavingContext.enteringPhase(25, "");
        Iterator i4 = input.getClassFileIterator();
        while (i4.hasNext()) {
            UnwovenClassFile classFile4 = (UnwovenClassFile)i4.next();
            String className4 = classFile4.getClassName();
            ResolvedType theType = this.world.resolve(className4);
            if (!theType.isAspect()) continue;
            BcelObjectType classType3 = BcelWorld.getBcelObjectType(theType);
            if (classType3 == null) {
                ReferenceTypeDelegate theDelegate = ((ReferenceType)theType).getDelegate();
                if (theDelegate.getClass().getName().endsWith("EclipseSourceType")) continue;
                throw new BCException("Can't find bcel delegate for " + className4 + " type=" + theType.getClass());
            }
            this.weaveAndNotify(classFile4, classType3, requestor);
            wovenClassNames.add(className4);
        }
        CompilationAndWeavingContext.leavingPhase(aspectToken);
        requestor.weavingClasses();
        ContextToken classToken = CompilationAndWeavingContext.enteringPhase(26, "");
        Iterator i5 = input.getClassFileIterator();
        while (i5.hasNext()) {
            UnwovenClassFile classFile5 = (UnwovenClassFile)i5.next();
            String className5 = classFile5.getClassName();
            ResolvedType theType = this.world.resolve(className5);
            if (theType.isAspect()) continue;
            BcelObjectType classType4 = BcelWorld.getBcelObjectType(theType);
            if (classType4 == null) {
                ReferenceTypeDelegate theDelegate = ((ReferenceType)theType).getDelegate();
                if (theDelegate.getClass().getName().endsWith("EclipseSourceType")) continue;
                throw new BCException("Can't find bcel delegate for " + className5 + " type=" + theType.getClass());
            }
            this.weaveAndNotify(classFile5, classType4, requestor);
            wovenClassNames.add(className5);
        }
        CompilationAndWeavingContext.leavingPhase(classToken);
        this.addedClasses = new ArrayList();
        this.deletedTypenames = new ArrayList();
        requestor.weaveCompleted();
        CompilationAndWeavingContext.leavingPhase(weaveToken);
        if (trace.isTraceEnabled()) {
            trace.exit("weave", wovenClassNames);
        }
        return wovenClassNames;
    }

    public void allWeavingComplete() {
        this.warnOnUnmatchedAdvice();
    }

    private void warnOnUnmatchedAdvice() {
        if (this.world.isInJava5Mode() && this.world.getLint().adviceDidNotMatch.isEnabled()) {
            List l = this.world.getCrosscuttingMembersSet().getShadowMungers();
            class AdviceLocation {
                private final int lineNo;
                private final UnresolvedType inAspect;

                public AdviceLocation(BcelAdvice advice) {
                    this.lineNo = advice.getSourceLocation().getLine();
                    this.inAspect = advice.getDeclaringAspect();
                }

                public boolean equals(Object obj) {
                    if (!(obj instanceof AdviceLocation)) {
                        return false;
                    }
                    AdviceLocation other = (AdviceLocation)obj;
                    if (this.lineNo != other.lineNo) {
                        return false;
                    }
                    return this.inAspect.equals(other.inAspect);
                }

                public int hashCode() {
                    return 37 + 17 * this.lineNo + 17 * this.inAspect.hashCode();
                }
            }
            HashSet<AdviceLocation> alreadyWarnedLocations = new HashSet<AdviceLocation>();
            Iterator iter = l.iterator();
            while (iter.hasNext()) {
                AdviceLocation loc;
                BcelAdvice ba;
                ShadowMunger element = (ShadowMunger)iter.next();
                if (!(element instanceof BcelAdvice) || (ba = (BcelAdvice)element).hasMatchedSomething() || ba.getSignature() == null || alreadyWarnedLocations.contains(loc = new AdviceLocation(ba))) continue;
                alreadyWarnedLocations.add(loc);
                if (ba.getSignature() instanceof BcelMethod && Utility.isSuppressing(ba.getSignature(), "adviceDidNotMatch")) continue;
                this.world.getLint().adviceDidNotMatch.signal(ba.getDeclaringAspect().toString(), new SourceLocation(element.getSourceLocation().getSourceFile(), element.getSourceLocation().getLine()));
            }
        }
    }

    private void weaveParentsFor(List typesForWeaving, String typeToWeave) {
        ResolvedType rtx = this.world.resolve(typeToWeave);
        ResolvedType superType = rtx.getSuperclass();
        if (superType != null && typesForWeaving.contains(superType.getName())) {
            this.weaveParentsFor(typesForWeaving, superType.getName());
        }
        ResolvedType[] interfaceTypes = rtx.getDeclaredInterfaces();
        for (int i = 0; i < interfaceTypes.length; ++i) {
            ResolvedType rtxI = interfaceTypes[i];
            if (!typesForWeaving.contains(rtxI.getName())) continue;
            this.weaveParentsFor(typesForWeaving, rtxI.getName());
        }
        ContextToken tok = CompilationAndWeavingContext.enteringPhase(7, rtx.getName());
        this.weaveParentTypeMungers(rtx);
        CompilationAndWeavingContext.leavingPhase(tok);
        typesForWeaving.remove(typeToWeave);
    }

    public void prepareToProcessReweavableState() {
    }

    public void processReweavableStateIfPresent(String className, BcelObjectType classType) {
        WeaverStateInfo wsi = classType.getWeaverState();
        if (wsi != null && wsi.isReweavable()) {
            this.world.showMessage(IMessage.INFO, WeaverMessages.format("processingReweavable", className, classType.getSourceLocation().getSourceFile()), null, null);
            Set aspectsPreviouslyInWorld = wsi.getAspectsAffectingType();
            if (aspectsPreviouslyInWorld != null) {
                HashSet<String> alreadyConfirmedReweavableState = new HashSet<String>();
                Iterator iter = aspectsPreviouslyInWorld.iterator();
                while (iter.hasNext()) {
                    boolean exists;
                    String requiredTypeName = (String)iter.next();
                    if (alreadyConfirmedReweavableState.contains(requiredTypeName)) continue;
                    ResolvedType rtx = this.world.resolve(UnresolvedType.forName(requiredTypeName), true);
                    boolean bl = exists = !rtx.isMissing();
                    if (!exists) {
                        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("missingReweavableType", requiredTypeName, className), classType.getSourceLocation(), null);
                        continue;
                    }
                    if (!this.xcutSet.containsAspect(rtx)) {
                        this.world.showMessage(IMessage.ERROR, WeaverMessages.format("reweavableAspectNotRegistered", requiredTypeName, className), null, null);
                    } else if (!this.world.getMessageHandler().isIgnoring(IMessage.INFO)) {
                        this.world.showMessage(IMessage.INFO, WeaverMessages.format("verifiedReweavableType", requiredTypeName, rtx.getSourceLocation().getSourceFile()), null, null);
                    }
                    alreadyConfirmedReweavableState.add(requiredTypeName);
                }
            }
            classType.setJavaClass(Utility.makeJavaClass(classType.getJavaClass().getFileName(), wsi.getUnwovenClassFileData(classType.getJavaClass().getBytes())));
        }
    }

    private void weaveAndNotify(UnwovenClassFile classFile, BcelObjectType classType, IWeaveRequestor requestor) throws IOException {
        trace.enter("weaveAndNotify", (Object)this, new Object[]{classFile, classType, requestor});
        ContextToken tok = CompilationAndWeavingContext.enteringPhase(27, classType.getResolvedTypeX().getName());
        LazyClassGen clazz = this.weaveWithoutDump(classFile, classType);
        classType.finishedWith();
        if (clazz != null) {
            UnwovenClassFile[] newClasses = this.getClassFilesFor(clazz);
            if (newClasses[0].getClassName().equals(classFile.getClassName())) {
                newClasses[0].setClassNameAsChars(classFile.getClassNameAsChars());
            }
            for (int i = 0; i < newClasses.length; ++i) {
                requestor.acceptResult(newClasses[i]);
            }
        } else {
            requestor.acceptResult(classFile);
        }
        classType.weavingCompleted();
        CompilationAndWeavingContext.leavingPhase(tok);
        trace.exit("weaveAndNotify");
    }

    public BcelObjectType getClassType(String forClass) {
        return BcelWorld.getBcelObjectType(this.world.resolve(forClass));
    }

    public void addParentTypeMungers(String typeName) {
        this.weaveParentTypeMungers(this.world.resolve(typeName));
    }

    public void addNormalTypeMungers(String typeName) {
        this.weaveNormalTypeMungers(this.world.resolve(typeName));
    }

    public UnwovenClassFile[] getClassFilesFor(LazyClassGen clazz) {
        List childClasses = clazz.getChildClasses(this.world);
        UnwovenClassFile[] ret = new UnwovenClassFile[1 + childClasses.size()];
        ret[0] = new UnwovenClassFile(clazz.getFileName(), clazz.getClassName(), clazz.getJavaClassBytesIncludingReweavable(this.world));
        int index = 1;
        Iterator iter = childClasses.iterator();
        while (iter.hasNext()) {
            UnwovenClassFile.ChildClass element = (UnwovenClassFile.ChildClass)iter.next();
            UnwovenClassFile childClass = new UnwovenClassFile(clazz.getFileName() + "$" + element.name, element.bytes);
            ret[index++] = childClass;
        }
        return ret;
    }

    public void weaveParentTypeMungers(ResolvedType onType) {
        boolean typeChanged;
        if (onType.isRawType()) {
            onType = onType.getGenericType();
        }
        onType.clearInterTypeMungers();
        ArrayList<DeclareParents> decpToRepeat = new ArrayList<DeclareParents>();
        boolean aParentChangeOccurred = false;
        boolean anAnnotationChangeOccurred = false;
        Iterator i = this.declareParentsList.iterator();
        while (i.hasNext()) {
            DeclareParents decp = (DeclareParents)i.next();
            typeChanged = this.applyDeclareParents(decp, onType);
            if (typeChanged) {
                aParentChangeOccurred = true;
                continue;
            }
            decpToRepeat.add(decp);
        }
        i = this.xcutSet.getDeclareAnnotationOnTypes().iterator();
        while (i.hasNext()) {
            DeclareAnnotation decA = (DeclareAnnotation)i.next();
            typeChanged = this.applyDeclareAtType(decA, onType, true);
            if (!typeChanged) continue;
            anAnnotationChangeOccurred = true;
        }
        while ((aParentChangeOccurred || anAnnotationChangeOccurred) && !decpToRepeat.isEmpty()) {
            boolean typeChanged2;
            aParentChangeOccurred = false;
            anAnnotationChangeOccurred = false;
            ArrayList<DeclareParents> decpToRepeatNextTime = new ArrayList<DeclareParents>();
            Iterator iter = decpToRepeat.iterator();
            while (iter.hasNext()) {
                DeclareParents decp = (DeclareParents)iter.next();
                typeChanged2 = this.applyDeclareParents(decp, onType);
                if (typeChanged2) {
                    aParentChangeOccurred = true;
                    continue;
                }
                decpToRepeatNextTime.add(decp);
            }
            iter = this.xcutSet.getDeclareAnnotationOnTypes().iterator();
            while (iter.hasNext()) {
                DeclareAnnotation decA = (DeclareAnnotation)iter.next();
                typeChanged2 = this.applyDeclareAtType(decA, onType, false);
                if (!typeChanged2) continue;
                anAnnotationChangeOccurred = true;
            }
            decpToRepeat = decpToRepeatNextTime;
        }
    }

    private boolean applyDeclareAtType(DeclareAnnotation decA, ResolvedType onType, boolean reportProblems) {
        boolean didSomething = false;
        if (decA.matches(onType)) {
            if (onType.hasAnnotation(decA.getAnnotationX().getType())) {
                return false;
            }
            AnnotationAJ annoX = decA.getAnnotationX();
            boolean problemReported = this.verifyTargetIsOK(decA, onType, annoX, reportProblems);
            if (!problemReported) {
                AsmRelationshipProvider.getDefault().addDeclareAnnotationRelationship(decA.getSourceLocation(), onType.getSourceLocation());
                if (!this.getWorld().getMessageHandler().isIgnoring(IMessage.WEAVEINFO)) {
                    this.getWorld().getMessageHandler().handleMessage(WeaveMessage.constructWeavingMessage(WeaveMessage.WEAVEMESSAGE_ANNOTATES, new String[]{onType.toString(), Utility.beautifyLocation(onType.getSourceLocation()), decA.getAnnotationString(), "type", decA.getAspect().toString(), Utility.beautifyLocation(decA.getSourceLocation())}));
                }
                didSomething = true;
                AnnotationOnTypeMunger newAnnotationTM = new AnnotationOnTypeMunger(annoX);
                newAnnotationTM.setSourceLocation(decA.getSourceLocation());
                onType.addInterTypeMunger(new BcelTypeMunger(newAnnotationTM, decA.getAspect().resolve(this.world)));
                decA.copyAnnotationTo(onType);
            }
        }
        return didSomething;
    }

    private boolean verifyTargetIsOK(DeclareAnnotation decA, ResolvedType onType, AnnotationAJ annoX, boolean outputProblems) {
        boolean problemReported = false;
        if (annoX.specifiesTarget() && (onType.isAnnotation() && !annoX.allowedOnAnnotationType() || !annoX.allowedOnRegularType())) {
            if (outputProblems) {
                if (decA.isExactPattern()) {
                    this.world.getMessageHandler().handleMessage(MessageUtil.error(WeaverMessages.format("incorrectTargetForDeclareAnnotation", onType.getName(), annoX.getTypeName(), annoX.getValidTargets()), decA.getSourceLocation()));
                } else if (this.world.getLint().invalidTargetForAnnotation.isEnabled()) {
                    this.world.getLint().invalidTargetForAnnotation.signal(new String[]{onType.getName(), annoX.getTypeName(), annoX.getValidTargets()}, decA.getSourceLocation(), new ISourceLocation[]{onType.getSourceLocation()});
                }
            }
            problemReported = true;
        }
        return problemReported;
    }

    private boolean applyDeclareParents(DeclareParents p, ResolvedType onType) {
        boolean didSomething = false;
        List newParents = p.findMatchingNewParents(onType, true);
        if (!newParents.isEmpty()) {
            didSomething = true;
            BcelObjectType classType = BcelWorld.getBcelObjectType(onType);
            Iterator j = newParents.iterator();
            while (j.hasNext()) {
                ResolvedType newParent = (ResolvedType)j.next();
                classType.addParent(newParent);
                NewParentTypeMunger newParentMunger = new NewParentTypeMunger(newParent);
                newParentMunger.setSourceLocation(p.getSourceLocation());
                onType.addInterTypeMunger(new BcelTypeMunger(newParentMunger, this.xcutSet.findAspectDeclaringParents(p)));
            }
        }
        return didSomething;
    }

    public void weaveNormalTypeMungers(ResolvedType onType) {
        ContextToken tok = CompilationAndWeavingContext.enteringPhase(24, onType.getName());
        if (onType.isRawType() || onType.isParameterizedType()) {
            onType = onType.getGenericType();
        }
        Iterator i = this.typeMungerList.iterator();
        while (i.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i.next();
            if (m.isLateMunger() || !m.matches(onType)) continue;
            onType.addInterTypeMunger(m);
        }
        CompilationAndWeavingContext.leavingPhase(tok);
    }

    public LazyClassGen weaveWithoutDump(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        return this.weave(classFile, classType, false);
    }

    LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        LazyClassGen ret = this.weave(classFile, classType, true);
        return ret;
    }

    private LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType, boolean dump) throws IOException {
        if (classType.isSynthetic()) {
            if (dump) {
                this.dumpUnchanged(classFile);
            }
            return null;
        }
        List shadowMungers = this.fastMatch(this.shadowMungerList, classType.getResolvedTypeX());
        List typeMungers = classType.getResolvedTypeX().getInterTypeMungers();
        classType.getResolvedTypeX().checkInterTypeMungers();
        boolean mightNeedToWeave = shadowMungers.size() > 0 || typeMungers.size() > 0 || classType.isAspect() || this.world.getDeclareAnnotationOnMethods().size() > 0 || this.world.getDeclareAnnotationOnFields().size() > 0;
        boolean mightNeedBridgeMethods = this.world.isInJava5Mode() && !classType.isInterface() && classType.getResolvedTypeX().getInterTypeMungersIncludingSupers().size() > 0;
        LazyClassGen clazz = null;
        if (mightNeedToWeave || mightNeedBridgeMethods) {
            clazz = classType.getLazyClassGen();
            try {
                boolean isChanged = false;
                if (mightNeedToWeave) {
                    isChanged = BcelClassWeaver.weave(this.world, clazz, shadowMungers, typeMungers, this.lateTypeMungerList);
                }
                if (mightNeedBridgeMethods) {
                    boolean bl = isChanged = BcelClassWeaver.calculateAnyRequiredBridgeMethods(this.world, clazz) || isChanged;
                }
                if (isChanged) {
                    if (dump) {
                        this.dump(classFile, clazz);
                    }
                    return clazz;
                }
            }
            catch (RuntimeException re) {
                String classDebugInfo = null;
                try {
                    classDebugInfo = clazz.toLongString();
                }
                catch (Exception e) {
                    classDebugInfo = clazz.getClassName();
                }
                String messageText = "trouble in: \n" + classDebugInfo;
                this.getWorld().getMessageHandler().handleMessage(new Message(messageText, IMessage.ABORT, re, null));
            }
            catch (Error re) {
                String classDebugInfo = null;
                try {
                    classDebugInfo = clazz.toLongString();
                }
                catch (Exception e) {
                    classDebugInfo = clazz.getClassName();
                }
                String messageText = "trouble in: \n" + classDebugInfo;
                this.getWorld().getMessageHandler().handleMessage(new Message(messageText, IMessage.ABORT, re, null));
            }
        }
        if (dump) {
            this.dumpUnchanged(classFile);
            return clazz;
        }
        if (clazz != null && !clazz.getChildClasses(this.world).isEmpty()) {
            return clazz;
        }
        return null;
    }

    private void dumpUnchanged(UnwovenClassFile classFile) throws IOException {
        if (this.zipOutputStream != null) {
            this.writeZipEntry(this.getEntryName(classFile.getJavaClass().getClassName()), classFile.getBytes());
        } else {
            classFile.writeUnchangedBytes();
        }
    }

    private String getEntryName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private void dump(UnwovenClassFile classFile, LazyClassGen clazz) throws IOException {
        if (this.zipOutputStream != null) {
            String mainClassName = classFile.getJavaClass().getClassName();
            this.writeZipEntry(this.getEntryName(mainClassName), clazz.getJavaClass(this.world).getBytes());
            if (!clazz.getChildClasses(this.world).isEmpty()) {
                Iterator i = clazz.getChildClasses(this.world).iterator();
                while (i.hasNext()) {
                    UnwovenClassFile.ChildClass c = (UnwovenClassFile.ChildClass)i.next();
                    this.writeZipEntry(this.getEntryName(mainClassName + "$" + c.name), c.bytes);
                }
            }
        } else {
            classFile.writeWovenBytes(clazz.getJavaClass(this.world).getBytes(), clazz.getChildClasses(this.world));
        }
    }

    private void writeZipEntry(String name, byte[] bytes) throws IOException {
        ZipEntry newEntry = new ZipEntry(name);
        this.zipOutputStream.putNextEntry(newEntry);
        this.zipOutputStream.write(bytes);
        this.zipOutputStream.closeEntry();
    }

    private List fastMatch(List list, ResolvedType type) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        FastMatchInfo info = new FastMatchInfo(type, null);
        ArrayList<ShadowMunger> result = new ArrayList<ShadowMunger>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            FuzzyBoolean fb = munger.getPointcut().fastMatch(info);
            if (!fb.maybeTrue()) continue;
            result.add(munger);
        }
        return result;
    }

    public void setReweavableMode(boolean xNotReweavable) {
        if (trace.isTraceEnabled()) {
            trace.enter("setReweavableMode", (Object)this, xNotReweavable);
        }
        this.inReweavableMode = !xNotReweavable;
        WeaverStateInfo.setReweavableModeDefaults(!xNotReweavable, false, true);
        BcelClassWeaver.setReweavableMode(!xNotReweavable);
        if (trace.isTraceEnabled()) {
            trace.exit("setReweavableMode");
        }
    }

    public boolean isReweavable() {
        return this.inReweavableMode;
    }

    public World getWorld() {
        return this.world;
    }

    public void tidyUp() {
        if (trace.isTraceEnabled()) {
            trace.enter("tidyUp", this);
        }
        this.shadowMungerList = null;
        this.typeMungerList = null;
        this.lateTypeMungerList = null;
        this.declareParentsList = null;
        if (trace.isTraceEnabled()) {
            trace.exit("tidyUp");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

