/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl.requirement;

import io.fabric8.kubernetes.clnt.v3_1.DefaultKubernetesClient;
import io.fabric8.kubernetes.clnt.v3_1.utils.URLUtils;
import java.io.IOException;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.arquillian.cube.kubernetes.impl.requirement.RequiresKubernetes;
import org.arquillian.cube.spi.requirement.Constraint;
import org.arquillian.cube.spi.requirement.UnsatisfiedRequirementException;

public class KubernetesRequirement
implements Constraint<RequiresKubernetes> {
    public void check(RequiresKubernetes context) throws UnsatisfiedRequirementException {
        DefaultKubernetesClient client = new DefaultKubernetesClient();
        OkHttpClient httpClient = (OkHttpClient)client.adapt(OkHttpClient.class);
        Request versionRequest = new Request.Builder().get().url(URLUtils.join((String[])new String[]{client.getMasterUrl().toString(), "version"})).build();
        try {
            Response response = httpClient.newCall(versionRequest).execute();
            if (!response.isSuccessful()) {
                throw new UnsatisfiedRequirementException("Failed to verify kubernetes version, due to: [" + response.message() + "]");
            }
        }
        catch (IOException e) {
            throw new UnsatisfiedRequirementException("Error while checking kubernetes version: [" + e.getMessage() + "]");
        }
    }
}

