/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.kubernetes.impl;

import org.arquillian.cube.kubernetes.api.Configuration;
import org.arquillian.cube.kubernetes.api.Logger;
import org.arquillian.cube.kubernetes.impl.DefaultSession;
import org.arquillian.cube.kubernetes.impl.SessionCreatedEvent;
import org.arquillian.cube.kubernetes.impl.event.Start;
import org.arquillian.cube.kubernetes.impl.event.Stop;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.InstanceProducer;
import org.jboss.arquillian.core.api.annotation.ApplicationScoped;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;

public class SuiteListener {
    @Inject
    @ApplicationScoped
    private InstanceProducer<DefaultSession> sessionProducer;
    @Inject
    private Event<SessionCreatedEvent> controlEvent;
    private DefaultSession session;

    public void start(@Observes(precedence=100) BeforeSuite event, Configuration configuration, Logger logger) {
        this.session = new DefaultSession(configuration.getSessionId(), configuration.getNamespace(), logger);
        this.session.init();
        this.sessionProducer.set((Object)this.session);
        this.controlEvent.fire((Object)new Start(this.session));
    }

    public void stop(@Observes(precedence=-100) AfterSuite event, Logger logger) {
        this.controlEvent.fire((Object)new Stop(this.session));
        this.session.destroy();
    }
}

