/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities.delayed;

import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.appsweaver.commons.utilities.delayed.DelayStrategy;
import org.appsweaver.commons.utilities.delayed.DelayedWork;

public class Delayer {
    private static void doDelayedWork(DelayStrategy delayStrategy, int delay, TimeUnit timeUnit, DelayedWork work) {
        Optional<DelayedWork> optionalWork = Optional.ofNullable(work);
        if (optionalWork.isPresent()) {
            optionalWork.get().execute();
        }
        if (!delayStrategy.ok()) {
            try {
                timeUnit.sleep(delay);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static void runWithMaxRetries(DelayStrategy delayStrategy, int delay, TimeUnit timeUnit, int max) {
        Delayer.runWithMaxRetries(delayStrategy, delay, timeUnit, max, null);
    }

    public static void runWithMaxRetries(DelayStrategy delayStrategy, int delay, TimeUnit timeUnit, int max, DelayedWork work) {
        int count = 0;
        do {
            Delayer.doDelayedWork(delayStrategy, delay, timeUnit, work);
        } while (count++ < max && !delayStrategy.ok());
    }

    public static void runUntilDone(DelayStrategy delayStrategy, int delay, TimeUnit timeUnit) {
        Delayer.runUntilDone(delayStrategy, delay, timeUnit, null);
    }

    public static void runUntilDone(DelayStrategy delayStrategy, int delay, TimeUnit timeUnit, DelayedWork work) {
        do {
            Delayer.doDelayedWork(delayStrategy, delay, timeUnit, work);
        } while (!delayStrategy.ok());
    }
}

