/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import com.github.drapostolos.typeparser.TypeParser;
import java.util.Collection;
import java.util.HashSet;
import org.appsweaver.commons.utilities.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverter {
    static final Logger logger = LoggerFactory.getLogger(TypeConverter.class);

    public static <T> T valueOf(Object value, Class<T> clazz) {
        TypeParser parser = TypeParser.newBuilder().build();
        return (T)parser.parse(String.valueOf(value), clazz);
    }

    public static <T> Collection<T> toListCollection(String value, Class<T> clazz) {
        Collection<T> collection = TypeConverter.convert(value, clazz);
        return collection;
    }

    public static <T> Collection<T> toSetCollection(String value, Class<T> clazz) {
        Collection<T> collection = TypeConverter.convert(value, clazz);
        return collection;
    }

    static <T> Collection<T> convert(String value, Class<T> clazz) {
        String[] tokens;
        HashSet collection = Collections.newHashSet();
        for (String token : tokens = value.split(",")) {
            try {
                collection.add(TypeConverter.valueOf(token.trim(), clazz));
            }
            catch (Throwable t) {
                logger.warn("Error parsing collection [value={}; class={}]", new Object[]{token, clazz, t});
            }
        }
        return collection;
    }
}

