/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.WordUtils;
import org.appsweaver.commons.utilities.Collections;

public class Stringizer {
    static final Pattern BASE64_TEXT_PATTERN = Pattern.compile("^([A-Za-z0-9+/]{4})*([A-Za-z0-9+/]{3}=|[A-Za-z0-9+/]{2}==)?$");

    public static List<String> fileToLines(String filename) throws Exception {
        LinkedList<String> lines = new LinkedList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), "UTF-8"));){
            String line;
            while ((line = in.readLine()) != null) {
                lines.add(line);
            }
            LinkedList<String> linkedList = lines;
            return linkedList;
        }
    }

    public static String extract(String text, String regex, int position) {
        String[] split = text.split(regex);
        if (split != null && split.length > position) {
            return split[position];
        }
        return null;
    }

    public static List<String> toStringList(String text, String delimiter) {
        String[] values = text.split(delimiter);
        List<String> trimmed = Collections.newList();
        for (String value : values) {
            trimmed.add(value.trim());
        }
        return trimmed;
    }

    public static List<String> toStringList(String text, String delimiter, int limit) {
        String[] values = text.split(delimiter, limit);
        List<String> trimmed = Collections.newList();
        for (String value : values) {
            trimmed.add(value.trim());
        }
        return trimmed;
    }

    public static List<String> toList(String arrayString) {
        return Arrays.asList(arrayString.replaceAll("\\[", "").replaceAll("\\]", "").replaceAll("\\s", "").replaceAll("\"", "").split(","));
    }

    public static <T> String toCSVString(T[] values) {
        return Stringizer.toCSVString(Arrays.asList(values));
    }

    public static <T> String toCSVString(Collection<T> values) {
        List stringValues = Collections.newList();
        values.forEach(value -> stringValues.add(String.valueOf(value)));
        return String.join((CharSequence)", ", stringValues);
    }

    public static String trimAll(String limsProjectId) {
        return limsProjectId.replaceAll("\\s+", "");
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static byte[] mapToBytes(Map<String, Object> map) {
        try {
            Throwable throwable = null;
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                byte[] byArray;
                Throwable throwable2;
                ObjectOutputStream output;
                block30: {
                    block31: {
                        output = new ObjectOutputStream(outputStream);
                        throwable2 = null;
                        output.writeObject(map);
                        byArray = outputStream.toByteArray();
                        if (output == null) break block30;
                        if (throwable2 == null) break block31;
                        try {
                            output.close();
                        }
                        catch (Throwable throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        break block30;
                    }
                    output.close();
                }
                return byArray;
                catch (Throwable throwable4) {
                    try {
                        try {
                            try {
                                throwable2 = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (output != null) {
                                    if (throwable2 != null) {
                                        try {
                                            output.close();
                                        }
                                        catch (Throwable throwable6) {
                                            throwable2.addSuppressed(throwable6);
                                        }
                                    } else {
                                        output.close();
                                    }
                                }
                                throw throwable5;
                            }
                        }
                        catch (Throwable throwable7) {
                        }
                    }
                    catch (Throwable throwable8) {
                        throwable = throwable8;
                        throw throwable8;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Object> bytesToMap(byte[] bytes) {
        try {
            Throwable throwable;
            ObjectInputStream in;
            block28: {
                Map map;
                ByteArrayInputStream bis;
                block31: {
                    bis = new ByteArrayInputStream(bytes);
                    Throwable throwable2 = null;
                    try {
                        block29: {
                            block30: {
                                in = new ObjectInputStream(bis);
                                throwable = null;
                                try {
                                    Map map2;
                                    Object object = in.readObject();
                                    if (!(object instanceof Map)) break block28;
                                    map = map2 = (Map)object;
                                    if (in == null) break block29;
                                    if (throwable == null) break block30;
                                }
                                catch (Throwable throwable3) {
                                    try {
                                        throwable = throwable3;
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        if (in == null) throw throwable4;
                                        if (throwable != null) {
                                            try {
                                                in.close();
                                                throw throwable4;
                                            }
                                            catch (Throwable throwable5) {
                                                throwable.addSuppressed(throwable5);
                                                throw throwable4;
                                            }
                                        }
                                        in.close();
                                        throw throwable4;
                                    }
                                }
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                                break block29;
                            }
                            in.close();
                        }
                        if (bis == null) return map;
                        if (throwable2 == null) break block31;
                    }
                    catch (Throwable throwable7) {
                        // empty catch block
                        return null;
                    }
                    catch (Throwable throwable8) {
                        throw throwable8;
                    }
                    try {
                        bis.close();
                        return map;
                    }
                    catch (Throwable throwable9) {
                        throwable2.addSuppressed(throwable9);
                        return map;
                    }
                }
                bis.close();
                return map;
            }
            if (in == null) return null;
            if (throwable == null) {
                in.close();
                return null;
            }
            try {
                in.close();
                return null;
            }
            catch (Throwable throwable10) {
                throwable.addSuppressed(throwable10);
                return null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static String encodeSHA512(String text) throws Throwable {
        MessageDigest md = MessageDigest.getInstance("SHA-512");
        md.update(text.getBytes("UTF-8"));
        byte[] digest = md.digest();
        String encoded = Stringizer.encodeBase64(digest);
        return Stringizer.toHex(encoded);
    }

    public static String fromHex(String hex) {
        byte[] binary = new byte[hex.length() / 2];
        for (int i = 0; i < binary.length; ++i) {
            binary[i] = (byte)Integer.parseInt(hex.substring(2 * i, 2 * i + 2), 16);
        }
        return new String(binary);
    }

    public static String toHex(String text) {
        BigInteger bi;
        String hex;
        byte[] array = text.getBytes();
        int paddingLength = array.length * 2 - (hex = (bi = new BigInteger(1, array)).toString(16)).length();
        if (paddingLength > 0) {
            return String.format("%0" + paddingLength + "d", 0) + hex;
        }
        return hex;
    }

    public static boolean isBase64(String text) {
        Matcher matcher = BASE64_TEXT_PATTERN.matcher(text);
        return matcher.matches();
    }

    public static String encodeBase64(byte[] text) throws Throwable {
        return Base64.encodeBase64String((byte[])text);
    }

    public static String decodeBase64(byte[] text, Charset charset) throws Throwable {
        byte[] base64Decoded = Base64.decodeBase64((byte[])text);
        return new String(base64Decoded, charset);
    }

    public static String encodeBase64(String text) throws Throwable {
        if (!Stringizer.isBase64(text)) {
            return Stringizer.encodeBase64(text.getBytes());
        }
        return text;
    }

    public static String decodeBase64(String text) throws Throwable {
        if (Stringizer.isBase64(text)) {
            return Stringizer.decodeBase64(text.getBytes(), Charset.forName("UTF-8"));
        }
        return text;
    }

    public static String repeat(String text, int count) {
        return StringUtils.repeat((String)text, (int)count);
    }

    public static byte[] randomBytes(int length) {
        byte[] bytes = new byte[length];
        new Random().nextBytes(bytes);
        return bytes;
    }

    public static String getLastWord(String text) {
        String[] words = text.trim().split("\\s+");
        return words[words.length - 1];
    }

    public static boolean isNumeric(String text) {
        return StringUtils.isNumeric((CharSequence)text);
    }

    public static String capitalize(String text) {
        return WordUtils.capitalizeFully((String)text);
    }

    public static String dehyphenate(String text) {
        String dehypenated = StringUtils.replaceAll((String)text, (String)"[_-]", (String)" ");
        return dehypenated;
    }

    public static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    public static boolean isValidEmailAddress(String emailAddress) {
        if (Stringizer.isEmpty(emailAddress)) {
            return false;
        }
        boolean result = true;
        try {
            InternetAddress internetAddress = new InternetAddress(emailAddress);
            if (!Stringizer.hasUserAndDomainNames(emailAddress)) {
                result = false;
            }
        }
        catch (Throwable t) {
            result = false;
        }
        return result;
    }

    private static boolean hasUserAndDomainNames(String emailAddress) {
        String[] tokens = emailAddress.split("@");
        return tokens.length == 2 && !Stringizer.isEmpty(tokens[0]) && !Stringizer.isEmpty(tokens[1]);
    }
}

