/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public final class SeekableFileReader
implements AutoCloseable {
    private static final Charset defaultCharset = Charset.forName("UTF-8");
    final InputStream inputStream;
    final LineIterator lineIterator;
    long lineReadCount = -1L;

    public SeekableFileReader(InputStream inputStream, Charset charset) throws IOException {
        this.inputStream = inputStream;
        this.lineReadCount = 1L;
        this.lineIterator = IOUtils.lineIterator((InputStream)inputStream, (Charset)charset);
    }

    public SeekableFileReader(InputStream inputStream) throws IOException {
        this(inputStream, defaultCharset);
    }

    public SeekableFileReader(File file, Charset charsetName) throws IOException {
        this(new FileInputStream(file), charsetName);
    }

    public SeekableFileReader(File file) throws IOException {
        this(file, defaultCharset);
    }

    public long seek() {
        return this.seek(this.lineReadCount);
    }

    public long seek(long line) {
        long lineCount;
        for (lineCount = 1L; this.lineIterator != null && this.lineIterator.hasNext() && lineCount < line; ++lineCount) {
            this.lineIterator.nextLine();
        }
        if (lineCount < line) {
            throw new NoSuchElementException(String.format("Invalid line number [lineNumber=%s]", line));
        }
        this.lineReadCount = lineCount;
        return lineCount;
    }

    @Override
    public void close() {
        try {
            this.inputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.lineIterator.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean hasNext() {
        return this.lineIterator.hasNext();
    }

    public String readLine() throws Exception {
        if (this.hasNext()) {
            String nextLine = this.lineIterator.nextLine();
            ++this.lineReadCount;
            return nextLine;
        }
        return null;
    }

    public long getLineReadCount() {
        return this.lineReadCount;
    }
}

