/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.appsweaver.commons.utilities.Collections;

public class ReflectionHelper {
    public static String getMethodNameByDepth(int depth) {
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        if (depth >= stackTraceElements.length) {
            throw new RuntimeException("Depth is beyond the current stacktrace");
        }
        return stackTraceElements[depth].getMethodName();
    }

    public static String getCurrentMethodName() {
        return ReflectionHelper.getMethodNameByDepth(3);
    }

    public static Collection<Field> getAllFields(Class<?> clazz) {
        HashMap<String, Field> fields = Collections.newHashMap();
        ReflectionHelper.getAllFields(clazz, fields);
        return fields.values();
    }

    static Map<String, Field> getAllFields(Class<?> clazz, Map<String, Field> fields) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        if (clazz.getSuperclass() != null) {
            fields = ReflectionHelper.getAllFields(clazz.getSuperclass(), fields);
        }
        return fields;
    }

    public static Field getField(Class<?> clazz, String fieldName) {
        Map<String, Field> fields = ReflectionHelper.getAllFields(clazz, Collections.newHashMap());
        return fields.get(fieldName);
    }

    public static boolean hasField(Class<?> clazz, String fieldName) {
        Map<String, Field> fields = ReflectionHelper.getAllFields(clazz, Collections.newHashMap());
        return fields.containsKey(fieldName);
    }

    public static Map<String, Method> getAllMethods(Class<?> clazz, Map<String, Method> methods) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = clazz.getDeclaredMethods()) {
            methods.put(method.getName(), method);
        }
        if (clazz.getSuperclass() != null) {
            methods = ReflectionHelper.getAllMethods(clazz.getSuperclass(), methods);
        }
        return methods;
    }

    public static boolean hasMethod(Class<?> clazz, String methodName) {
        Map<String, Method> fields = ReflectionHelper.getAllMethods(clazz, new HashMap<String, Method>(0));
        return fields.containsKey(methodName);
    }

    public static Object getProperty(Object bean, String name) {
        try {
            Object object = PropertyUtils.getNestedProperty((Object)bean, (String)name);
            return object;
        }
        catch (Throwable t) {
            return null;
        }
    }
}

