/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import java.io.File;
import java.util.List;
import java.util.TreeMap;
import org.appsweaver.commons.utilities.Collections;
import org.appsweaver.commons.utilities.Fileinator;

public class PagedFileReader {
    final List<String> lines = Collections.newList();
    final File file;
    final boolean lineNumbered;
    final Long size;

    public PagedFileReader(String path, boolean lineNumbered) throws Throwable {
        if (path == null) {
            throw new Throwable("Given file path is null");
        }
        this.lineNumbered = lineNumbered;
        this.file = new File(path);
        if (!this.file.exists()) {
            throw new Throwable(String.format("File [%s] does not exist!", this.file.getAbsolutePath()));
        }
        this.size = Fileinator.countLines(this.file);
    }

    public void readLines(int start, int count) throws Exception {
        String format = String.format("%%%dd: %%s", String.valueOf(this.size).length() - 1);
        TreeMap<Long, String> lines = Fileinator.read(this.file, start, count);
        int keyOffset = start <= 0 ? 1 : 0;
        lines.forEach((key, value) -> {
            if (this.lineNumbered) {
                this.lines.add(String.format(format, key + (long)keyOffset, value));
            } else {
                this.lines.add(String.format("%s", value));
            }
        });
    }

    public List<String> getLines() {
        return this.lines;
    }

    public boolean isLineNumbered() {
        return this.lineNumbered;
    }

    public Long getSize() {
        return this.size;
    }
}

