/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.LongSerializationPolicy;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.appsweaver.commons.models.types.ParameterizedListType;

public class Jsonifier {
    public static <T> String toJson(T object) {
        Gson gson = Jsonifier.newGson();
        return gson.toJson(object);
    }

    public static <T> T toInstance(JsonElement json, Class<T> clazz) {
        Gson gson = Jsonifier.newGson();
        return (T)gson.fromJson(json, clazz);
    }

    public static <T> T toInstance(String json, Class<T> clazz, Map<Class<?>, JsonDeserializer<?>> map) {
        Gson gson = Jsonifier.newGson(map);
        return (T)gson.fromJson(json, clazz);
    }

    public static <T> List<T> toList(JsonElement json, Class<T> clazz) {
        Gson gson = Jsonifier.newGson();
        return (List)gson.fromJson(json, new ParameterizedListType<T>(clazz));
    }

    public static <T> List<T> toList(String json, Class<T> clazz) {
        Gson gson = Jsonifier.newGson();
        return (List)gson.fromJson(json, new ParameterizedListType<T>(clazz));
    }

    private static Gson newGson() {
        return Jsonifier.newGson(null);
    }

    private static Gson newGson(Map<Class<?>, JsonDeserializer<?>> map) {
        GsonBuilder gsonBuilder = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().setLongSerializationPolicy(LongSerializationPolicy.STRING).serializeSpecialFloatingPointValues();
        if (map != null) {
            map.forEach((clazz, deserializer) -> gsonBuilder.registerTypeAdapter((Type)clazz, deserializer));
        }
        return gsonBuilder.create();
    }

    public static <T> T toInstance(byte[] json, Type type) {
        Gson gson = Jsonifier.newGson();
        return (T)gson.fromJson(new String(json), type);
    }

    public static <T> T toInstance(byte[] json, Class<T> clazz) {
        Gson gson = Jsonifier.newGson();
        return (T)gson.fromJson(new String(json), clazz);
    }

    public static <T> T toInstance(String json, Class<T> clazz) {
        Gson gson = Jsonifier.newGson();
        return (T)gson.fromJson(json, clazz);
    }

    public static byte[] toBytes(Map<String, String> map) {
        return map == null ? null : Jsonifier.toJson(map).getBytes();
    }

    public static Map<String, String> toMap(byte[] bytes) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return bytes == null ? null : (Map)Jsonifier.toInstance(bytes, type);
    }

    public static Map<String, String> toMap(String data) {
        Type type = new TypeToken<Map<String, String>>(){}.getType();
        return data == null ? null : (Map)Jsonifier.toInstance(data.getBytes(), type);
    }

    public static boolean isValid(String json) {
        try {
            Gson gson = Jsonifier.newGson();
            gson.fromJson(json, Object.class);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

