/*
 * Decompiled with CFR 0.152.
 */
package org.appsweaver.commons.utilities;

import com.google.common.io.LineProcessor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.appsweaver.commons.utilities.SeekableFileReader;
import org.appsweaver.commons.utilities.command.CommandRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fileinator {
    static final Logger logger = LoggerFactory.getLogger(Fileinator.class);
    static final String BACKUP_FILE_SUFFIX_PART = ".bak";

    public static Stream<String> grep(String pattern, File file) throws Throwable {
        return Files.lines(file.toPath()).filter(line -> line.matches(pattern));
    }

    public static boolean exists(String path) {
        File file = new File(path);
        return file.exists();
    }

    public static boolean mkdirs(String path) {
        File file = new File(path);
        return file.mkdirs();
    }

    public static void saveToFile(File file, String content, boolean append) throws Throwable {
        Fileinator.saveToFile(file, content.getBytes(), append);
    }

    public static void saveToFile(File file, byte[] content, boolean append) throws Throwable {
        FileUtils.writeByteArrayToFile((File)file, (byte[])content, (boolean)append);
    }

    public static void saveToFile(File file, List<String> content, boolean append) throws Throwable {
        FileUtils.writeLines((File)file, (String)Charset.defaultCharset().name(), content, (boolean)append);
    }

    public static void saveToFile(File file, String content, boolean append, boolean archive) throws Throwable {
        Fileinator.saveToFile(file, content.getBytes(), append, archive);
    }

    public static void saveToFile(File file, byte[] content, boolean append, boolean archive) throws Throwable {
        if (file.exists() && file.isFile() && file.length() > 0L && archive) {
            logger.debug("To backup file {} with size {} ", (Object)file.getPath(), (Object)file.length());
            Fileinator.backupFile(file, BACKUP_FILE_SUFFIX_PART);
        }
        FileUtils.writeByteArrayToFile((File)file, (byte[])content, (boolean)append);
    }

    public static String toString(BufferedReader bufferedReader) throws Throwable {
        return IOUtils.toString((Reader)bufferedReader);
    }

    public static String toString(InputStream inputStream) throws Throwable {
        return IOUtils.toString((InputStream)inputStream, (Charset)Charset.forName("UTF-8"));
    }

    public static String toString(File file) throws Throwable {
        try (FileInputStream stream = new FileInputStream(file);){
            String string = Fileinator.toString(stream);
            return string;
        }
    }

    public static void delete(File file) throws Throwable {
        if (file.isFile()) {
            FileUtils.forceDelete((File)file);
        } else if (file.isDirectory()) {
            FileUtils.deleteDirectory((File)file);
        }
    }

    public static void delete(String filePath, boolean archive) {
        File file = new File(filePath);
        if (file.exists() && file.isFile()) {
            if (archive && file.length() > 0L) {
                logger.debug("Before delete : To backup file {} with size {} ", (Object)file.getPath(), (Object)file.length());
                Fileinator.backupFile(file, BACKUP_FILE_SUFFIX_PART);
            }
            file.delete();
        }
    }

    private static void backupFile(File file, String suffix) {
        StringBuilder newFileName = new StringBuilder();
        String existingFilePath = file.getAbsolutePath();
        newFileName.append(existingFilePath).append(FilenameUtils.EXTENSION_SEPARATOR_STR).append(suffix).append(Calendar.getInstance().getTimeInMillis());
        String newFilePath = newFileName.toString();
        File backUpFile = new File(newFilePath);
        try {
            Files.copy(file.toPath(), backUpFile.toPath(), new CopyOption[0]);
            logger.debug("Copied file {} to file = {} with size = {}", new Object[]{existingFilePath, newFilePath, backUpFile.length()});
        }
        catch (IOException e) {
            logger.warn("Error copying file [source={}, target={}]", new Object[]{existingFilePath, newFilePath, e});
        }
    }

    public static Stream<String> stream(File file) throws Throwable {
        return Files.lines(file.toPath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean contains(File file, String pattern) {
        if (!file.exists()) return false;
        try (Stream<String> matchingLines = Fileinator.grep(pattern, file);){
            boolean bl = matchingLines.count() > 0L;
            return bl;
        }
        catch (Throwable throwable6) {
            // empty catch block
        }
        return false;
    }

    public static File[] find(String directory, String pattern) {
        File dir = new File(directory);
        WildcardFileFilter fileFilter = new WildcardFileFilter(pattern);
        File[] files = dir.listFiles((FileFilter)fileFilter);
        return files;
    }

    public static Long getDirectorySizeInBytes(String path, boolean followLinks) throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add("du");
        if (followLinks) {
            command.add("-skL");
        } else {
            command.add("-sk");
        }
        command.add(path);
        logger.info("Executing command: {}", (Object)((Object)command).toString());
        CommandRunner commandRunner = new CommandRunner();
        List<String> output = commandRunner.runCommand((String[])command.stream().toArray(String[]::new));
        logger.info("Result command: {} {}", (Object)((Object)command).toString(), output);
        if (output.size() > 0) {
            return Long.parseLong(output.get(0).replaceAll("^\\D*(\\d+).*", "$1")) * 1024L;
        }
        return 0L;
    }

    public static long countLines(File file) throws Exception {
        try {
            long count = (Long)com.google.common.io.Files.asCharSource((File)file, (Charset)Charset.defaultCharset()).readLines((LineProcessor)new LineProcessor<Long>(){
                long count = 0L;

                public Long getResult() {
                    return this.count;
                }

                public boolean processLine(String line) {
                    ++this.count;
                    return true;
                }
            });
            return count;
        }
        catch (Exception e) {
            logger.warn("Error counting lines [file={}]", (Object)file.getAbsolutePath(), (Object)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TreeMap<Long, String> read(File file, int start, int count) throws Exception {
        long startValue = start < 0 ? 0L : (long)start;
        long countValue = count < -1 || (long)count > Long.MAX_VALUE ? 25L : (long)count;
        TreeMap<Long, String> lines = new TreeMap<Long, String>();
        try (SeekableFileReader seekableFileReader = new SeekableFileReader(file);){
            seekableFileReader.seek(startValue);
            String line = null;
            for (long lineCount = 0L; (line = seekableFileReader.readLine()) != null && lineCount < countValue; ++lineCount) {
                lines.put(startValue + lineCount, line);
            }
            TreeMap<Long, String> treeMap = lines;
            return treeMap;
        }
        catch (Exception e) {
            logger.warn("Error reading file [file={}]", (Object)file.getAbsolutePath(), (Object)e);
            throw e;
        }
    }

    public static void append(String path, String content) throws Throwable {
        Path pathToFile = Paths.get(path, new String[0]);
        Files.createDirectories(pathToFile.getParent(), new FileAttribute[0]);
        Files.createFile(pathToFile, new FileAttribute[0]);
        File file = new File(path);
        try (FileWriter writer = new FileWriter(file, true);){
            writer.write(content);
        }
    }
}

